/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5632;

public class BasicStorageCell
extends AEBaseItem
implements IBasicCellItem,
AEToolItem {
    protected final class_1935 coreItem;
    protected final class_1935 housingItem;
    protected final double idleDrain;
    protected final int totalBytes;
    protected final int bytesPerType;
    protected final int totalTypes;
    private final AEKeyType keyType;

    public BasicStorageCell(class_1792.class_1793 properties, class_1935 coreItem, class_1935 housingItem, double idleDrain, int kilobytes, int bytesPerType, int totalTypes, AEKeyType keyType) {
        super(properties);
        this.idleDrain = idleDrain;
        this.totalBytes = kilobytes * 1024;
        this.coreItem = coreItem;
        this.housingItem = housingItem;
        this.bytesPerType = bytesPerType;
        this.totalTypes = totalTypes;
        this.keyType = keyType;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        this.addCellInformationToTooltip(stack, lines);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return this.getCellTooltipImage(stack);
    }

    @Override
    public AEKeyType getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return this.totalTypes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return this.bytesPerType;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, this.keyType == AEKeyType.items() ? 4 : 3);
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(this.keyType.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        this.disassembleDrive(player.method_5998(hand), level, player);
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)player.method_5998(hand));
    }

    private boolean disassembleDrive(class_1799 stack, class_1937 level, class_1657 player) {
        if (InteractionUtil.isInAlternateUseMode(player)) {
            if (level.method_8608()) {
                return false;
            }
            class_1661 playerInventory = player.method_31548();
            StorageCell inv = StorageCells.getCellInventory(stack, null);
            if (inv != null && playerInventory.method_7391() == stack) {
                KeyCounter list = inv.getAvailableStacks();
                if (list.isEmpty()) {
                    playerInventory.method_5447(playerInventory.field_7545, class_1799.field_8037);
                    playerInventory.method_7398(new class_1799(this.coreItem));
                    for (class_1799 upgrade : this.getUpgrades(stack)) {
                        playerInventory.method_7398(upgrade);
                    }
                    playerInventory.method_7398(new class_1799(this.housingItem));
                    return true;
                }
                player.method_7353((class_2561)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return this.disassembleDrive(stack, context.method_8045(), context.method_8036()) ? class_1269.method_29236((boolean)context.method_8045().method_8608()) : class_1269.field_5811;
    }

    public static int getColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 1) {
            StorageCell cellInv = StorageCells.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        return 0xFFFFFF;
    }
}

