/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.mdast;

import appeng.libs.mdast.MdastContext;
import appeng.libs.mdast.model.MdAstRoot;
import appeng.libs.micromark.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MdastExtension {
    public final List<String> canContainEols;
    public final List<Transform> transforms;
    public final Map<String, Handler> enter;
    public final Map<String, Handler> exit;

    public MdastExtension(List<String> canContainEols, List<Transform> transforms, Map<String, Handler> enter, Map<String, Handler> exit) {
        this.canContainEols = List.copyOf(canContainEols);
        this.transforms = List.copyOf(transforms);
        this.enter = Map.copyOf(enter);
        this.exit = Map.copyOf(exit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> canContainEols = new ArrayList<String>();
        private final List<Transform> transforms = new ArrayList<Transform>();
        private final Map<String, Handler> enter = new HashMap<String, Handler>();
        private final Map<String, Handler> exit = new HashMap<String, Handler>();

        private Builder() {
        }

        public Builder enter(String type, Handler handler) {
            this.enter.put(type, handler);
            return this;
        }

        public Builder enter(String type, Runnable handler) {
            this.enter.put(type, (context, token) -> handler.run());
            return this;
        }

        public Builder exit(String type, Handler handler) {
            this.exit.put(type, handler);
            return this;
        }

        public Builder exit(String type, Runnable handler) {
            this.exit.put(type, (context, token) -> handler.run());
            return this;
        }

        public Builder canContainEol(String ... types) {
            Collections.addAll(this.canContainEols, types);
            return this;
        }

        public Builder transform(Transform transform) {
            this.transforms.add(transform);
            return this;
        }

        public Builder addAll(MdastExtension extension) {
            this.canContainEols.addAll(extension.canContainEols);
            this.transforms.addAll(extension.transforms);
            this.enter.putAll(extension.enter);
            this.exit.putAll(extension.exit);
            return this;
        }

        public MdastExtension build() {
            return new MdastExtension(this.canContainEols, this.transforms, this.enter, this.exit);
        }
    }

    @FunctionalInterface
    public static interface Handler {
        public void handle(MdastContext var1, Token var2);
    }

    @FunctionalInterface
    public static interface Transform {
        public MdAstRoot transform(MdAstRoot var1);
    }
}

