/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark.commonmark;

import appeng.libs.micromark.Assert;
import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.Construct;
import appeng.libs.micromark.State;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.factory.FactorySpace;

public final class BlockQuote {
    public static final Construct blockQuote = new Construct();

    private BlockQuote() {
    }

    private static void exit(TokenizeContext context, Tokenizer.Effects effects) {
        effects.exit("blockQuote");
    }

    static {
        BlockQuote.blockQuote.name = "blockQuote";
        BlockQuote.blockQuote.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        BlockQuote.blockQuote.continuation = new Construct();
        BlockQuote.blockQuote.continuation.tokenize = (context, effects, ok, nok) -> FactorySpace.create(effects, effects.attempt.hook(blockQuote, ok, nok), "linePrefix", context.getParser().constructs.nullDisable.contains("codeIndented") ? Integer.MAX_VALUE : 4);
        BlockQuote.blockQuote.exit = BlockQuote::exit;
    }

    static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        State start(int code) {
            if (code == 62) {
                Tokenizer.ContainerState state = this.context.getContainerState();
                Assert.check(state != null, "expected `containerState` to be defined in container");
                if (!state.containsKey("open")) {
                    Token token = new Token();
                    token._container = true;
                    this.effects.enter("blockQuote", token);
                    state.put("open", true);
                }
                this.effects.enter("blockQuotePrefix");
                this.effects.enter("blockQuoteMarker");
                this.effects.consume(code);
                this.effects.exit("blockQuoteMarker");
                return this::after;
            }
            return this.nok.step(code);
        }

        State after(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.enter("blockQuotePrefixWhitespace");
                this.effects.consume(code);
                this.effects.exit("blockQuotePrefixWhitespace");
                this.effects.exit("blockQuotePrefix");
                return this.ok;
            }
            this.effects.exit("blockQuotePrefix");
            return this.ok.step(code);
        }
    }
}

