/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.service;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.GridBootingStatusChange;
import appeng.api.networking.spatial.ISpatialService;
import appeng.blockentity.spatial.SpatialIOPortBlockEntity;
import appeng.blockentity.spatial.SpatialPylonBlockEntity;
import appeng.core.AEConfig;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class SpatialPylonService
implements ISpatialService,
IGridServiceProvider {
    private final IGrid myGrid;
    private long powerRequired = 0L;
    private double efficiency = 0.0;
    private class_3218 captureLevel;
    private class_2338 captureMin;
    private class_2338 captureMax;
    private boolean isValid = false;
    private List<SpatialIOPortBlockEntity> ioPorts = new ArrayList<SpatialIOPortBlockEntity>();
    private HashMap<SpatialPylonCluster, SpatialPylonCluster> clusters = new HashMap();

    public SpatialPylonService(IGrid g) {
        this.myGrid = g;
    }

    public void bootingRender(GridBootingStatusChange c) {
        this.reset(this.myGrid);
    }

    private void reset(IGrid grid) {
        this.clusters = new HashMap();
        this.ioPorts = new ArrayList<SpatialIOPortBlockEntity>();
        for (IGridNode gm : grid.getMachineNodes(SpatialIOPortBlockEntity.class)) {
            this.ioPorts.add((SpatialIOPortBlockEntity)gm.getOwner());
        }
        for (IGridNode gm : grid.getMachineNodes(SpatialPylonBlockEntity.class)) {
            SpatialPylonCluster c;
            if (!gm.meetsChannelRequirements() || (c = ((SpatialPylonBlockEntity)gm.getOwner()).getCluster()) == null) continue;
            this.clusters.put(c, c);
        }
        this.captureLevel = null;
        this.isValid = true;
        class_2338.class_2339 minPoint = null;
        class_2338.class_2339 maxPoint = null;
        int pylonBlocks = 0;
        for (SpatialPylonCluster cl : this.clusters.values()) {
            if (this.captureLevel == null) {
                this.captureLevel = cl.setLevel();
            } else if (this.captureLevel != cl.setLevel()) continue;
            if (maxPoint == null) {
                maxPoint = cl.getBoundsMax().method_25503();
            } else {
                maxPoint.method_33097(Math.max(maxPoint.method_10263(), cl.getBoundsMax().method_10263()));
                maxPoint.method_33098(Math.max(maxPoint.method_10264(), cl.getBoundsMax().method_10264()));
                maxPoint.method_33099(Math.max(maxPoint.method_10260(), cl.getBoundsMax().method_10260()));
            }
            if (minPoint == null) {
                minPoint = cl.getBoundsMin().method_25503();
            } else {
                minPoint.method_33097(Math.min(minPoint.method_10263(), cl.getBoundsMin().method_10263()));
                minPoint.method_33098(Math.min(minPoint.method_10264(), cl.getBoundsMin().method_10264()));
                minPoint.method_33099(Math.min(minPoint.method_10260(), cl.getBoundsMin().method_10260()));
            }
            pylonBlocks += cl.size();
        }
        this.captureMin = minPoint != null ? minPoint.method_10062() : null;
        this.captureMax = maxPoint != null ? maxPoint.method_10062() : null;
        double minPower = 0.0;
        if (this.hasRegion()) {
            this.isValid = this.captureMax.method_10263() - this.captureMin.method_10263() > 1 && this.captureMax.method_10264() - this.captureMin.method_10264() > 1 && this.captureMax.method_10260() - this.captureMin.method_10260() > 1;
            for (SpatialPylonCluster cl : this.clusters.values()) {
                switch (cl.getCurrentAxis()) {
                    case X: {
                        this.isValid = !(!this.isValid || this.captureMax.method_10264() != cl.getBoundsMin().method_10264() && this.captureMin.method_10264() != cl.getBoundsMax().method_10264() && this.captureMax.method_10260() != cl.getBoundsMin().method_10260() && this.captureMin.method_10260() != cl.getBoundsMax().method_10260() || this.captureMax.method_10264() != cl.getBoundsMax().method_10264() && this.captureMin.method_10264() != cl.getBoundsMin().method_10264() && this.captureMax.method_10260() != cl.getBoundsMax().method_10260() && this.captureMin.method_10260() != cl.getBoundsMin().method_10260());
                        break;
                    }
                    case Y: {
                        this.isValid = !(!this.isValid || this.captureMax.method_10263() != cl.getBoundsMin().method_10263() && this.captureMin.method_10263() != cl.getBoundsMax().method_10263() && this.captureMax.method_10260() != cl.getBoundsMin().method_10260() && this.captureMin.method_10260() != cl.getBoundsMax().method_10260() || this.captureMax.method_10263() != cl.getBoundsMax().method_10263() && this.captureMin.method_10263() != cl.getBoundsMin().method_10263() && this.captureMax.method_10260() != cl.getBoundsMax().method_10260() && this.captureMin.method_10260() != cl.getBoundsMin().method_10260());
                        break;
                    }
                    case Z: {
                        this.isValid = !(!this.isValid || this.captureMax.method_10264() != cl.getBoundsMin().method_10264() && this.captureMin.method_10264() != cl.getBoundsMax().method_10264() && this.captureMax.method_10263() != cl.getBoundsMin().method_10263() && this.captureMin.method_10263() != cl.getBoundsMax().method_10263() || this.captureMax.method_10264() != cl.getBoundsMax().method_10264() && this.captureMin.method_10264() != cl.getBoundsMin().method_10264() && this.captureMax.method_10263() != cl.getBoundsMax().method_10263() && this.captureMin.method_10263() != cl.getBoundsMin().method_10263());
                        break;
                    }
                    case UNFORMED: {
                        this.isValid = false;
                    }
                }
            }
            int reqX = this.captureMax.method_10263() - this.captureMin.method_10263();
            int reqY = this.captureMax.method_10264() - this.captureMin.method_10264();
            int reqZ = this.captureMax.method_10260() - this.captureMin.method_10260();
            int requirePylonBlocks = Math.max(6, (reqX * reqZ + reqX * reqY + reqY * reqZ) * 3 / 8);
            this.efficiency = (double)pylonBlocks / (double)requirePylonBlocks;
            if (this.efficiency > 1.0) {
                this.efficiency = 1.0;
            }
            if (this.efficiency < 0.0) {
                this.efficiency = 0.0;
            }
            minPower = (double)reqX * (double)reqY * (double)reqZ * AEConfig.instance().getSpatialPowerMultiplier();
        }
        this.powerRequired = (long)Math.pow(minPower, 1.0 + (AEConfig.instance().getSpatialPowerExponent() - 1.0) * (1.0 - this.efficiency));
        for (SpatialPylonCluster cl : this.clusters.values()) {
            boolean myWasValid = cl.isValid();
            cl.setValid(this.isValid);
            if (myWasValid == this.isValid) continue;
            cl.updateStatus(false);
        }
    }

    @Override
    public boolean hasRegion() {
        return this.captureLevel != null && this.captureMin != null && this.captureMax != null;
    }

    @Override
    public boolean isValidRegion() {
        return this.hasRegion() && this.isValid;
    }

    public class_3218 getLevel() {
        return this.captureLevel;
    }

    @Override
    public class_2338 getMin() {
        return this.captureMin;
    }

    @Override
    public class_2338 getMax() {
        return this.captureMax;
    }

    @Override
    public long requiredPower() {
        return this.powerRequired;
    }

    @Override
    public float currentEfficiency() {
        return (float)this.efficiency * 100.0f;
    }

    static {
        GridHelper.addGridServiceEventHandler(GridBootingStatusChange.class, ISpatialService.class, (service, evt) -> ((SpatialPylonService)service).bootingRender((GridBootingStatusChange)evt));
    }
}

