/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.util.AEColor;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.CategoryIndex;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.navigation.NavigationNode;
import appeng.core.AppEngClient;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ColoredItemDefinition;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.transform.TransformRecipe;
import appeng.siteexport.CacheBusting;
import appeng.siteexport.ExportableResourceProvider;
import appeng.siteexport.OffScreenRenderer;
import appeng.siteexport.ResourceExporter;
import appeng.siteexport.SiteExportWriter;
import appeng.siteexport.WebPExporter;
import appeng.siteexport.mdastpostprocess.PageExportPostProcessor;
import appeng.siteexport.model.P2PTypeInfo;
import appeng.util.CraftingRecipeUtil;
import appeng.util.Platform;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3797;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_425;
import net.minecraft.class_5253;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_6862;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public final class SiteExporter
implements ResourceExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ICON_DIMENSION = 128;
    private final class_310 client;
    private final Map<class_2960, String> exportedTextures = new HashMap<class_2960, String>();
    private final Path outputFolder;
    private final Guide guide;
    private ParsedGuidePage currentPage;
    private final Set<class_1860<?>> recipes = new HashSet();
    private final Set<class_1792> items = new HashSet<class_1792>();
    private final Set<class_3611> fluids = new HashSet<class_3611>();

    public SiteExporter(class_310 client, Path outputFolder, Guide guide) {
        this.client = client;
        this.outputFolder = outputFolder;
        this.guide = guide;
        this.referenceItem((class_1935)class_1802.field_8732);
        this.referenceItem(AEBlocks.INSCRIBER);
        this.referenceFluid((class_3611)class_3612.field_15910);
        this.referenceFluid((class_3611)class_3612.field_15908);
        this.referenceItem((class_1935)class_1802.field_8626);
        this.referenceItem((class_1935)class_2246.field_16329);
    }

    public static void initialize() {
        if (Boolean.getBoolean("appeng.runGuideExportAndExit")) {
            Path outputFolder = Paths.get(System.getProperty("appeng.guideExportFolder"), new String[0]);
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.method_18506() instanceof class_425) {
                    return;
                }
                Guide guide = AppEngClient.instance().getGuide();
                try {
                    SiteExporter.export(client, outputFolder, guide);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                System.exit(0);
            });
        }
    }

    public static void export(FabricClientCommandSource source) {
        Guide guide = AppEngClient.instance().getGuide();
        try {
            Path outputFolder = Paths.get("guide-export", new String[0]).toAbsolutePath();
            SiteExporter.export(class_310.method_1551(), outputFolder, guide);
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Guide data exported to ").method_10852((class_2561)class_2561.method_43470((String)("[" + outputFolder.getFileName().toString() + "]")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outputFolder.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to open export folder"))).method_27705(new class_124[]{class_124.field_1073, class_124.field_1060}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            source.sendError((class_2561)class_2561.method_43470((String)e.toString()));
        }
    }

    private static void export(class_310 client, Path outputFolder, Guide guide) throws Exception {
        new SiteExporter(client, outputFolder, guide).export();
    }

    @Override
    public void referenceItem(class_1799 stack) {
        if (!stack.method_7960()) {
            this.items.add(stack.method_7909());
            if (stack.method_7985()) {
                LOGGER.error("Couldn't handle stack with NBT tag: {}", (Object)stack);
            }
        }
    }

    @Override
    public void referenceFluid(class_3611 fluid) {
        this.fluids.add(fluid);
    }

    private void referenceIngredient(class_1856 ingredient) {
        for (class_1799 item : ingredient.method_8105()) {
            this.referenceItem(item);
        }
    }

    @Override
    public void referenceRecipe(class_1860<?> recipe) {
        if (!this.recipes.add(recipe)) {
            return;
        }
        class_5455 registryAccess = Platform.getClientRegistryAccess();
        class_1799 resultItem = recipe.method_8110(registryAccess);
        if (!resultItem.method_7960()) {
            this.referenceItem(resultItem);
        }
        for (class_1856 ingredient : CraftingRecipeUtil.getIngredients(recipe)) {
            this.referenceIngredient(ingredient);
        }
    }

    private void dumpRecipes(SiteExportWriter writer) {
        for (class_1860<?> recipe : this.recipes) {
            if (recipe instanceof class_3955) {
                class_3955 craftingRecipe = (class_3955)recipe;
                if (craftingRecipe.method_8118()) continue;
                writer.addRecipe(craftingRecipe);
                continue;
            }
            if (recipe instanceof class_1874) {
                class_1874 cookingRecipe = (class_1874)recipe;
                writer.addRecipe(cookingRecipe);
                continue;
            }
            if (recipe instanceof InscriberRecipe) {
                InscriberRecipe inscriberRecipe = (InscriberRecipe)recipe;
                writer.addRecipe(inscriberRecipe);
                continue;
            }
            if (recipe instanceof TransformRecipe) {
                TransformRecipe transformRecipe = (TransformRecipe)recipe;
                writer.addRecipe(transformRecipe);
                continue;
            }
            if (recipe instanceof class_8060) {
                class_8060 smithingTransformRecipe = (class_8060)recipe;
                writer.addRecipe(smithingTransformRecipe);
                continue;
            }
            if (recipe instanceof class_8062) {
                class_8062 smithingTrimRecipe = (class_8062)recipe;
                writer.addRecipe(smithingTrimRecipe);
                continue;
            }
            if (recipe instanceof class_3975) {
                class_3975 stonecutterRecipe = (class_3975)recipe;
                writer.addRecipe(stonecutterRecipe);
                continue;
            }
            if (recipe instanceof EntropyRecipe) {
                EntropyRecipe entropyRecipe = (EntropyRecipe)recipe;
                writer.addRecipe(entropyRecipe);
                continue;
            }
            if (recipe instanceof MatterCannonAmmo) {
                MatterCannonAmmo ammoRecipe = (MatterCannonAmmo)recipe;
                writer.addRecipe(ammoRecipe);
                continue;
            }
            if (recipe instanceof ChargerRecipe) {
                ChargerRecipe chargerRecipe = (ChargerRecipe)recipe;
                writer.addRecipe(chargerRecipe);
                continue;
            }
            LOGGER.warn("Unable to handle recipe {} of type {}", (Object)recipe.method_8114(), (Object)recipe.method_17716());
        }
    }

    @Override
    public Path copyResource(class_2960 id) {
        try {
            Path pagePath = this.getPathForWriting(id);
            byte[] bytes = this.guide.loadAsset(id);
            if (bytes == null) {
                throw new IllegalArgumentException("Couldn't find asset " + id);
            }
            return CacheBusting.writeAsset(pagePath, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy resource " + id, e);
        }
    }

    @Override
    public Path getPathForWriting(class_2960 assetId) {
        try {
            Path path = this.resolvePath(assetId);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    public class_2960 getPageSpecificResourceLocation(String suffix) {
        String path = this.currentPage.getId().method_12832();
        int idx = path.lastIndexOf(46);
        if (idx != -1) {
            path = path.substring(0, idx);
        }
        return new class_2960(this.currentPage.getId().method_12836(), path + "_" + suffix);
    }

    @Override
    public Path getPageSpecificPathForWriting(String suffix) {
        String pageFilename = this.currentPage.getId().method_12832();
        String filename = FilenameUtils.getBaseName((String)pageFilename) + "_" + suffix;
        Path pagePath = this.resolvePath(this.currentPage.getId());
        Path path = pagePath.resolveSibling(filename);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    @Override
    @Nullable
    public class_2960 getCurrentPageId() {
        return this.currentPage != null ? this.currentPage.getId() : null;
    }

    private void export() throws Exception {
        if (Files.isDirectory(this.outputFolder, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)this.outputFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        } else {
            Files.createDirectories(this.outputFolder, new FileAttribute[0]);
        }
        if (this.client.field_1687 == null) {
            LOGGER.info("Reloading datapacks to get recipes");
            Guide.runDatapackReload();
            LOGGER.info("Completed datapack reload");
        }
        this.guide.getNavigationTree().getRootNodes().forEach(this::visitNavigationNodeIcons);
        SiteExportWriter indexWriter = new SiteExportWriter(this.guide);
        Iterator<ParsedGuidePage> iterator = this.guide.getPages().iterator();
        while (iterator.hasNext()) {
            ParsedGuidePage page;
            this.currentPage = page = iterator.next();
            LOGGER.debug("Compiling {}", (Object)page);
            GuidePage compiledPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
            this.processPage(indexWriter, page, compiledPage);
            ExportableResourceProvider.visit(compiledPage.document(), this);
        }
        this.dumpRecipes(indexWriter);
        this.processItems(this.client, indexWriter, this.outputFolder);
        this.processFluids(this.client, indexWriter, this.outputFolder);
        indexWriter.addIndex(this.guide, ItemIndex.class);
        indexWriter.addIndex(this.guide, CategoryIndex.class);
        Path guideContent = this.outputFolder.resolve("guide.json.gz");
        byte[] content = indexWriter.toByteArray();
        guideContent = CacheBusting.writeAsset(guideContent, content);
        this.writeSummary(guideContent.getFileName().toString());
    }

    private void visitNavigationNodeIcons(NavigationNode navigationNode) {
        this.referenceItem(navigationNode.icon());
        navigationNode.children().forEach(this::visitNavigationNodeIcons);
    }

    private void processPage(SiteExportWriter exportWriter, ParsedGuidePage page, GuidePage compiledPage) {
        PageExportPostProcessor.postprocess(this, page, compiledPage);
        exportWriter.addPage(page);
    }

    private void writeSummary(String guideDataFilename) throws IOException {
        String modVersion = System.getProperty("appeng.version", "unknown");
        long generated = Instant.now().toEpochMilli();
        String gameVersion = class_3797.method_16672().method_48019();
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFolder.resolve("index.json"), StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonWriter jsonWriter = SiteExportWriter.GSON.newJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            jsonWriter.name("format").value(1L);
            jsonWriter.name("generated").value(generated);
            jsonWriter.name("gameVersion").value(gameVersion);
            jsonWriter.name("modVersion").value(modVersion);
            jsonWriter.name("guideDataPath").value(guideDataFilename);
            jsonWriter.endObject();
        }
    }

    private Path resolvePath(class_2960 id) {
        return this.outputFolder.resolve(id.method_12836() + "/" + id.method_12832());
    }

    private static void dumpP2PTypes(Set<class_1792> usedVanillaItems, SiteExportWriter siteExport) {
        class_1935[] tunnelTypes;
        for (class_1935 tunnelItem : tunnelTypes = new class_1935[]{P2PTunnelAttunement.ME_TUNNEL, P2PTunnelAttunement.ENERGY_TUNNEL, P2PTunnelAttunement.ITEM_TUNNEL, P2PTunnelAttunement.FLUID_TUNNEL, P2PTunnelAttunement.REDSTONE_TUNNEL, P2PTunnelAttunement.LIGHT_TUNNEL}) {
            P2PTypeInfo typeInfo = new P2PTypeInfo();
            typeInfo.tunnelItemId = SiteExporter.getItemId(tunnelItem.method_8389()).toString();
            HashSet items = new HashSet();
            for (Map.Entry<class_6862<class_1792>, class_1792> entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
                if (entry.getValue() != tunnelItem.method_8389()) continue;
                class_7923.field_41178.method_40286(entry.getKey()).forEach(h -> items.add((class_1792)h.comp_349()));
            }
            items.stream().map(i -> SiteExporter.getItemId(i).toString()).forEach(typeInfo.attunementItemIds::add);
            P2PTunnelAttunementInternal.AttunementInfo attunementInfo = P2PTunnelAttunementInternal.getAttunementInfo(tunnelItem);
            attunementInfo.apis().stream().map(lookup -> lookup.apiClass().getName()).forEach(typeInfo.attunementApiClasses::add);
            usedVanillaItems.addAll(items);
            siteExport.addP2PType(typeInfo);
        }
    }

    private static void dumpColoredItems(SiteExportWriter siteExport) {
        for (ColoredItemDefinition<?> coloredPart : AEParts.COLORED_PARTS) {
            SiteExporter.dumpColoredItem(coloredPart, siteExport);
        }
    }

    private static void dumpColoredItem(ColoredItemDefinition itemDefinition, SiteExportWriter siteExport) {
        Object baseItem = itemDefinition.item(AEColor.TRANSPARENT);
        if (baseItem == null) {
            return;
        }
        for (AEColor color : AEColor.values()) {
            Object coloredItem;
            if (color.dye == null || (coloredItem = itemDefinition.item(color)) == null) continue;
            siteExport.addColoredVersion((class_1792)baseItem, color.dye, (class_1792)coloredItem);
        }
    }

    private void processItems(class_310 client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path iconsFolder = outputFolder.resolve("!items");
        if (Files.exists(iconsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)iconsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            class_332 guiGraphics = new class_332(client, client.method_22940().method_23000());
            renderer.setupItemRendering();
            LOGGER.info("Exporting items...");
            for (class_1792 item : this.items) {
                class_1799 stack = new class_1799((class_1935)item);
                String itemId = SiteExporter.getItemId(stack.method_7909()).toString();
                String baseName = "!items/" + itemId.replace(':', '/');
                class_1087 itemModel = client.method_1480().method_4019(stack, null, null, 0);
                Set<class_1058> sprites = this.guessSprites(Set.of(itemModel));
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    guiGraphics.method_51427(stack, 0, 0);
                    guiGraphics.method_51432(client.field_1772, stack, 0, 0, "");
                }, sprites, true);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addItem(itemId, stack, absIconUrl);
            }
        }
    }

    private Set<class_1058> guessSprites(Collection<class_1087> models) {
        Set<class_1058> result = Collections.newSetFromMap(new IdentityHashMap());
        class_6575 randomSource = new class_6575(0L);
        for (class_1087 model : models) {
            for (class_777 quad : model.method_4707(null, null, (class_5819)randomSource)) {
                result.add(quad.method_35788());
            }
        }
        return result;
    }

    private void processFluids(class_310 client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path fluidsFolder = outputFolder.resolve("!fluids");
        if (Files.exists(fluidsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)fluidsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            class_332 guiGraphics = new class_332(client, client.method_22940().method_23000());
            renderer.setupItemRendering();
            LOGGER.info("Exporting fluids...");
            for (class_3611 fluid : this.fluids) {
                FluidVariant fluidVariant = FluidVariant.of((class_3611)fluid);
                String fluidId = class_7923.field_41173.method_10221((Object)fluid).toString();
                class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)fluidVariant);
                class_1058 sprite = sprites != null ? sprites[0] : null;
                int color = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
                String baseName = "!fluids/" + fluidId.replace(':', '/');
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    if (sprite != null) {
                        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
                        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
                        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
                        float a = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
                        guiGraphics.method_48465(0, 0, 0, 16, 16, sprite, r, g, b, a);
                    }
                }, sprite != null ? Set.of(sprite) : Set.of(), false);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addFluid(fluidId, fluidVariant, absIconUrl);
            }
        }
    }

    @Override
    public Path renderAndWrite(OffScreenRenderer renderer, String baseName, Runnable renderRunnable, Collection<class_1058> sprites, boolean withAlpha) throws IOException {
        byte[] content;
        String extension;
        if (renderer.isAnimated(sprites)) {
            extension = ".webp";
            content = renderer.captureAsWebp(renderRunnable, sprites, withAlpha ? WebPExporter.Format.LOSSLESS_ALPHA : WebPExporter.Format.LOSSLESS);
        } else {
            extension = ".png";
            content = renderer.captureAsPng(renderRunnable);
        }
        Path iconPath = this.outputFolder.resolve(baseName + extension);
        Files.createDirectories(iconPath.getParent(), new FileAttribute[0]);
        return CacheBusting.writeAsset(iconPath, content);
    }

    @Override
    public String exportTexture(class_2960 textureId) {
        byte[] imageContent;
        String exportedPath = this.exportedTextures.get(textureId);
        if (exportedPath != null) {
            return exportedPath;
        }
        class_2960 id = textureId;
        if (!id.method_12832().endsWith(".png")) {
            id = new class_2960(id.method_12836(), id.method_12832() + ".png");
        }
        Path outputPath = this.getPathForWriting(id);
        class_1044 texture = class_310.method_1551().method_1531().method_4619(textureId);
        if (texture instanceof class_1059) {
            class_1059 textureAtlas = (class_1059)texture;
            for (class_7764 sprite : textureAtlas.field_5277) {
                if (sprite.field_40541 == null) continue;
            }
        }
        texture.method_23207();
        int[] intResult = new int[1];
        GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4096, (int[])intResult);
        int w = intResult[0];
        GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4097, (int[])intResult);
        int h = intResult[0];
        try (class_1011 nativeImage = new class_1011(w, h, false);){
            nativeImage.method_4327(0, false);
            imageContent = nativeImage.method_24036();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            outputPath = CacheBusting.writeAsset(outputPath, imageContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to export texture " + textureId, e);
        }
        exportedPath = this.getPathRelativeFromOutputFolder(outputPath);
        this.exportedTextures.put(textureId, exportedPath);
        return exportedPath;
    }

    private static class_2960 getItemId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    private static class_2960 getFluidId(class_3611 fluid) {
        return class_7923.field_41173.method_10221((Object)fluid);
    }
}

