/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.block.entity;

import java.util.Optional;
import net.emilsg.clutter.block.ModBlockEntities;
import net.emilsg.clutter.recipe.KilningRecipe;
import net.emilsg.clutter.screen.BrickKilnScreenHandler;
import net.emilsg.clutter.screen.ImplementedInventory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class BrickKilnBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FUEL_ITEM_SLOT = 2;
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{1, 2};
    private static final int[] SIDE_SLOTS = new int[]{2};
    protected final class_3913 propertyDelegate;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private int progress = 0;
    private int maxProgress = 100;
    private int burnTime;
    private int fuelTime;

    public BrickKilnBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BRICK_KILN_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> BrickKilnBlockEntity.this.progress;
                    case 1 -> BrickKilnBlockEntity.this.maxProgress;
                    case 2 -> BrickKilnBlockEntity.this.burnTime;
                    case 3 -> BrickKilnBlockEntity.this.fuelTime;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        BrickKilnBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BrickKilnBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        BrickKilnBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 3: {
                        BrickKilnBlockEntity.this.fuelTime = value;
                    }
                }
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return class_2609.method_11196().containsKey(stack.method_7909());
    }

    protected int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return class_2609.method_11196().getOrDefault(item, 0);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.clutter.brick_kiln");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BrickKilnScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("brick_kiln.burntime", this.burnTime);
        nbt.method_10569("brick_kiln.progress", this.progress);
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.burnTime = nbt.method_10550("brick_kiln.burntime");
        this.progress = nbt.method_10550("brick_kiln.progress");
        this.fuelTime = this.getFuelTime((class_1799)this.inventory.get(2));
        super.method_11014(nbt);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, BrickKilnBlockEntity blockEntity) {
        boolean wasBurning = blockEntity.isBurning();
        boolean willContinueBurning = false;
        if (blockEntity.isBurning()) {
            --blockEntity.burnTime;
        }
        if (!blockEntity.isBurning() && blockEntity.hasRecipe() && BrickKilnBlockEntity.canUseAsFuel(blockEntity.method_5438(2))) {
            class_1799 fuelStack = (class_1799)blockEntity.inventory.get(2);
            blockEntity.burnTime = blockEntity.fuelTime = blockEntity.getFuelTime(fuelStack) / 2;
            if (fuelStack.getRecipeRemainder().method_31574(class_1802.field_8550)) {
                blockEntity.method_5447(2, new class_1799((class_1935)class_1802.field_8550));
            } else if (!fuelStack.getRecipeRemainder().method_31574(class_1802.field_8550)) {
                fuelStack.method_7934(1);
            }
            willContinueBurning = true;
        }
        if (blockEntity.canInsertIntoOutputSlot() && blockEntity.hasRecipe()) {
            if (blockEntity.isBurning() || willContinueBurning) {
                blockEntity.increaseCraftingProgress();
                BrickKilnBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (blockEntity.hasCraftingFinished()) {
                    blockEntity.craftItem();
                    blockEntity.resetProgress();
                }
                willContinueBurning = true;
            } else {
                blockEntity.resetProgress();
            }
        } else {
            blockEntity.resetProgress();
        }
        if (!world.field_9236) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(blockEntity.burnTime > 0)), 3);
        }
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    private void craftItem() {
        Optional<KilningRecipe> recipe = this.getCurrentRecipe();
        this.method_5434(0, 1);
        this.method_5447(1, new class_1799((class_1935)recipe.get().method_8110(null).method_7909(), this.method_5438(1).method_7947() + recipe.get().method_8110(null).method_7947()));
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        if (this.isBurning()) {
            ++this.progress;
        }
    }

    private boolean hasRecipe() {
        Optional<KilningRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 output = recipe.get().method_8110(null);
        return this.canInsertAmountIntoOutputSlot(output.method_7947()) && this.canInsertItemIntoOutputSlot(output);
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.method_5438(1).method_7914() >= this.method_5438(1).method_7947() + count;
    }

    private Optional<KilningRecipe> getCurrentRecipe() {
        class_1277 inventory = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inventory.method_5447(i, this.method_5438(i));
        }
        return this.method_10997().method_8433().method_8132((class_3956)KilningRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
    }

    private boolean canInsertIntoOutputSlot() {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7947() < this.method_5438(1).method_7914();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 1) {
            return false;
        }
        if (slot == 2) {
            class_1799 itemStack = (class_1799)this.inventory.get(1);
            return BrickKilnBlockEntity.canUseAsFuel(stack) || stack.method_31574(class_1802.field_8550) && !itemStack.method_31574(class_1802.field_8550);
        }
        return true;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 2) {
            return stack.method_31574(class_1802.field_8705) || stack.method_31574(class_1802.field_8550);
        }
        return true;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        if (side == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }
}

