/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.AccessoriesInternalsClient;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import java.util.Collection;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_5944;
import net.minecraft.class_746;

public class AccessoriesClient {
    public static final class_2960 BLIT_SHADER_ID = Accessories.of("fish");
    public static class_5944 BLIT_SHADER;
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT;
    public static boolean IS_PLAYER_INVISIBLE;
    private static boolean displayUnusedSlotWarning;

    public static void init() {
        AccessoriesInternalsClient.registerToMenuTypes();
        Accessories.CONFIG_HOLDER.registerSaveListener((manager, data) -> {
            AccessoriesClient.handleConfigChangesSync(data);
            return class_1269.field_5812;
        });
        Accessories.CONFIG_HOLDER.registerLoadListener((manager, data) -> {
            AccessoriesClient.handleConfigChangesSync(data);
            return class_1269.field_5812;
        });
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            AccessoriesRendererRegistry.onReload();
        });
    }

    public static void handleConfigChangesSync(AccessoriesConfig config) {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (currentPlayer == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder == null) {
            return;
        }
        if (holder.showUniqueSlots() && !config.clientData.showUniqueRendering) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, false));
        }
        if (holder.equipControl() != config.clientData.equipControl) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, config.clientData.equipControl));
        }
        if (holder.showUnusedSlots() != config.clientData.showUnusedSlots) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, config.clientData.showUnusedSlots));
        }
    }

    public static boolean attemptToOpenScreen() {
        return AccessoriesClient.attemptToOpenScreen(false);
    }

    public static boolean attemptToOpenScreen(boolean targetingLookingEntity) {
        class_746 player = class_310.method_1551().field_1724;
        if (targetingLookingEntity) {
            class_1309 living;
            class_3966 entityHitResult;
            class_1297 class_12972;
            boolean bl;
            class_239 result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)(player.method_7337() ? 4.5 : 4.0));
            boolean bl2 = bl = !(result instanceof class_3966) || !((class_12972 = (entityHitResult = (class_3966)result).method_17782()) instanceof class_1309) || EntitySlotLoader.getEntitySlots(living = (class_1309)class_12972).isEmpty();
            if (bl) {
                return false;
            }
            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(true));
        } else {
            Collection<SlotType> slots = AccessoriesAPI.getUsedSlotsFor((class_1657)player);
            AccessoriesHolder holder = player.accessoriesHolder();
            if (holder == null) {
                return false;
            }
            if (slots.isEmpty() && !holder.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.getConfig().clientData.disableEmptySlotScreenError) {
                player.method_7353((class_2561)class_2561.method_43470((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(false));
        }
        return true;
    }

    static {
        WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
            for (WindowResizeCallback callback : callbacks) {
                callback.onResized(client, window);
            }
        });
        IS_PLAYER_INVISIBLE = false;
        displayUnusedSlotWarning = false;
    }

    public static interface WindowResizeCallback {
        public void onResized(class_310 var1, class_1041 var2);
    }
}

