/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.copperhopper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.pcal.copperhopper.CohoScreenHandler;
import net.pcal.copperhopper.CopperHopperBlockEntity;
import net.pcal.copperhopper.CopperHopperMinecartEntity;
import net.pcal.copperhopper.CopperInventory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class CopperHopperMod {
    public static final String LOGGER_NAME = "CopperHopper";
    public static final String LOG_PREFIX = "[CopperHopper] ";
    public static final class_2960 COHO_BLOCK_ID = new class_2960("copperhopper:copper_hopper");
    public static final class_2960 COHO_ITEM_ID = new class_2960("copperhopper:copper_hopper");
    public static final class_2960 COHO_SCREEN_ID = new class_2960("copperhopper:copper_hopper");
    public static final class_2960 COHO_BLOCK_ENTITY_TYPE_ID = new class_2960("copperhopper:copper_hopper_entity");
    public static final class_2960 COHO_MINECART_ITEM_ID = new class_2960("copperhopper:copper_hopper_minecart");
    public static final class_2960 COHO_MINECART_ENTITY_TYPE_ID = new class_2960("copperhopper:copper_hopper_minecart");
    private static final String CONFIG_FILENAME = "copperhopper.properties";
    private static final String DEFAULT_CONFIG_FILENAME = "default-copperhopper.properties";
    private final Logger logger = LogManager.getLogger((String)"CopperHopper");
    private final Path configFilePath = Paths.get("config", "copperhopper.properties");
    private final File configFile = this.configFilePath.toFile();

    public static CopperHopperMod mod() {
        return SingletonHolder.INSTANCE;
    }

    public class_2248 getBlock() {
        return (class_2248)class_7923.field_41175.method_10223(COHO_BLOCK_ID);
    }

    public class_1792 getMinecartItem() {
        return (class_1792)class_7923.field_41178.method_10223(COHO_MINECART_ITEM_ID);
    }

    public class_2591<CopperHopperBlockEntity> getBlockEntityType() {
        return Objects.requireNonNull((class_2591)class_7923.field_41181.method_10223(COHO_BLOCK_ENTITY_TYPE_ID));
    }

    public class_1299<CopperHopperMinecartEntity> getMinecartEntityType() {
        return Objects.requireNonNull((class_1299)class_7923.field_41177.method_10223(COHO_MINECART_ENTITY_TYPE_ID));
    }

    public class_3917<CohoScreenHandler> getScreenHandlerType() {
        return Objects.requireNonNull((class_3917)class_7923.field_41187.method_10223(COHO_SCREEN_ID));
    }

    public Properties loadConfig() throws IOException {
        Properties config;
        this.setLogLevel(Level.INFO);
        try (FileInputStream in = new FileInputStream(this.configFile);){
            Properties newProps = new Properties();
            newProps.load(in);
            config = newProps;
        }
        String configuredLevel = config.getProperty("log-level");
        if (configuredLevel != null) {
            Level logLevel = Level.getLevel((String)configuredLevel);
            if (logLevel == null) {
                this.logger.warn("[CopperHopper] Invalid logLevel " + configuredLevel + " in " + this.configFile.getAbsolutePath());
            } else {
                this.setLogLevel(logLevel);
                this.logger.info("[CopperHopper] LogLevel set to " + logLevel);
            }
        }
        this.logger.info("[CopperHopper] Configuration loaded: " + config);
        return config;
    }

    public void createDefaultConfig() throws IOException {
        if (!this.configFile.exists()) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILENAME);){
                if (in == null) {
                    throw new IllegalStateException("Unable to load default-copperhopper.properties");
                }
                this.configFilePath.getParent().toFile().mkdirs();
                Files.copy(in, this.configFilePath, new CopyOption[0]);
                this.logger.info("[CopperHopper] Wrote default copperhopper.properties");
            }
        }
    }

    public String getPolymerName() {
        return "Item Filter";
    }

    public boolean shouldVetoPushInto(CopperInventory into, class_1792 pushedItem) {
        return !CopperHopperMod.containsAtLeast(into, pushedItem, 1);
    }

    public boolean shouldVetoPullInto(class_1263 into, class_1792 pulledItem) {
        return CopperHopperMod.isCopperHopper(into) && !CopperHopperMod.containsAtLeast(into, pulledItem, 1);
    }

    public boolean shouldVetoPullFrom(CopperInventory from, class_1792 pulledItem) {
        return !CopperHopperMod.containsAtLeast(from, pulledItem, 2);
    }

    public boolean shouldVetoPushFrom(class_1263 from, class_1792 pushedItem, class_1937 world, class_2338 pos) {
        if (!CopperHopperMod.isCopperHopper(from)) {
            return false;
        }
        if (!CopperHopperMod.containsAtLeast(from, pushedItem, 2)) {
            return true;
        }
        if (((CopperHopperBlockEntity)from).method_11010().method_11654((class_2769)class_2377.field_11129) == class_2350.field_11033) {
            return false;
        }
        class_2338 below = pos.method_25503().method_30513(class_2350.class_2351.field_11052, -1);
        class_2586 blockEntity = world.method_8321(below);
        if (!CopperHopperMod.isCopperHopper(blockEntity)) {
            return false;
        }
        return CopperHopperMod.containsAtLeast((class_1263)blockEntity, pushedItem, 1);
    }

    private static boolean isCopperHopper(class_1263 target) {
        return target instanceof CopperInventory;
    }

    private static boolean isCopperHopper(class_2586 blockEntity) {
        return blockEntity instanceof CopperHopperBlockEntity;
    }

    private static boolean containsAtLeast(class_1263 inventory, class_1792 item, int atLeast) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (!itemStack.method_7909().equals(item) || (count += itemStack.method_7947()) < atLeast) continue;
            return true;
        }
        return false;
    }

    private void setLogLevel(Level logLevel) {
        Configurator.setLevel((String)CopperHopperMod.class.getName(), (Level)logLevel);
    }

    private static final class SingletonHolder {
        private static final CopperHopperMod INSTANCE = new CopperHopperMod();

        private SingletonHolder() {
        }
    }
}

