/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundBlastSoundPacket;
import rbasamoyai.createbigcannons.network.ClientboundSendCustomBreakProgressPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class CBCUtils {
    private static final Map<String, class_3419> SOURCE_BY_NAME = Arrays.stream(class_3419.values()).collect(Collectors.toMap(class_3419::method_14840, Function.identity()));
    public static final Codec<class_3419> SOUND_SOURCE_CODEC = CBCUtils.fromEnumWithStringFunction(class_3419::values, class_3419::method_14840, CBCUtils::soundSourceFromName);

    @Nullable
    public static class_3419 soundSourceFromName(String name) {
        return SOURCE_BY_NAME.get(name);
    }

    public static Set<String> getSoundSourceNames() {
        return SOURCE_BY_NAME.keySet();
    }

    public static class_2960 location(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static class_2960 location(String location) {
        return new class_2960(location);
    }

    public static Matrix3f mat3x3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return new Matrix3f(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static Matrix4f mat4x4f(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return new Matrix4f(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public static Matrix4f mat4x4f(@Nonnull Matrix3f mat3x3f) {
        return CBCUtils.mat4x4f(mat3x3f.m00, mat3x3f.m01, mat3x3f.m02, 0.0f, mat3x3f.m10, mat3x3f.m11, mat3x3f.m12, 0.0f, mat3x3f.m20, mat3x3f.m21, mat3x3f.m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix3f mat3x3fFacing(class_243 normalized) {
        float cx = (float)(-normalized.field_1351);
        float cy = (float)normalized.field_1352;
        float cos = (float)(-normalized.field_1350);
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat3x3f(cx * cx * k + cos, cy * cx * k, cy, cx * cy * k, cy * cy * k + cos, -cx, -cy, cx, cos);
        }
        return CBCUtils.mat3x3f(1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
    }

    public static Matrix3fc mat3x3fFacing(class_243 dest, class_243 source) {
        class_243 c = source.method_1036(dest);
        float cx = (float)c.field_1352;
        float cy = (float)c.field_1351;
        float cz = (float)c.field_1350;
        float cos = (float)(-source.method_1026(dest));
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat3x3f(cx * cx * k + cos, cy * cx * k - cz, cz * cx * k + cy, cx * cy * k + cz, cy * cy * k + cos, cz * cy * k - cx, cx * cz * k - cy, cy * cz * k + cx, cz * cz * k + cos);
        }
        class_243 class_2432 = new class_243(0.0, 0.0, 1.0);
        if (Math.abs(1.0 - source.method_1026(class_2432)) < 1.0E-4) {
            return CBCUtils.mat3x3f(1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        }
        Matrix3f first = CBCUtils.mat3x3fFacing(source);
        first.transpose(first);
        Matrix3f second = CBCUtils.mat3x3fFacing(dest);
        second.mul((Matrix3fc)first, second);
        return second;
    }

    public static Matrix4f mat4x4fFacing(class_243 normalized) {
        float cx = (float)(-normalized.field_1351);
        float cy = (float)normalized.field_1352;
        float cos = (float)(-normalized.field_1350);
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat4x4f(cx * cx * k + cos, cy * cx * k, cy, 0.0f, cx * cy * k, cy * cy * k + cos, -cx, 0.0f, -cy, cx, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        return CBCUtils.mat4x4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f mat4x4fFacing(class_243 dest, class_243 source) {
        class_243 c = source.method_1036(dest);
        float cx = (float)c.field_1352;
        float cy = (float)c.field_1351;
        float cz = (float)c.field_1350;
        float cos = (float)(-source.method_1026(dest));
        float k = 1.0f / (1.0f + cos);
        if (Float.isFinite(k)) {
            return CBCUtils.mat4x4f(cx * cx * k + cos, cy * cx * k - cz, cz * cx * k + cy, 0.0f, cx * cy * k + cz, cy * cy * k + cos, cz * cy * k - cx, 0.0f, cx * cz * k - cy, cy * cz * k + cx, cz * cz * k + cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        class_243 class_2432 = new class_243(0.0, 0.0, 1.0);
        if (Math.abs(1.0 - source.method_1026(class_2432)) < 1.0E-4) {
            return CBCUtils.mat4x4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        Matrix4f first = CBCUtils.mat4x4fFacing(source);
        Matrix4f firstD = new Matrix4f();
        first.transpose(firstD);
        Matrix4f second = CBCUtils.mat4x4fFacing(dest);
        Matrix4f result = new Matrix4f();
        second.mul((Matrix4fc)first, result);
        return result;
    }

    public static void sendCustomBlockDamage(class_1937 level, class_2338 pos, int damage) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 slevel = (class_3218)level;
        ClientboundSendCustomBreakProgressPacket pkt = new ClientboundSendCustomBreakProgressPacket(pos, damage);
        for (class_3222 splayer : slevel.method_18456()) {
            double f;
            double e;
            double d = (double)pos.method_10263() - splayer.method_23317();
            if (!(d * d + (e = (double)pos.method_10264() - splayer.method_23318()) * e + (f = (double)pos.method_10260() - splayer.method_23321()) * f < 1024.0)) continue;
            NetworkPlatform.sendToClientPlayer(pkt, splayer);
        }
    }

    public static class_243 getSurfaceNormalVector(class_1937 level, class_2338 hitPos, class_243 normal) {
        return normal;
    }

    public static class_243 getSurfaceNormalVector(class_1937 level, class_3965 hitResult) {
        class_2350 dir = hitResult.method_17780();
        return CBCUtils.getSurfaceNormalVector(level, hitResult.method_17777(), new class_243((double)dir.method_10148(), (double)dir.method_10164(), (double)dir.method_10165()));
    }

    public static void playBlastLikeSoundOnServer(class_3218 level, double x, double y, double z, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, float airAbsorption) {
        double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
        double radSqr = radius * radius;
        ClientboundBlastSoundPacket packet = new ClientboundBlastSoundPacket(soundEvent, soundSource, x, y, z, volume, pitch, airAbsorption);
        for (class_3222 player : level.method_18456()) {
            if (!(player.method_5649(x, y, z) < radSqr)) continue;
            NetworkPlatform.sendToClientPlayer(packet, player);
        }
    }

    public static <E extends Enum<E>> Codec<E> fromEnumWithStringFunction(Supplier<E[]> elementSupplier, Function<E, String> strFunc, Function<String, E> namingFunction) {
        Enum[] enums = (Enum[])elementSupplier.get();
        return class_5699.method_39512((Codec)class_5699.method_39508(strFunc, namingFunction), (Codec)class_5699.method_39511(Enum::ordinal, i -> i >= 0 && i < enums.length ? enums[i] : null, (int)-1));
    }

    public static class_2680 parseBlockState(StringReader reader) throws CommandSyntaxException {
        return class_2259.method_41955((class_7225)CBCRegistryUtils.getBlockRegistry().method_46771(), (StringReader)reader, (boolean)false).comp_622();
    }

    private CBCUtils() {
    }
}

