/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.emitter;

import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ParticleEmitter {
    static final Properties DEFAULT_PROPERTIES = new Properties(ParticleEmitter.offset(0.25f), ParticleEmitter.speed(0.025f, 0.1f));
    static final Map<Object, Properties> PROPERTIES = new HashMap<Object, Properties>();
    private final Supplier<? extends class_2394> type;
    private Supplier<class_243> position = () -> class_243.field_1353;
    private Supplier<class_243> offset;
    private Supplier<Float> speed;
    private int count = 1;
    private float countMultiplier = 1.0f;

    public static void setDefault(class_2396<?> type, Properties properties) {
        PROPERTIES.put(type, properties);
    }

    public static ParticleEmitter of(Supplier<? extends class_2394> type) {
        return new ParticleEmitter(type, PROPERTIES.getOrDefault(type.get().method_10295(), DEFAULT_PROPERTIES));
    }

    public static ParticleEmitter of(class_2394 type) {
        return ParticleEmitter.of(() -> type);
    }

    public static Supplier<class_243> offset(float value) {
        return () -> new class_243((double)value, (double)value, (double)value);
    }

    public static Supplier<Float> speed(float min, float max) {
        return () -> Float.valueOf(Random.nextFloat(min, max));
    }

    public void emit(class_1937 level) {
        this.emit(level, this.position.get(), this.offset.get(), Math.round((float)this.count * this.countMultiplier));
    }

    public void emitLine(class_1937 level, class_243 end) {
        class_243 start = this.position.get();
        int count = Math.round((float)this.count * this.countMultiplier);
        AnyPos direction = AnyPos.from(end).sub(start);
        if (count == 1) {
            this.emit(level, AnyPos.from(start).add(direction.div(2)).vec3(), this.offset.get(), 1);
            return;
        }
        for (int idx = 0; idx < count; ++idx) {
            this.emit(level, AnyPos.from(start).add(direction.mul(Float.valueOf((float)idx / ((float)count - 1.0f)))).vec3(), this.offset.get(), 1);
        }
    }

    public ParticleEmitter position(Supplier<class_243> position) {
        this.position = position;
        return this;
    }

    public ParticleEmitter position(class_243 position) {
        return this.position(() -> position);
    }

    public ParticleEmitter offset(Supplier<class_243> offset) {
        this.offset = offset;
        return this;
    }

    public ParticleEmitter offset(class_243 offset) {
        return this.offset(() -> offset);
    }

    public ParticleEmitter speed(Supplier<Float> speed) {
        this.speed = speed;
        return this;
    }

    public ParticleEmitter speed(float speed) {
        return this.speed(() -> Float.valueOf(speed));
    }

    public ParticleEmitter count(int count) {
        this.count = count;
        return this;
    }

    public ParticleEmitter sizeBased(class_1297 entity) {
        float width = entity.method_17681();
        float height = entity.method_17682();
        this.position = () -> AnyPos.from(entity.method_19538()).add(0.0, 0.5 * (double)height, 0.0).vec3();
        this.offset = () -> AnyPos.from(Float.valueOf(width), Float.valueOf(height), Float.valueOf(width)).mul(0.5, 0.25, 0.5).vec3();
        this.countMultiplier = Math.round(1.0f + width + height);
        return this;
    }

    private ParticleEmitter(Supplier<? extends class_2394> type, Properties properties) {
        this.type = type;
        this.offset = properties.offset;
        this.speed = properties.speed;
    }

    private void emit(class_1937 level, class_243 position, class_243 offset, int count) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199(this.type.get(), position.field_1352, position.field_1351, position.field_1350, count, offset.field_1352, offset.field_1351, offset.field_1350, (double)this.speed.get().floatValue());
        } else {
            class_2394 type = this.type.get();
            float speed = this.speed.get().floatValue();
            for (int idx = 0; idx < count; ++idx) {
                level.method_8406(type, position.field_1352, position.field_1351, position.field_1350, offset.field_1352 * (double)speed, offset.field_1351 * (double)speed, offset.field_1350 * (double)speed);
            }
        }
    }

    static {
        ParticleEmitter.setDefault(class_2398.field_11214, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(-1.0f, 0.0f)));
        ParticleEmitter.setDefault(class_2398.field_11240, new Properties(ParticleEmitter.offset(0.15f), ParticleEmitter.speed(0.0025f, 0.01f)));
        ParticleEmitter.setDefault(class_2398.field_11251, new Properties(ParticleEmitter.offset(0.25f), ParticleEmitter.speed(0.0025f, 0.01f)));
        ParticleEmitter.setDefault(class_2398.field_38908, new Properties(() -> class_243.field_1353, () -> Float.valueOf(0.0f)));
        ParticleEmitter.setDefault(class_2398.field_23114, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(0.005f, 0.02f)));
        ParticleEmitter.setDefault(class_2398.field_11249, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(0.0025f, 0.01f)));
    }

    public record Properties(Supplier<class_243> offset, Supplier<Float> speed) {
    }
}

