/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.AnyRot;
import com.majruszlibrary.mixin.IMixinMob;
import com.majruszlibrary.mixin.IMixinServerLevel;
import com.majruszlibrary.mixininterfaces.IMixinClientLevel;
import com.majruszlibrary.mixininterfaces.IMixinEntity;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1355;
import net.minecraft.class_1429;
import net.minecraft.class_1543;
import net.minecraft.class_1640;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3989;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class EntityHelper {
    public static void cheatDeath(class_1309 entity) {
        entity.method_6033(1.0f);
        entity.method_6012();
        entity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
        entity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
        entity.method_6092(new class_1293(class_1294.field_5918, 800, 0));
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            ParticleEmitter.of((class_2394)class_2398.field_11220).sizeBased((class_1297)entity).count(32).offset(new class_243(0.25, 0.5, 0.25)).emit((class_1937)level);
            SoundEmitter.of(class_3417.field_14931).position(entity.method_19538()).emit((class_1937)level);
        }
    }

    public static boolean isOnCreativeMode(class_1657 player) {
        return player.method_31549().field_7477;
    }

    public static boolean isOnSpectatorMode(class_1657 player) {
        return player.method_7325();
    }

    public static boolean isAnimal(@Nullable class_1297 entity) {
        return entity instanceof class_1429;
    }

    public static boolean isHuman(class_1297 entity) {
        return entity instanceof class_1646 || entity instanceof class_3989 || entity instanceof class_1657 || entity instanceof class_1640 || entity instanceof class_1543;
    }

    public static boolean isLoaded(class_3218 level, UUID uuid) {
        return ((IMixinServerLevel)level).getEntityManager().method_31827(uuid);
    }

    public static boolean isOutside(class_1297 entity) {
        return entity.method_37908().method_8311(entity.method_24515());
    }

    public static boolean isIn(class_1297 entity, class_5321<class_1937> level) {
        return entity.method_37908().method_27983().equals(level);
    }

    public static String getPlayerUUID(class_1657 player) {
        return String.valueOf(player.method_5667());
    }

    public static double getHealthRatio(class_1309 entity) {
        return class_3532.method_15350((double)(entity.method_6032() / entity.method_6063()), (double)0.0, (double)1.0);
    }

    public static double getMissingHealthRatio(class_1309 entity) {
        return 1.0 - EntityHelper.getHealthRatio(entity);
    }

    public static float getWalkDistanceDelta(class_1309 entity) {
        return entity.field_5973 - entity.field_6039;
    }

    public static class_1355 getGoalSelector(class_1308 mob) {
        return ((IMixinMob)mob).getGoalSelector();
    }

    public static class_1355 getTargetSelector(class_1308 mob) {
        return ((IMixinMob)mob).getTargetSelector();
    }

    @Nullable
    public static class_2487 getExtraTag(class_1297 entity) {
        return ((IMixinEntity)entity).majruszlibrary$getExtraTag();
    }

    public static class_2487 getOrCreateExtraTag(class_1297 entity) {
        return ((IMixinEntity)entity).majruszlibrary$getOrCreateExtraTag();
    }

    public static void disableCurrentItem(class_1657 player, double seconds) {
        player.method_7357().method_7906(player.method_6030().method_7909(), TimeHelper.toTicks(seconds));
        player.method_6021();
        player.method_37908().method_8421((class_1297)player, (byte)30);
    }

    public static boolean spawnExperience(class_1937 level, class_243 position, int experience) {
        return level.method_8649((class_1297)new class_1303(level, position.field_1352, position.field_1351, position.field_1350, experience));
    }

    public static <Type extends class_1297> Spawner<Type> createSpawner(Supplier<class_1299<Type>> type, class_1937 level) {
        return new Spawner<Type>(type.get(), level);
    }

    public static <EntityType extends class_1297> List<EntityType> getEntitiesNearby(Class<EntityType> entityClass, class_3218 level, class_243 position, double radius) {
        return level.method_8390(entityClass, new class_238(position, position).method_1014(radius), entity -> AnyPos.from(position).dist(entity.method_19538()).doubleValue() <= radius);
    }

    public static boolean destroyBlocks(class_1297 entity, class_238 aabb, BiPredicate<class_2338, class_2680> predicate) {
        if (!LevelHelper.isMobGriefingEnabled(entity.method_37908())) {
            return false;
        }
        boolean destroyedAnyBlock = false;
        for (class_2338 blockPos : class_2338.method_10094((int)class_3532.method_15357((double)aabb.field_1323), (int)class_3532.method_15357((double)aabb.field_1322), (int)class_3532.method_15357((double)aabb.field_1321), (int)class_3532.method_15357((double)aabb.field_1320), (int)class_3532.method_15357((double)aabb.field_1325), (int)class_3532.method_15357((double)aabb.field_1324))) {
            if (!predicate.test(blockPos, entity.method_37908().method_8320(blockPos))) continue;
            destroyedAnyBlock |= entity.method_37908().method_8651(blockPos, true, entity);
        }
        return destroyedAnyBlock;
    }

    @Environment(value=EnvType.CLIENT)
    public static <Type> void applyToClientEntity(int entityId, Class<Type> clazz, Consumer<Type> consumer) {
        class_1297 entity = Side.getLocalLevel().method_8469(entityId);
        if (clazz.isInstance(entity)) {
            consumer.accept(clazz.cast(entity));
        } else {
            ((IMixinClientLevel)Side.getLocalLevel()).majruszlibrary$delayExecution(entityId, clazz, consumer);
        }
    }

    public static AnyRot getLookRotation(class_1297 entity) {
        return AnyRot.y(Math.toRadians(-entity.method_36454()) - 1.5707963267948966).rotZ(Math.toRadians(-entity.method_36455()));
    }

    public static AnyPos getLookDirection(class_1297 entity) {
        return AnyPos.from(1.0, 0.0, 0.0).rot(EntityHelper.getLookRotation(entity));
    }

    public static AnyPos getDirection2d(class_1297 entity) {
        return AnyPos.from(1.0, 0.0, 0.0).rot(AnyRot.y(Math.toRadians(-entity.method_36454()) - 1.5707963267948966));
    }

    public static class Spawner<Type extends class_1297> {
        private final class_1299<Type> type;
        private final class_1937 level;
        private class_3730 mobSpawnType = class_3730.field_16467;
        private class_243 position = null;
        private Consumer<Type> beforeEvent = null;

        public Spawner<Type> mobSpawnType(class_3730 mobSpawnType) {
            this.mobSpawnType = mobSpawnType;
            return this;
        }

        public Spawner<Type> position(class_243 position) {
            this.position = position;
            return this;
        }

        public Spawner<Type> beforeEvent(Consumer<Type> beforeEvent) {
            this.beforeEvent = beforeEvent;
            return this;
        }

        @Nullable
        public Type spawn() {
            class_1297 entity = this.type.method_5883(this.level);
            if (entity != null) {
                Optional.ofNullable(this.position).ifPresent(arg_0 -> ((class_1297)entity).method_29495(arg_0));
                Optional.ofNullable(this.beforeEvent).ifPresent(beforeEvent -> beforeEvent.accept(entity));
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    class_1937 class_19372 = this.level;
                    if (class_19372 instanceof class_3218) {
                        class_3218 level = (class_3218)class_19372;
                        mob.method_5943((class_5425)level, level.method_8404(mob.method_24515()), this.mobSpawnType, null, null);
                    }
                }
                if (!this.level.method_8649(entity)) {
                    return null;
                }
            }
            return (Type)entity;
        }

        Spawner(class_1299<Type> type, class_1937 level) {
            this.type = type;
            this.level = level;
        }
    }

    public static class EntityInvisible {
        int entityId;
        int ticks;

        public EntityInvisible(int entityId, int ticks) {
            this.entityId = entityId;
            this.ticks = ticks;
        }

        public EntityInvisible(class_1297 entity, int ticks) {
            this(entity.method_5628(), ticks);
        }

        public EntityInvisible() {
            this(0, 0);
        }

        @Environment(value=EnvType.CLIENT)
        private static void onClient(EntityInvisible data) {
            EntityHelper.applyToClientEntity(data.entityId, IMixinEntity.class, entity -> entity.majruszlibrary$addInvisibleTicks(data.ticks));
        }

        static {
            Serializables.get(EntityInvisible.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("ticks", Reader.integer(), s -> s.ticks, (s, v) -> {
                s.ticks = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_INVISIBLE.addClientCallback(EntityInvisible::onClient));
        }
    }

    public static class EntityGlow {
        int entityId;
        int ticks;

        public EntityGlow(int entityId, int ticks) {
            this.entityId = entityId;
            this.ticks = ticks;
        }

        public EntityGlow(class_1297 entity, int ticks) {
            this(entity.method_5628(), ticks);
        }

        public EntityGlow() {
            this(0, 0);
        }

        @Environment(value=EnvType.CLIENT)
        private static void onClient(EntityGlow data) {
            EntityHelper.applyToClientEntity(data.entityId, IMixinEntity.class, entity -> entity.majruszlibrary$addGlowTicks(data.ticks));
        }

        static {
            Serializables.get(EntityGlow.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("ticks", Reader.integer(), s -> s.ticks, (s, v) -> {
                s.ticks = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_GLOW.addClientCallback(EntityGlow::onClient));
        }
    }

    public static class EntityAnimation {
        int entityId;
        String name;
        int trackIdx;

        public EntityAnimation(int entityId, String name, int trackIdx) {
            this.entityId = entityId;
            this.name = name;
            this.trackIdx = trackIdx;
        }

        public EntityAnimation(class_1297 entity, String name, int trackIdx) {
            this(entity.method_5628(), name, trackIdx);
        }

        public EntityAnimation() {
            this(0, "", 0);
        }

        @Environment(value=EnvType.CLIENT)
        private static void onClient(EntityAnimation data) {
            EntityHelper.applyToClientEntity(data.entityId, IAnimableEntity.class, entity -> entity.playAnimation(data.name, data.trackIdx));
        }

        static {
            Serializables.get(EntityAnimation.class).define("id", Reader.integer(), s -> s.entityId, (s, v) -> {
                s.entityId = v;
            }).define("name", Reader.string(), s -> s.name, (s, v) -> {
                s.name = v;
            }).define("trackIdx", Reader.integer(), s -> s.trackIdx, (s, v) -> {
                s.trackIdx = v;
            });
            Side.runOnClient(() -> () -> MajruszLibrary.ENTITY_ANIMATION.addClientCallback(EntityAnimation::onClient));
        }
    }
}

