/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.customization;

import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationUtils {
    @Nullable
    public static class_2487 getElytraCustomizationTag(class_1799 elytra) {
        return elytra.method_7941("customizableelytra:customization");
    }

    public static ElytraCustomization getElytraCustomization(class_1799 elytra) {
        class_2487 tag = CustomizationUtils.getElytraCustomizationTag(elytra);
        if (tag == null) {
            class_1799 leftWing = new class_1799((class_1935)ModItems.ELYTRA_WING.get());
            class_1799 rightWing = leftWing.method_7972();
            return new ElytraCustomization(leftWing, rightWing);
        }
        return CustomizationUtils.getElytraCustomization(tag);
    }

    public static ElytraCustomization getElytraCustomization(class_2487 tag) {
        class_1799 leftWing = new class_1799((class_1935)ModItems.ELYTRA_WING.get());
        class_1799 rightWing = new class_1799((class_1935)ModItems.ELYTRA_WING.get());
        if (tag.method_10573("left", 10)) {
            leftWing = CustomizationUtils.getWing(tag.method_10562("left"));
        }
        if (tag.method_10573("right", 10)) {
            rightWing = CustomizationUtils.getWing(tag.method_10562("right"));
        }
        return new ElytraCustomization(leftWing, rightWing);
    }

    private static class_1799 getWing(class_2487 tag) {
        return class_1799.method_7915((class_2487)tag);
    }

    public static int convertDyeColorToInt(class_1767 dyeColor) {
        float[] colorValues = dyeColor.method_7787();
        int red = (int)(colorValues[0] * 255.0f) << 16;
        int green = (int)(colorValues[1] * 255.0f) << 8;
        int blue = (int)(colorValues[2] * 255.0f);
        return red | green | blue;
    }

    public static float[] convertIntToRGB(int color) {
        float redValue = (float)(color >> 16 & 0xFF) / 255.0f;
        float greenValue = (float)(color >> 8 & 0xFF) / 255.0f;
        float blueValue = (float)(color & 0xFF) / 255.0f;
        return new float[]{redValue, greenValue, blueValue};
    }

    public static class_1799 copyCustomizationTagToNewStack(class_1799 stack) {
        class_2487 tag = CustomizationUtils.getElytraCustomizationTag(stack);
        class_1799 outStack = new class_1799((class_1935)stack.method_7909());
        if (tag != null) {
            outStack.method_7948().method_10566("customizableelytra:customization", (class_2520)tag);
        }
        return outStack;
    }

    public static List<class_2561> getElytraWingTooltipLines(class_1799 wing, class_1836 flag, @Nullable class_5455 access) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_1792 class_17922 = wing.method_7909();
        if (!(class_17922 instanceof CustomizableElytraItem)) {
            return lines;
        }
        CustomizableElytraItem item = (CustomizableElytraItem)class_17922;
        if (item.isCapeHidden(wing)) {
            lines.add(CustomizationUtils.getCapeHiddenComponent());
        }
        if (item.isGlowing(wing)) {
            lines.add(CustomizationUtils.getGlowingComponent());
        }
        if (item.method_7801(wing)) {
            lines.add(CustomizationUtils.getColorComponent(wing, flag));
        }
        if (item.hasBanner(wing)) {
            lines.addAll(CustomizationUtils.getBannerComponents(wing));
        }
        if (item.hasArmorTrim(wing) && access != null) {
            lines.addAll(CustomizationUtils.getArmorTrimComponents(wing, access));
        }
        return lines;
    }

    @NotNull
    private static class_2561 getCapeHiddenComponent() {
        return class_2561.method_43471((String)"item.customizableelytra.cape_hidden").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    }

    @NotNull
    private static class_2561 getGlowingComponent() {
        return class_2561.method_43471((String)"item.customizableelytra.glowing_wing").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    }

    @NotNull
    private static class_2561 getColorComponent(class_1799 wing, class_1836 flag) {
        if (flag.method_8035()) {
            return class_2561.method_43469((String)"item.color", (Object[])new Object[]{String.format("#%06X", ((CustomizableElytraItem)wing.method_7909()).method_7800(wing))}).method_27692(class_124.field_1080);
        }
        return class_2561.method_43471((String)"item.dyed").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    }

    @NotNull
    private static List<class_2561> getBannerComponents(class_1799 wing) {
        List<Pair<class_6880<class_2582>, class_1767>> bannerPatterns = ((CustomizableElytraItem)wing.method_7909()).getBannerPatterns(wing);
        ArrayList<class_2561> lines = new ArrayList<class_2561>(bannerPatterns.size());
        for (Pair<class_6880<class_2582>, class_1767> pattern : bannerPatterns) {
            class_6880 patternHolder = (class_6880)pattern.getFirst();
            class_1767 dyeColor = (class_1767)pattern.getSecond();
            patternHolder.method_40230().map(bannerPatternResourceKey -> bannerPatternResourceKey.method_29177().method_43903()).ifPresent(location -> {
                class_2960 bannerPatternLocation = new class_2960(location);
                lines.add((class_2561)class_2561.method_43471((String)("block." + bannerPatternLocation.method_12836() + ".banner." + bannerPatternLocation.method_12832() + "." + dyeColor.method_7792())).method_27692(class_124.field_1080));
            });
        }
        return lines;
    }

    @NotNull
    private static List<class_2561> getArmorTrimComponents(class_1799 wing, @Nullable class_5455 access) {
        if (access == null) {
            return List.of();
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>(3);
        class_8053.method_48425((class_1799)wing, (class_5455)access, lines);
        return lines;
    }

    public static void addComponentsToLists(ElytraCustomization customization, List<class_2561> common, List<class_2561> left, List<class_2561> right, Predicate<class_1799> hasComponent, Function<class_1799, List<class_2561>> componentProvider) {
        class_1799 leftWing = customization.leftWing();
        class_1799 rightWing = customization.rightWing();
        if (hasComponent.test(leftWing)) {
            List<class_2561> leftWingComponents = componentProvider.apply(leftWing);
            if (hasComponent.test(rightWing)) {
                List<class_2561> rightWingComponents = componentProvider.apply(rightWing);
                if (leftWingComponents.equals(rightWingComponents)) {
                    common.addAll(leftWingComponents);
                } else {
                    left.addAll(leftWingComponents);
                    right.addAll(rightWingComponents);
                }
            } else {
                left.addAll(leftWingComponents);
            }
        } else if (hasComponent.test(rightWing)) {
            right.addAll((Collection<class_2561>)componentProvider.apply(rightWing));
        }
    }

    public static List<class_2561> getElytraTooltipLines(class_1799 elytra, class_1836 flag, @Nullable class_5455 access) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytra);
        ArrayList<class_2561> leftWingLines = new ArrayList<class_2561>();
        ArrayList<class_2561> rightWingLines = new ArrayList<class_2561>();
        ArrayList<class_2561> outputLines = new ArrayList<class_2561>();
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).isGlowing((class_1799)stack), stack -> List.of(CustomizationUtils.getGlowingComponent()));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).isCapeHidden((class_1799)stack), stack -> List.of(CustomizationUtils.getCapeHiddenComponent()));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).method_7801((class_1799)stack), stack -> List.of(CustomizationUtils.getColorComponent(stack, flag)));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).hasBanner((class_1799)stack), CustomizationUtils::getBannerComponents);
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).hasArmorTrim((class_1799)stack), stack -> CustomizationUtils.getArmorTrimComponents(stack, access));
        if (!leftWingLines.isEmpty()) {
            outputLines.add((class_2561)class_2561.method_43471((String)"item.customizableelytra.left_wing").method_27692(class_124.field_1080));
            outputLines.addAll(leftWingLines);
        }
        if (!rightWingLines.isEmpty()) {
            outputLines.add((class_2561)class_2561.method_43471((String)"item.customizableelytra.right_wing").method_27692(class_124.field_1080));
            outputLines.addAll(rightWingLines);
        }
        return outputLines;
    }
}

