/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.sodium;

import com.simibubi.create.Create;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.utility.Components;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;

public class SodiumCompat {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    public static final class_2960 SAW_TEXTURE = Create.asResource("block/saw_reversed");

    public static void init() {
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(Mods.SODIUM.id()).orElseThrow();
        Version sodiumVersion = container.getMetadata().getVersion();
        boolean supportsFRAPI = false;
        try {
            supportsFRAPI = VersionPredicate.parse((String)"~0.6.0-").test((Object)sodiumVersion);
        }
        catch (VersionParsingException versionParsingException) {
            // empty catch block
        }
        if (!Mods.INDIUM.isLoaded() && !supportsFRAPI) {
            ClientPlayConnectionEvents.JOIN.register(SodiumCompat::sendNoIndiumWarning);
        }
        boolean compatInitialized = false;
        for (SpriteUtilCompat value : SpriteUtilCompat.values()) {
            if (!value.doesWork.test(sodiumVersion)) continue;
            class_310 mc = class_310.method_1551();
            WorldRenderEvents.START.register(ctx -> {
                Function atlas = mc.method_1549(class_1723.field_21668);
                class_1058 sawSprite = (class_1058)atlas.apply(SAW_TEXTURE);
                value.markSpriteAsActive.get().accept(sawSprite);
            });
            compatInitialized = true;
            break;
        }
        if (!compatInitialized) {
            Create.LOGGER.error("Create's Sodium compat errored and has been partially disabled. Report this!");
        }
    }

    public static void sendNoIndiumWarning(class_634 handler, PacketSender sender, class_310 mc) {
        if (mc.field_1724 == null) {
            return;
        }
        class_5250 text = class_2564.method_10885((class_2561)Components.literal("WARN")).method_27692(class_124.field_1065).method_10852((class_2561)Components.literal(" Sodium is installed, but Indium is not. This will cause visual issues with Create!")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/indium")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Components.literal("Click here to open Indium's mod page"))));
        mc.field_1724.method_7353((class_2561)text, false);
    }

    private static enum SpriteUtilCompat {
        V0_5(version -> {
            try {
                SpriteUtilCompat.invokeOld(null);
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }, () -> SpriteUtilCompat::invokeOld),
        V0_6_API(version -> {
            try {
                return VersionPredicate.parse((String)">=0.6.0-beta.3").test(version);
            }
            catch (VersionParsingException e) {
                return false;
            }
        }, () -> arg_0 -> ((SpriteUtil)SpriteUtil.INSTANCE).markSpriteActive(arg_0));

        private static MethodHandle markSpriteActiveHandle;
        private final Predicate<Version> doesWork;
        private final Supplier<Consumer<class_1058>> markSpriteAsActive;

        private SpriteUtilCompat(Predicate<Version> doesWork, Supplier<Consumer<class_1058>> markSpriteAsActive) {
            this.doesWork = doesWork;
            this.markSpriteAsActive = markSpriteAsActive;
        }

        public static void invokeOld(class_1058 sawSprite) {
            try {
                markSpriteActiveHandle.invoke(sawSprite);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static {
            try {
                Class<?> spriteUtil = Class.forName("nme.jellysquid.mods.sodium.client.render.texture.SpriteUtil");
                MethodType methodType = MethodType.methodType(Void.TYPE, class_1058.class);
                markSpriteActiveHandle = lookup.findStatic(spriteUtil, "markSpriteActive", methodType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

