/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class WindmillBearingBlockEntity
extends MechanicalBearingBlockEntity {
    protected ScrollOptionBehaviour<RotationDirection> movementDirection;
    protected float lastGeneratedSpeed;
    protected boolean queuedReassembly;

    public WindmillBearingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void updateGeneratedRotation() {
        super.updateGeneratedRotation();
        this.lastGeneratedSpeed = this.getGeneratedSpeed();
        this.queuedReassembly = false;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        boolean cancelAssembly = this.assembleNextTick;
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = cancelAssembly;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.queuedReassembly) {
            return;
        }
        this.queuedReassembly = false;
        if (!this.running) {
            this.assembleNextTick = true;
        }
    }

    public void disassembleForMovement() {
        if (!this.running) {
            return;
        }
        this.disassemble();
        this.queuedReassembly = true;
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.running) {
            return 0.0f;
        }
        if (this.movedContraption == null) {
            return this.lastGeneratedSpeed;
        }
        int sails = ((BearingContraption)this.movedContraption.getContraption()).getSailBlocks() / (Integer)AllConfigs.server().kinetics.windmillSailsPerRPM.get();
        return (float)class_3532.method_15340((int)sails, (int)1, (int)16) * this.getAngleSpeedDirection();
    }

    @Override
    protected boolean isWindmill() {
        return true;
    }

    protected float getAngleSpeedDirection() {
        RotationDirection rotationDirection = RotationDirection.values()[this.movementDirection.getValue()];
        return rotationDirection == RotationDirection.CLOCKWISE ? 1 : -1;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10548("LastGenerated", this.lastGeneratedSpeed);
        compound.method_10556("QueueAssembly", this.queuedReassembly);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        if (!this.wasMoved) {
            this.lastGeneratedSpeed = compound.method_10583("LastGenerated");
        }
        this.queuedReassembly = compound.method_10577("QueueAssembly");
        super.read(compound, clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.remove(this.movementMode);
        this.movementDirection = new ScrollOptionBehaviour<RotationDirection>(RotationDirection.class, (class_2561)Lang.translateDirect("contraptions.windmill.rotation_direction", new Object[0]), this, this.getMovementModeSlot());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
        this.registerAwardables(behaviours, AllAdvancements.WINDMILL, AllAdvancements.WINDMILL_MAXED);
    }

    private void onDirectionChanged() {
        if (!this.running) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public boolean isWoodenTop() {
        return true;
    }

    public static enum RotationDirection implements INamedIconOptions
    {
        CLOCKWISE(AllIcons.I_REFRESH),
        COUNTER_CLOCKWISE(AllIcons.I_ROTATE_CCW);

        private String translationKey;
        private AllIcons icon;

        private RotationDirection(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "generic." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

