/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class DisplayLinkBlockEntity
extends SmartBlockEntity {
    protected class_2338 targetOffset = class_2338.field_10980;
    public DisplaySource activeSource;
    private class_2487 sourceConfig = new class_2487();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public LerpedFloat glow = LerpedFloat.linear().startWithValue(0.0);
    private boolean sendPulse;
    public int refreshTicks;
    public AbstractComputerBehaviour computerBehaviour;

    public DisplayLinkBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.glow.chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            this.glow.tickChaser();
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.glow.tickChaser();
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks() || !this.activeSource.shouldPassiveReset()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (this.method_11010().method_28500((class_2769)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.field_11863, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        class_2338 sourcePosition = this.getSourcePosition();
        class_2338 targetPosition = this.getTargetPosition();
        if (!this.field_11863.method_8477(targetPosition) || !this.field_11863.method_8477(sourcePosition)) {
            return;
        }
        DisplayTarget target = AllDisplayBehaviours.targetOf((class_1936)this.field_11863, targetPosition);
        List<DisplaySource> sources = AllDisplayBehaviours.sourcesOf((class_1936)this.field_11863, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new class_2487();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.field_11863, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulse = true;
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        this.writeGatheredData(tag);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeGatheredData(tag);
        if (clientPacket && this.activeTarget != null) {
            tag.method_10582("TargetType", this.activeTarget.id.toString());
        }
        if (clientPacket && this.sendPulse) {
            this.sendPulse = false;
            NBTHelper.putMarker(tag, "Pulse");
        }
    }

    private void writeGatheredData(class_2487 tag) {
        tag.method_10566("TargetOffset", (class_2520)class_2512.method_10692((class_2338)this.targetOffset));
        tag.method_10569("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            class_2487 data = this.sourceConfig.method_10553();
            data.method_10582("Id", this.activeSource.id.toString());
            tag.method_10566("Source", (class_2520)data);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.targetOffset = class_2512.method_10691((class_2487)tag.method_10562("TargetOffset"));
        this.targetLine = tag.method_10550("TargetLine");
        if (clientPacket && tag.method_10545("TargetType")) {
            this.activeTarget = AllDisplayBehaviours.getTarget(new class_2960(tag.method_10558("TargetType")));
        }
        if (clientPacket && tag.method_10545("Pulse")) {
            this.glow.setValue(2.0);
        }
        if (!tag.method_10545("Source")) {
            return;
        }
        class_2487 data = tag.method_10562("Source");
        this.activeSource = AllDisplayBehaviours.getSource(new class_2960(data.method_10558("Id")));
        this.sourceConfig = new class_2487();
        if (this.activeSource != null) {
            this.sourceConfig = data.method_10553();
        }
    }

    public void target(class_2338 targetPosition) {
        this.targetOffset = targetPosition.method_10059((class_2382)this.field_11867);
    }

    public class_2338 getSourcePosition() {
        return this.field_11867.method_10093(this.getDirection());
    }

    public class_2487 getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(class_2487 sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500((class_2769)DisplayLinkBlock.field_10927).orElse(class_2350.field_11036).method_10153();
    }

    public class_2338 getTargetPosition() {
        return this.field_11867.method_10081((class_2382)this.targetOffset);
    }
}

