/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.utils.LevelHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class PortalFluidMixin {
    @Shadow
    public class_1937 field_6002;
    private int fluidCooldown;
    protected boolean isInsideFluid;
    protected class_2338 fluidEntrancePos;
    protected int fluidTime;

    @Shadow
    public abstract int method_5806();

    @Shadow
    public abstract boolean method_5765();

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;handleNetherPortal()V", shift=At.Shift.AFTER)})
    public void insertFluidTick(CallbackInfo ci) {
        this.handlePortalFluid();
    }

    public class_1937 level() {
        return this.field_6002;
    }

    public void setFluidCooldown() {
        this.fluidCooldown = this.method_5806();
    }

    public boolean isOnFluidCooldown() {
        return this.fluidCooldown > 0;
    }

    protected void processFluidCooldown() {
        if (this.isOnFluidCooldown()) {
            --this.fluidCooldown;
        }
    }

    public int getPortalWaitTime() {
        return 0;
    }

    public void handleInsideFluid(class_2338 pos) {
        if (this.isOnFluidCooldown()) {
            this.setFluidCooldown();
        } else {
            if (!this.level().field_9236 && !pos.equals((Object)this.fluidEntrancePos)) {
                this.fluidEntrancePos = pos.method_10062();
            }
            this.isInsideFluid = true;
        }
    }

    protected void handlePortalFluid() {
        if (this.level() instanceof class_3218) {
            int i = this.getPortalWaitTime();
            if (this.isInsideFluid) {
                if (!this.method_5765() && this.fluidTime++ >= i) {
                    this.fluidTime = i;
                    this.setFluidCooldown();
                    class_1297 entity = (class_1297)this;
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        LevelHelper.teleportToSpawnPosition(player);
                    } else {
                        LevelHelper.teleportToWorldspawn(this.field_6002, entity);
                    }
                    entity.method_5783((class_3414)ModSoundEvents.PORTAL_FLUID_TELEPORT.get(), 1.0f, 1.0f);
                }
                this.isInsideFluid = false;
            } else {
                if (this.fluidTime > 0) {
                    this.fluidTime -= 4;
                }
                if (this.fluidTime < 0) {
                    this.fluidTime = 0;
                }
            }
            this.processFluidCooldown();
        }
    }
}

