/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric;

import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeManipulation {
    private static final Logger logger = LoggerFactory.getLogger(RecipeManipulation.class);
    private static final Map<class_1792, class_1856.class_1859> registeredSubstitutes = new HashMap<class_1792, class_1856.class_1859>();

    static void load(@NotNull class_1863 recipeManager) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Collection allRecipes = recipeManager.method_8126();
        logger.info("Scanning {} recipes for modification", (Object)allRecipes.size());
        AtomicInteger ingredientsChanged = new AtomicInteger();
        for (class_1860 recipe : allRecipes) {
            class_2371 ingredients = recipe.method_8117();
            for (class_1856 ingredient : ingredients) {
                registeredSubstitutes.forEach((item, substitute) -> {
                    for (class_1799 stack : ingredient.method_8105()) {
                        if (!stack.method_31574(item)) continue;
                        RecipeManipulation.addSubstitute(ingredient, substitute);
                        ingredientsChanged.getAndIncrement();
                    }
                });
            }
        }
        logger.info("Modified {} recipe ingredients in {}", (Object)ingredientsChanged, (Object)stopwatch);
    }

    private static void addSubstitute(@NotNull class_1856 ingredient, class_1856.class_1859 substitute) {
        ingredient.field_9019 = Arrays.copyOf(ingredient.field_9019, ingredient.field_9019.length + 1);
        ingredient.field_9019[ingredient.field_9019.length - 1] = substitute;
        ingredient.field_9016 = null;
        ingredient.field_9018 = null;
    }

    public static void registerSubstitute(class_1792 item, class_1856.class_1859 substitute) {
        registeredSubstitutes.put(item, substitute);
    }

    public static void registerSubstitute(class_1792 item, class_1792 substitute) {
        RecipeManipulation.registerSubstitute(item, (class_1856.class_1859)new class_1856.class_1857(new class_1799((class_1935)substitute)));
    }

    public static void registerSubstitute(class_1792 item, class_6862<class_1792> substitute) {
        RecipeManipulation.registerSubstitute(item, (class_1856.class_1859)new class_1856.class_1858(substitute));
    }
}

