/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.computercraft.peripherals;

import cc.tweaked_programs.cccbridge.common.computercraft.TweakedPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.SourceBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.TermMethods;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceBlockPeripheral
extends TermMethods
implements TweakedPeripheral<SourceBlockEntity> {
    private final SourceBlockEntity be;
    private final Terminal term = new Terminal(4, 2, false);

    public static double getVersion() {
        return 1.1;
    }

    public SourceBlockPeripheral(SourceBlockEntity blockentity) {
        this.be = blockentity;
    }

    public void setSize(int width, int height) {
        int oldW = this.term.getWidth();
        int oldH = this.term.getHeight();
        if (oldW == width && oldH == height) {
            return;
        }
        this.term.resize(width, height);
        this.sendEvent("monitor_resize", new Object[0]);
    }

    public List<String> getContent() {
        LinkedList<String> content = new LinkedList<String>();
        for (int i = 0; i < this.term.getHeight(); ++i) {
            content.add(this.term.getLine(i).toString());
        }
        return content;
    }

    @LuaFunction
    public final void write(String text) {
        this.term.write(text);
        this.term.setCursorPos(this.term.getCursorX() + text.length(), this.term.getCursorY());
    }

    public Terminal getTerminal() throws LuaException {
        return this.term;
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @Override
    @NotNull
    public String getType() {
        return "create_source";
    }

    @Override
    @Nullable
    public SourceBlockEntity getTarget() {
        return this.be;
    }
}

