/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.blay09.mods.balm.api.config.LenientEnumCodecs;
import net.blay09.mods.balm.api.config.schema.builder.BooleanConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.DoubleConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.FloatConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.IntConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.LongConfigProperty;
import net.blay09.mods.balm.common.codec.ByteBufCodecs;
import net.blay09.mods.balm.common.codec.StreamCodec;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7995;

public class PrimitiveConfigCodecs {
    public static <T> Codec<T> codec(Class<T> type) {
        if (type == String.class) {
            return Codec.STRING;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return IntConfigProperty.CODEC;
        }
        if (type == Long.class || type == Long.TYPE) {
            return LongConfigProperty.CODEC;
        }
        if (type == Float.class || type == Float.TYPE) {
            return FloatConfigProperty.CODEC;
        }
        if (type == Double.class || type == Double.TYPE) {
            return DoubleConfigProperty.CODEC;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BooleanConfigProperty.CODEC;
        }
        if (type == class_2960.class) {
            return class_2960.field_25139;
        }
        if (type.isEnum()) {
            return PrimitiveConfigCodecs.enumCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> Codec<T> enumCodec(Class<T> type) {
        return LenientEnumCodecs.fromValues(type::getEnumConstants);
    }

    public static <T> StreamCodec<class_2540, T> streamCodec(Class<T> type) {
        if (type == String.class) {
            return ByteBufCodecs.STRING_UTF8;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return ByteBufCodecs.INT;
        }
        if (type == Long.class || type == Long.TYPE) {
            return ByteBufCodecs.LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return ByteBufCodecs.FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return ByteBufCodecs.DOUBLE;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return ByteBufCodecs.BOOL;
        }
        if (type == class_2960.class) {
            return ByteBufCodecs.RESOURCE_LOCATION;
        }
        if (type.isEnum()) {
            return PrimitiveConfigCodecs.enumStreamCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> StreamCodec<class_2540, T> enumStreamCodec(Class<T> type) {
        IntFunction byIdMapper = class_7995.method_47914(Enum::ordinal, (Object[])((Enum[])type.getEnumConstants()), (class_7995.class_7996)class_7995.class_7996.field_41664);
        return ByteBufCodecs.idMapper(byIdMapper, Enum::ordinal);
    }
}

