/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyManager;
import com.mrh0.createaddition.index.CAItems;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import team.reborn.energy.api.EnergyStorage;

public class EnergyThresholdCondition
extends CargoThresholdCondition {
    protected class_2561 getUnit() {
        return Components.literal((String)"Kfe");
    }

    protected class_1799 getIcon() {
        return CAItems.CAPACITOR.asStack();
    }

    public class_1799 getSecondLineIcon() {
        return CAItems.CAPACITOR.asStack();
    }

    public int slotsTargeted() {
        return 0;
    }

    public boolean lazyTickCompletion(class_1937 level, Train train, class_2487 context) {
        return this.test(level, train, context);
    }

    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        long target = this.getThreshold();
        long foundEnergy = 0L;
        for (Carriage carriage : train.carriages) {
            EnergyStorage ies;
            if (carriage.anyAvailableEntity() == null || (ies = PortableEnergyManager.get(carriage.anyAvailableEntity().getContraption())) == null) continue;
            foundEnergy += ies.getAmount();
        }
        this.requestStatusToUpdate(foundEnergy / 1000L, context);
        return operator.test(foundEnergy, target * 1000L);
    }

    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.threshold.train_holds", (Object[])new Object[]{Lang.translateDirect((String)("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name())), (Object[])new Object[0])}), (Object)Lang.translateDirect((String)"schedule.condition.threshold.x_units_of_item", (Object[])new Object[]{this.getThreshold(), class_2561.method_43471((String)"createaddition.schedule.condition.threshold.unit"), class_2561.method_43471((String)"createaddition.schedule.condition.threshold.energy")}).method_27692(class_124.field_1062));
    }

    public class_2960 getId() {
        return CreateAddition.asResource("energy_threshold");
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List)ImmutableList.of((Object)class_2561.method_43471((String)"createaddition.schedule.condition.threshold.unit"))).titled(null), "Measure");
    }

    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        long lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1L) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect((String)"schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0L, this.getThreshold() + (long)offset), class_2561.method_43471((String)"createaddition.schedule.condition.threshold.unit")});
    }
}

