/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.sound.api.FrozenSoundPackets;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class MovingLoopingSoundEntityManager {
    private final ArrayList<SoundLoopData> sounds = new ArrayList();
    public class_1297 entity;

    public MovingLoopingSoundEntityManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(class_2487 nbt) {
        if (nbt.method_10573("frozenSounds", 9)) {
            this.sounds.clear();
            DataResult var10000 = SoundLoopData.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("frozenSounds", 10)));
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            if (list.isPresent()) {
                List allSounds = (List)list.get();
                this.sounds.addAll(allSounds);
            }
        }
    }

    public void save(class_2487 nbt) {
        if (!this.sounds.isEmpty()) {
            DataResult var10000 = SoundLoopData.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.sounds);
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> nbt.method_10566("frozenSounds", cursorsNbt));
        }
    }

    public void addSound(class_2960 soundID, class_3419 category, float volume, float pitch, class_2960 restrictionId, boolean stopOnDeath) {
        this.sounds.add(new SoundLoopData(soundID, category, volume, pitch, restrictionId, stopOnDeath));
        SoundPredicate.getPredicate(restrictionId).onStart(this.entity);
    }

    public List<SoundLoopData> getSounds() {
        return this.sounds;
    }

    public void tick() {
        if (!this.sounds.isEmpty()) {
            ArrayList<SoundLoopData> soundsToRemove = new ArrayList<SoundLoopData>();
            for (SoundLoopData nbt : this.sounds) {
                SoundPredicate.LoopPredicate<class_1297> predicate = SoundPredicate.getPredicate(nbt.restrictionID);
                if (predicate.test(this.entity)) continue;
                soundsToRemove.add(nbt);
                predicate.onStop(this.entity);
            }
            this.sounds.removeAll(soundsToRemove);
        }
    }

    public void syncWithPlayer(class_3222 serverPlayer) {
        for (SoundLoopData nbt : this.getSounds()) {
            FrozenSoundPackets.createMovingRestrictionLoopingSound(serverPlayer, this.entity, (class_3414)class_7923.field_41172.method_10223(nbt.getSoundEventID()), (class_3419)class_3419.valueOf(class_3419.class, (String)nbt.getOrdinal()), nbt.volume, nbt.pitch, nbt.restrictionID, nbt.stopOnDeath);
        }
    }

    public static class SoundLoopData {
        public final class_2960 soundEventID;
        public final String categoryOrdinal;
        public final float volume;
        public final float pitch;
        public final class_2960 restrictionID;
        public final boolean stopOnDeath;
        public static final Codec<SoundLoopData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("soundEventID").forGetter(SoundLoopData::getSoundEventID), (App)Codec.STRING.fieldOf("categoryOrdinal").forGetter(SoundLoopData::getOrdinal), (App)Codec.FLOAT.fieldOf("volume").forGetter(SoundLoopData::getVolume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(SoundLoopData::getPitch), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(SoundLoopData::getRestrictionID), (App)Codec.BOOL.fieldOf("stopOnDeath").forGetter(SoundLoopData::getStopOnDeath)).apply((Applicative)instance, SoundLoopData::new));

        public SoundLoopData(class_2960 soundEventID, String ordinal, float vol, float pitch, class_2960 restrictionID, boolean stopOnDeath) {
            this.soundEventID = soundEventID;
            this.categoryOrdinal = ordinal;
            this.volume = vol;
            this.pitch = pitch;
            this.restrictionID = restrictionID;
            this.stopOnDeath = stopOnDeath;
        }

        public SoundLoopData(class_2960 soundEventID, class_3419 category, float vol, float pitch, class_2960 restrictionID, boolean stopOnDeath) {
            this.soundEventID = soundEventID;
            this.categoryOrdinal = category.toString();
            this.volume = vol;
            this.pitch = pitch;
            this.restrictionID = restrictionID;
            this.stopOnDeath = stopOnDeath;
        }

        public class_2960 getSoundEventID() {
            return this.soundEventID;
        }

        public String getOrdinal() {
            return this.categoryOrdinal;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public class_2960 getRestrictionID() {
            return this.restrictionID;
        }

        public boolean getStopOnDeath() {
            return this.stopOnDeath;
        }
    }
}

