/*
 * Decompiled with CFR 0.152.
 */
package pyzpre.createbicyclesbitterballen.block.mechanicalfryer;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.ViewOnlyWrappedStorageView;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import pyzpre.createbicyclesbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import pyzpre.createbicyclesbitterballen.block.mechanicalfryer.FryerOperatingBlockEntity;
import pyzpre.createbicyclesbitterballen.index.RecipeRegistry;
import pyzpre.createbicyclesbitterballen.index.SoundsRegistry;

public class MechanicalFryerEntity
extends FryerOperatingBlockEntity
implements SidedStorageBlockEntity {
    private static final Object DeepFryingRecipesKey = new Object();
    private boolean shouldRecalculateProcessingTicks = true;
    public SmartInventory inputInv = new SmartInventory(1, (SyncedBlockEntity)this);
    public SmartInventory outputInv = new SmartInventory(999, (SyncedBlockEntity)this);
    public FryerInventoryHandler capability = new FryerInventoryHandler();
    public int timer;
    private DeepFryingRecipe lastRecipe;
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalFryerEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running && this.speed != 0.0f) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -1.5, 0.0);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.running = compound.method_10577("Running");
        this.runningTicks = compound.method_10550("Ticks");
        this.timer = compound.method_10550("Timer");
        this.inputInv.deserializeNBT(compound.method_10562("InputInventory"));
        this.outputInv.deserializeNBT(compound.method_10562("OutputInventory"));
        this.shouldRecalculateProcessingTicks = compound.method_10577("ShouldRecalculate");
        super.read(compound, clientPacket);
        if (clientPacket && this.method_11002()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Running", this.running);
        compound.method_10569("Ticks", this.runningTicks);
        compound.method_10569("Timer", this.timer);
        compound.method_10566("InputInventory", (class_2520)this.inputInv.serializeNBT());
        compound.method_10566("OutputInventory", (class_2520)this.outputInv.serializeNBT());
        compound.method_10556("ShouldRecalculate", this.shouldRecalculateProcessingTicks);
        super.write(compound, clientPacket);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        return this.capability;
    }

    @Override
    public void tick() {
        super.tick();
        float speed = Math.abs(this.getSpeed());
        boolean canStartProcessing = this.hasMatchingRecipe();
        float recipeSpeed = 1.0f;
        if (this.getSpeed() == 0.0f && this.running) {
            this.resetAnimationAndProcessing();
        }
        if (!this.running && canStartProcessing) {
            int t;
            this.running = true;
            this.runningTicks = 0;
            this.shouldRecalculateProcessingTicks = true;
            if (this.currentRecipe instanceof ProcessingRecipe && (t = ((ProcessingRecipe)this.currentRecipe).getProcessingDuration()) != 0) {
                recipeSpeed = (float)t / 100.0f;
            }
        }
        if (this.running) {
            if (this.processingTicks > 0) {
                if (this.runningTicks < 20) {
                    ++this.runningTicks;
                }
                --this.processingTicks;
            } else if (this.runningTicks < 40) {
                ++this.runningTicks;
            } else if (!canStartProcessing) {
                this.running = false;
                this.runningTicks = 0;
                this.shouldRecalculateProcessingTicks = false;
            } else {
                this.shouldRecalculateProcessingTicks = true;
                this.runningTicks = 0;
            }
            if (this.runningTicks == 20 && this.processingTicks == 1) {
                SmartInventory itemStorage = this.inputInv;
                try (Transaction transaction = Transaction.openOuter();){
                    boolean[] foundIce = new boolean[]{false};
                    itemStorage.forEach(view -> {
                        class_1799 stack = ((ItemVariant)view.getResource()).toStack((int)view.getAmount());
                        if (this.isIce(stack)) {
                            long extracted;
                            if (!foundIce[0]) {
                                this.causeExplosion();
                                foundIce[0] = true;
                            }
                            if ((extracted = view.extract((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction)) > 0L) {
                                // empty if block
                            }
                        }
                    });
                    if (foundIce[0]) {
                        transaction.commit();
                    }
                }
            }
            if (this.runningTicks == 20) {
                if (this.processingTicks == 1) {
                    Optional<BasinBlockEntity> basinOpt = this.getBasin();
                    basinOpt.ifPresent(basin -> {
                        if (this.lastRecipe == null || !this.lastRecipe.matches(this.inputInv, this.field_11863)) {
                            Optional recipe = RecipeRegistry.DEEP_FRYING.find((ItemStackHandlerContainer)this.inputInv, this.field_11863);
                            if (!recipe.isPresent()) {
                                return;
                            }
                            this.lastRecipe = (DeepFryingRecipe)((Object)((Object)recipe.get()));
                        }
                        if (this.lastRecipe != null && DeepFryingRecipe.apply((ItemStackHandlerContainer)this.inputInv, basin, this, this.lastRecipe)) {
                            try (Transaction t = TransferUtil.getTransaction();){
                                ItemStackHandlerSlot slot = this.inputInv.getSlot(0);
                                slot.extract(slot.getResource(), 1L, (TransactionContext)t);
                                t.commit();
                                this.sendData();
                                this.method_5431();
                            }
                        }
                    });
                }
                if (this.runningTicks == 20 && this.shouldRecalculateProcessingTicks && canStartProcessing) {
                    int duration;
                    if (this.lastRecipe != null && (duration = this.lastRecipe.getProcessingDuration()) != 0) {
                        recipeSpeed = (float)duration / 100.0f;
                    }
                    this.processingTicks = class_3532.method_15340((int)(class_3532.method_15351((int)((int)(512.0f / speed))) * class_3532.method_15386((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    this.shouldRecalculateProcessingTicks = false;
                }
            }
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    private boolean isIce(class_1799 stack) {
        class_6862 iceTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("create_bic_bit", "ice"));
        return stack.method_31573(iceTag);
    }

    private void resetAnimationAndProcessing() {
        this.running = false;
        this.processingTicks = 0;
        this.runningTicks = 0;
    }

    private void grantAdvancementCriterion(class_3222 player) {
        class_167 advancementProgress;
        class_2985 playerAdvancements = player.method_14236();
        class_161 advancement = player.field_13995.method_3851().method_12896(new class_2960("create_bic_bit:fry_about_it"));
        if (advancement != null && advancement.method_682().containsKey("ice_exploded") && !(advancementProgress = playerAdvancements.method_12882(advancement)).method_740()) {
            playerAdvancements.method_12878(advancement, "ice_exploded");
        }
    }

    private void causeExplosion() {
        if (!this.field_11863.method_8608()) {
            this.field_11863.method_8537(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, 4.0f, false, class_1937.class_7867.field_40890);
            double radius = 10.0;
            class_238 area = new class_238(this.field_11867).method_1014(radius);
            List players = this.field_11863.method_18467(class_3222.class, area);
            for (class_3222 player : players) {
                this.grantAdvancementCriterion(player);
            }
        }
    }

    private boolean hasMatchingRecipe() {
        if (this.inputInv.method_5442()) {
            return false;
        }
        Optional<DeepFryingRecipe> recipeOpt = this.findMatchingRecipeForItem(this.inputInv.getStackInSlot(0), this.field_11863);
        if (recipeOpt.isEmpty()) {
            return false;
        }
        Optional<BasinBlockEntity> basinOpt = this.getBasin();
        if (basinOpt.isEmpty()) {
            return false;
        }
        DeepFryingRecipe recipe = recipeOpt.get();
        if (!this.areBasinFluidsMatching(basinOpt.get(), recipe)) {
            return false;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        return this.isBlazeBurnerConfigured(requiredHeat);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((class_1937)this.field_11863, (class_2338)this.field_11867, (Storage)this.inputInv);
        ItemHelper.dropContents((class_1937)this.field_11863, (class_2338)this.field_11867, (Storage)this.outputInv);
    }

    private boolean isBlazeBurnerConfigured(HeatCondition requiredHeat) {
        class_2586 blockEntity;
        if (requiredHeat == HeatCondition.NONE) {
            return true;
        }
        if (this.field_11863 == null) {
            return false;
        }
        class_2338 posBelowBasin = this.field_11867.method_10087(3);
        class_2680 blockStateBelow = this.field_11863.method_8320(posBelowBasin);
        class_2248 blockBelow = blockStateBelow.method_26204();
        if (blockBelow instanceof BlazeBurnerBlock) {
            BlazeBurnerBlock.HeatLevel actualHeat = BlazeBurnerBlock.getHeatLevelOf((class_2680)blockStateBelow);
            return requiredHeat.testBlazeBurner(actualHeat);
        }
        if (FabricLoader.getInstance().isModLoaded("createaddition") && blockBelow instanceof LiquidBlazeBurnerBlock && (blockEntity = this.field_11863.method_8321(posBelowBasin)) instanceof LiquidBlazeBurnerBlockEntity) {
            BlazeBurnerBlock.HeatLevel actualHeat = ((LiquidBlazeBurnerBlockEntity)blockEntity).getHeatLevelFromBlock();
            return requiredHeat.testBlazeBurner(actualHeat);
        }
        return false;
    }

    private Optional<DeepFryingRecipe> findMatchingRecipeForItem(class_1799 stack, class_1937 level) {
        for (class_1860 recipe : level.method_8433().method_30027(RecipeRegistry.DEEP_FRYING.getType())) {
            DeepFryingRecipe deepFryingRecipe;
            if (!(recipe instanceof DeepFryingRecipe) || !(deepFryingRecipe = (DeepFryingRecipe)recipe).matches(this.inputInv, level)) continue;
            return Optional.of(deepFryingRecipe);
        }
        return Optional.empty();
    }

    private boolean areBasinFluidsMatching(BasinBlockEntity basin, DeepFryingRecipe recipe) {
        Storage availableFluids = basin.getFluidStorage(null);
        if (availableFluids == null) {
            return false;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            long totalFluidAmount = 0L;
            Transaction transaction = Transaction.openOuter();
            try {
                long extracted;
                StorageView view;
                Iterator iterator = availableFluids.iterator();
                while (iterator.hasNext() && ((view = (StorageView)iterator.next()).isResourceBlank() || !fluidIngredient.test(new FluidStack(((FluidVariant)view.getResource()).getFluid(), 1L)) || (extracted = view.extract((Object)((FluidVariant)view.getResource()), fluidIngredient.getRequiredAmount(), (TransactionContext)transaction)) <= 0L || (totalFluidAmount += extracted) < fluidIngredient.getRequiredAmount())) {
                }
                if (totalFluidAmount >= fluidIngredient.getRequiredAmount()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        return true;
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty() || this.field_11863 == null) {
            return;
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle((FluidStack)tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(class_2394 data) {
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (class_2350.class_2351)class_2350.class_2351.field_11052).method_1031(0.0, 0.25, 0.0);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (class_5819)this.field_11863.field_9229, (float)0.0078125f);
        this.field_11863.method_8406(data, center.field_1352, center.field_1351 - 1.75, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    protected <C extends class_1263> boolean matchStaticFilters(class_1860<C> recipe) {
        return recipe.method_17716() == RecipeRegistry.DEEP_FRYING.getType();
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return DeepFryingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            SoundsRegistry.FRYING.playAt(this.field_11863, (class_2382)this.field_11867, 0.75f, 1.0f, true);
            this.renderParticles();
        }
    }

    public boolean canProcess(class_1799 stack) {
        if (this.lastRecipe != null && this.isItemValidForRecipe(this.lastRecipe, stack)) {
            return true;
        }
        List recipes = this.field_11863.method_8433().method_30027(RecipeRegistry.DEEP_FRYING.get());
        for (DeepFryingRecipe recipe : recipes) {
            if (!this.isItemValidForRecipe(recipe, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isItemValidForRecipe(DeepFryingRecipe recipe, class_1799 stack) {
        return recipe.method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(stack));
    }

    public class FryerInventoryHandler
    extends CombinedStorage<ItemVariant, ItemStackHandler> {
        public FryerInventoryHandler() {
            super(List.of(MechanicalFryerEntity.this.inputInv, MechanicalFryerEntity.this.outputInv));
        }

        public long insert(@NotNull ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (MechanicalFryerEntity.this.canProcess(resource.toStack())) {
                long inserted = MechanicalFryerEntity.this.inputInv.insert(resource, maxAmount, transaction);
                return inserted;
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long extracted = MechanicalFryerEntity.this.outputInv.extract(resource, maxAmount, transaction);
            return extracted;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return new FryerInventoryHandlerIterator();
        }

        private class FryerInventoryHandlerIterator
        implements Iterator<StorageView<ItemVariant>> {
            private boolean output = true;
            private Iterator<StorageView<ItemVariant>> wrapped;

            public FryerInventoryHandlerIterator() {
                this.wrapped = MechanicalFryerEntity.this.outputInv.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public StorageView<ItemVariant> next() {
                if (!this.output && !this.wrapped.hasNext()) {
                    this.wrapped = MechanicalFryerEntity.this.inputInv.iterator();
                    this.output = false;
                }
                ViewOnlyWrappedStorageView view = this.wrapped.next();
                if (!this.output) {
                    view = new ViewOnlyWrappedStorageView(view);
                }
                return view;
            }
        }
    }
}

