/*
 * Decompiled with CFR 0.152.
 */
package pyzpre.createbicyclesbitterballen.index;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2405;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import pyzpre.createbicyclesbitterballen.CreateBitterballen;

public class SoundsRegistry {
    public static final Map<class_2960, SoundEntry> ALL = new HashMap<class_2960, SoundEntry>();
    public static final SoundEntry FRYING = SoundsRegistry.create("frying").subtitle("Frying noises").playExisting(class_3417.field_14946, 0.125f, 1.6f).category(class_3419.field_15245).build();

    private static SoundEntryBuilder create(String name) {
        return SoundsRegistry.create(CreateBitterballen.asResource(name));
    }

    public static SoundEntryBuilder create(class_2960 id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register() {
        for (SoundEntry entry : ALL.values()) {
            entry.register();
        }
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static class_2405 provider(FabricDataOutput output) {
        return new SoundEntryProvider((class_7784)output);
    }

    public static void playItemPickup(class_1657 player) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + CreateBitterballen.RANDOM.nextFloat());
    }

    public static class SoundEntryBuilder {
        protected class_2960 id;
        protected String subtitle = "unregistered";
        protected class_3419 category = class_3419.field_15245;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<class_2960> variants = new ArrayList<class_2960>();
        protected int attenuationDistance;

        public SoundEntryBuilder(class_2960 id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(class_3419 category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(CreateBitterballen.asResource(name));
        }

        public SoundEntryBuilder addVariant(class_2960 id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<class_3414> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(class_3414 event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(class_3414 event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntryBuilder playExisting(class_6880<class_3414> event) {
            return this.playExisting(() -> event.comp_349(), 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    public static abstract class SoundEntry {
        protected class_2960 id;
        protected String subtitle;
        protected class_3419 category;
        protected int attenuationDistance;

        public SoundEntry(class_2960 id, String subtitle, class_3419 category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void prepare();

        public abstract void register();

        public abstract void write(JsonObject var1);

        public abstract class_3414 getMainEvent();

        public String getSubtitleKey() {
            return this.id.method_12836() + ".subtitle." + this.id.method_12832();
        }

        public class_2960 getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(class_1937 world, class_2382 pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(class_1937 world, class_2382 pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity, float volume, float pitch) {
            if (!entity.method_5701()) {
                this.play(entity.method_37908(), null, (class_2382)entity.method_24515(), volume, pitch);
            }
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos, float volume, float pitch) {
            this.play(world, entity, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_243 pos, float volume, float pitch) {
            this.play(world, entity, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch);
        }

        public abstract void play(class_1937 var1, class_1657 var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(class_1937 world, class_2382 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, volume, pitch, fade);
        }

        public void playAt(class_1937 world, class_243 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch, fade);
        }

        public abstract void playAt(class_1937 var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    private static class SoundEntryProvider
    implements class_2405 {
        private class_7784 output;

        public SoundEntryProvider(class_7784 output) {
            this.output = output;
        }

        public CompletableFuture<?> method_10319(class_7403 cache) {
            return this.generate(this.output.method_45971(), cache);
        }

        public String method_10321() {
            return "Create Bitterballen Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            path = path.resolve("assets/create_bic_bit");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<class_2960> variants;
        protected class_3414 event;

        public CustomSoundEntry(class_2960 id, List<class_2960> variants, String subtitle, class_3419 category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.variants = variants;
        }

        @Override
        public void prepare() {
            this.event = class_3414.method_47908((class_2960)this.id);
        }

        @Override
        public void register() {
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)this.event.method_14833(), (Object)this.event);
        }

        @Override
        public class_3414 getMainEvent() {
            return this.event;
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.id.toString());
            s.addProperty("type", "file");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            for (class_2960 variant : this.variants) {
                s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.method_12832(), (JsonElement)entry);
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            world.method_43128(entity, x, y, z, this.event, this.category, volume, pitch);
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.method_8486(x, y, z, this.event, this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private List<ConfiguredSoundEvent> wrappedEvents;
        private List<CompiledSoundEvent> compiledEvents;

        public WrappedSoundEntry(class_2960 id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, class_3419 category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = new ArrayList<CompiledSoundEvent>();
        }

        @Override
        public void prepare() {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                class_2960 location = this.getIdOf(i);
                class_3414 event = class_3414.method_47908((class_2960)location);
                this.compiledEvents.add(new CompiledSoundEvent(event, wrapped.volume(), wrapped.pitch()));
            }
        }

        @Override
        public void register() {
            for (CompiledSoundEvent event : this.compiledEvents) {
                class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)event.event().method_14833(), (Object)event.event());
            }
        }

        protected class_2960 getIdOf(int i) {
            return new class_2960(this.id.method_12836(), (String)(i == 0 ? this.id.method_12832() : this.id.method_12832() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().method_14833().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).method_12832(), (JsonElement)entry);
            }
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.method_43128(entity, x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.method_8486(x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }

        @Override
        public class_3414 getMainEvent() {
            return this.compiledEvents.isEmpty() ? null : this.compiledEvents.get(0).event();
        }

        private record CompiledSoundEvent(class_3414 event, float volume, float pitch) {
        }
    }

    public record ConfiguredSoundEvent(Supplier<class_3414> event, float volume, float pitch) {
    }
}

