/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.PresenceVisualizer;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ScrollableTextWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.function.Consumer;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class PresenceEditorGui
extends ConfigurationGui<PresenceData> {
    private final PresenceData DEFAULTS;
    private final PresenceData INSTANCE;
    private final PresenceData CURRENT;
    private final boolean isDefaultModule;
    private final Consumer<PresenceData> onChangedCallback;
    private final PresenceVisualizer visualizer;
    private TextWidget detailsFormat;
    private TextWidget gameStateFormat;
    private TextWidget largeImageFormat;
    private TextWidget smallImageFormat;
    private TextWidget smallImageKeyFormat;
    private TextWidget largeImageKeyFormat;
    private TextWidget startTimeFormat;
    private TextWidget endTimeFormat;
    private CheckBoxControl useAsMainCheckbox;
    private CheckBoxControl enabledCheckbox;
    private ExtendedButtonControl activityTypeButton;
    private ExtendedButtonControl partyPrivacyButton;
    private int currentActivityType = ActivityType.Playing.ordinal();
    private int currentPartyPrivacy = PartyPrivacy.Public.ordinal();

    PresenceEditorGui(PresenceData moduleData, PresenceData defaultData, boolean isDefault, Consumer<PresenceData> changedCallback) {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.editor.presence", new Object[0]));
        this.DEFAULTS = defaultData;
        this.INSTANCE = moduleData.copy();
        this.CURRENT = moduleData;
        this.isDefaultModule = isDefault;
        this.onChangedCallback = changedCallback;
        this.visualizer = new PresenceVisualizer(this);
    }

    PresenceEditorGui(PresenceData moduleData, PresenceData defaultData, Consumer<PresenceData> changedCallback) {
        this(moduleData, defaultData, false, changedCallback);
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int calc1Width = this.childFrame.getScreenWidth() - calc1;
        String generalFieldsTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.general", new Object[0]);
        String largeImageTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.image.large", new Object[0]);
        String smallImageTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.image.small", new Object[0]);
        String extraFieldsTitle = Constants.TRANSLATOR.translate("gui.config.message.editor.presence.extra", new Object[0]);
        int controlIndex = 0;
        this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.getButtonY(controlIndex++), calc1Width, generalFieldsTitle));
        if (!this.isDefaultModule) {
            this.enabledCheckbox = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(controlIndex), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.enabled", new Object[0]), this.getInstanceData().enabled, () -> {
                this.getInstanceData().enabled = this.enabledCheckbox.isChecked();
            }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.enabled", new Object[0])))));
            this.useAsMainCheckbox = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(controlIndex), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.use_as_main", new Object[0]), this.getInstanceData().useAsMain, () -> {
                this.getInstanceData().useAsMain = this.useAsMainCheckbox.isChecked();
                this.reloadUi();
            }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.use_as_main", new Object[0])))));
        }
        int n = ++controlIndex;
        this.detailsFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n), 180, 20, () -> this.getInstanceData().setDetails(this.detailsFormat.getControlMessage()), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.details", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        int n2 = ++controlIndex;
        this.gameStateFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n2), 180, 20, () -> this.getInstanceData().setGameState(this.gameStateFormat.getControlMessage()), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.game_state", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        this.detailsFormat.setControlMessage(this.getInstanceData().details);
        this.gameStateFormat.setControlMessage(this.getInstanceData().gameState);
        int n3 = ++controlIndex;
        this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.getButtonY(n3), calc1Width, largeImageTitle));
        int n4 = ++controlIndex;
        this.largeImageFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n4), 180, 20, () -> {
            this.getInstanceData().largeImageText = this.largeImageFormat.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        int n5 = ++controlIndex;
        this.largeImageKeyFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n5), 147, 20, () -> {
            this.getInstanceData().largeImageKey = this.largeImageKeyFormat.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.message.editor.icon.change", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.largeImageKeyFormat, (attributeName, currentValue) -> {
            this.getInstanceData().largeImageKey = currentValue;
        });
        this.largeImageFormat.setControlMessage(this.getInstanceData().largeImageText);
        this.largeImageKeyFormat.setControlMessage(this.getInstanceData().largeImageKey);
        int n6 = ++controlIndex;
        this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.getButtonY(n6), calc1Width, smallImageTitle));
        int n7 = ++controlIndex;
        this.smallImageFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n7), 180, 20, () -> {
            this.getInstanceData().smallImageText = this.smallImageFormat.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        int n8 = ++controlIndex;
        this.smallImageKeyFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n8), 147, 20, () -> {
            this.getInstanceData().smallImageKey = this.smallImageKeyFormat.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.message.editor.icon.change", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.icon", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.smallImageKeyFormat, (attributeName, currentValue) -> {
            this.getInstanceData().smallImageKey = currentValue;
        });
        this.smallImageFormat.setControlMessage(this.getInstanceData().smallImageText);
        this.smallImageKeyFormat.setControlMessage(this.getInstanceData().smallImageKey);
        this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.getButtonY(++controlIndex), calc2 - calc1, extraFieldsTitle));
        this.childFrame.addControl((class_364)new ExtendedButtonControl(calc2, this.getButtonY(controlIndex), 180, 20, Constants.TRANSLATOR.translate("gui.config.message.editor.presence.button_editor", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.button", new Object[0]), this.getInstanceData().buttons.keySet(), null, null, true, true, DynamicScrollableList.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.attributeName = "button_" + this.getInstanceData().buttons.size();
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", new Object[]{screenInstance.attributeName}));
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.primaryMessage = "";
            screenInstance.secondaryMessage = "";
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.overrideSecondaryRender = true;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_button", new Object[]{attributeName}));
            Button currentData = this.getInstanceData().buttons.get(attributeName);
            screenInstance.isPreliminaryData = currentData == null;
            screenInstance.originalPrimaryMessage = "";
            screenInstance.originalSecondaryMessage = "";
            screenInstance.primaryMessage = Config.getProperty(currentData, "label") != null ? currentData.label : screenInstance.originalPrimaryMessage;
            screenInstance.secondaryMessage = Config.getProperty(currentData, "url") != null ? currentData.url : screenInstance.originalSecondaryMessage;
        }, screenInstance -> {
            String secondaryText = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            this.getInstanceData().addButton(screenInstance.attributeName, new Button(inputText, secondaryText));
        }, screenInstance -> this.getInstanceData().removeButton(screenInstance.attributeName), null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button.label", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button.url", new Object[0])))), (class_437)parentScreen))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.button_editor", new Object[0]))), new String[0]));
        int n9 = ++controlIndex;
        this.startTimeFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n9), 180, 20, () -> this.getInstanceData().setStartTime(this.startTimeFormat.getControlMessage()), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.start_timestamp", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        int n10 = ++controlIndex;
        this.endTimeFormat = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(n10), 180, 20, () -> this.getInstanceData().setEndTime(this.endTimeFormat.getControlMessage()), Constants.TRANSLATOR.translate("gui.config.message.editor.presence.end_timestamp", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.presence.args.general", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")})))));
        this.startTimeFormat.setControlMessage(this.getInstanceData().startTimestamp);
        this.endTimeFormat.setControlMessage(this.getInstanceData().endTimestamp);
        this.currentActivityType = this.getInstanceData().activityType;
        this.activityTypeButton = (ExtendedButtonControl)this.childFrame.addControl((class_364)new ExtendedButtonControl(calc1, this.getButtonY(++controlIndex), 180, 20, Constants.TRANSLATOR.translate("gui.config.message.editor.presence.activity_type", new Object[0]) + " => " + ActivityType.from(this.currentActivityType).name(), () -> {
            this.currentActivityType = (this.currentActivityType + 1) % ActivityType.values().length;
            this.activityTypeButton.setControlMessage(Constants.TRANSLATOR.translate("gui.config.message.editor.presence.activity_type", new Object[0]) + " => " + ActivityType.from(this.currentActivityType).name());
            this.getInstanceData().activityType = this.currentActivityType;
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.activity_type", new Object[0]))), new String[0]));
        this.currentPartyPrivacy = this.getInstanceData().partyPrivacy;
        this.partyPrivacyButton = (ExtendedButtonControl)this.childFrame.addControl((class_364)new ExtendedButtonControl(calc2, this.getButtonY(controlIndex), 180, 20, Constants.TRANSLATOR.translate("gui.config.message.editor.presence.party_privacy", new Object[0]) + " => " + PartyPrivacy.from(this.currentPartyPrivacy).name(), () -> {
            this.currentPartyPrivacy = (this.currentPartyPrivacy + 1) % PartyPrivacy.values().length;
            this.partyPrivacyButton.setControlMessage(Constants.TRANSLATOR.translate("gui.config.message.editor.presence.party_privacy", new Object[0]) + " => " + PartyPrivacy.from(this.currentPartyPrivacy).name());
            this.getInstanceData().partyPrivacy = this.currentPartyPrivacy;
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence.party_privacy", new Object[0]))), new String[0]));
        this.visualizer.setupVisualizer(calc1, calc2, ++controlIndex, this.isDefaultModule || this.getInstanceData().useAsMain, (ExtendedScreen)this.childFrame, () -> CraftPresence.CLIENT.compilePresence(this.getInstanceData()));
    }

    public void postRender() {
        super.postRender();
        this.visualizer.postRender((ExtendedScreen)this.childFrame);
    }

    @Override
    protected boolean allowedToReset() {
        return this.DEFAULTS != null;
    }

    @Override
    protected PresenceData getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected PresenceData getCurrentData() {
        return this.CURRENT;
    }

    @Override
    protected PresenceData getDefaultData() {
        return this.DEFAULTS;
    }

    @Override
    protected boolean setCurrentData(PresenceData data) {
        if (this.onChangedCallback != null && this.hasChangesBetween(this.getCurrentData(), data)) {
            this.onChangedCallback.accept(data);
            return true;
        }
        return false;
    }
}

