/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import com.mojang.authlib.GameProfile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.content.entity.AbstractGravestoneBlockEntity;
import net.pneumono.gravestones.content.entity.AestheticGravestoneBlockEntity;
import net.pneumono.gravestones.content.entity.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.TimeFormatType;

@Environment(value=EnvType.CLIENT)
public class GravestoneBlockEntityRenderer
implements class_827<AbstractGravestoneBlockEntity> {
    private final class_327 textRenderer;

    public GravestoneBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    public void render(AbstractGravestoneBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        int rotation = switch (entity.getGravestoneDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036, class_2350.field_11043 -> 0;
            case class_2350.field_11039 -> 90;
            case class_2350.field_11035 -> 180;
            case class_2350.field_11034 -> 270;
        };
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22905(0.0625f, -0.0625f, 0.0625f);
        matrices.method_46416(-8.0f, -15.0f, -8.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)rotation));
        matrices.method_22904(0.0, 0.0, -4.95);
        float scale = 0.14285715f;
        matrices.method_22905(scale, scale, scale);
        for (int i = 0; i < 4; ++i) {
            matrices.method_46416(0.0f, 2.0f * (1.0f / scale), 0.0f);
            class_5250 text = class_2561.method_43470((String)"");
            if (entity instanceof TechnicalGravestoneBlockEntity) {
                TechnicalGravestoneBlockEntity blockEntity = (TechnicalGravestoneBlockEntity)entity;
                text = class_2561.method_43470((String)(switch (i) {
                    case 0 -> {
                        GameProfile profileComponent = blockEntity.getGraveOwner();
                        if (profileComponent != null) {
                            yield profileComponent.getName();
                        }
                        yield "???";
                    }
                    case 1 -> this.getGravestoneTimeLines(blockEntity, true);
                    case 2 -> this.getGravestoneTimeLines(blockEntity, false);
                    default -> "";
                }));
            } else if (entity instanceof AestheticGravestoneBlockEntity) {
                AestheticGravestoneBlockEntity blockEntity = (AestheticGravestoneBlockEntity)entity;
                text = blockEntity.getText().method_49859(i, false);
            }
            this.drawText((class_2561)text, matrices, vertexConsumers, light);
        }
        matrices.method_22909();
    }

    public void drawText(class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        this.textRenderer.method_30882(text, (float)(-this.textRenderer.method_27525((class_5348)text) / 2), 0.0f, 0, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, light);
    }

    private String getGravestoneTimeLines(TechnicalGravestoneBlockEntity entity, boolean line) {
        String spawnDateTime = entity.getSpawnDateTime();
        String text = "";
        if (spawnDateTime != null) {
            try {
                SimpleDateFormat fromServer = GravestoneTime.getSimpleDateFormat();
                TimeFormatType type = (TimeFormatType)((Object)Gravestones.TIME_FORMAT.getValue());
                SimpleDateFormat toClient = new SimpleDateFormat(line ? type.getDateFormat() : type.getTimeFormat());
                text = toClient.format(fromServer.parse(spawnDateTime));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return text;
    }
}

