/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.data.DataModule;

public class KiwiShapelessRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private final List<class_1856> ingredients = Lists.newArrayList();
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private boolean noContainers;

    public KiwiShapelessRecipeBuilder(class_7800 recipeCategory, class_1935 itemLike, int i) {
        this.category = recipeCategory;
        this.result = itemLike.method_8389();
        this.count = i;
    }

    public static KiwiShapelessRecipeBuilder shapeless(class_7800 recipeCategory, class_1935 itemLike) {
        return new KiwiShapelessRecipeBuilder(recipeCategory, itemLike, 1);
    }

    public static KiwiShapelessRecipeBuilder shapeless(class_7800 recipeCategory, class_1935 itemLike, int i) {
        return new KiwiShapelessRecipeBuilder(recipeCategory, itemLike, i);
    }

    public KiwiShapelessRecipeBuilder requires(class_6862<class_1792> tagKey) {
        return this.requires(class_1856.method_8106(tagKey));
    }

    public KiwiShapelessRecipeBuilder requires(class_1935 itemLike) {
        return this.requires(itemLike, 1);
    }

    public KiwiShapelessRecipeBuilder requires(class_1935 itemLike, int i) {
        for (int j = 0; j < i; ++j) {
            this.requires(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}));
        }
        return this;
    }

    public KiwiShapelessRecipeBuilder requires(class_1856 ingredient) {
        return this.requires(ingredient, 1);
    }

    public KiwiShapelessRecipeBuilder requires(class_1856 ingredient, int i) {
        for (int j = 0; j < i; ++j) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public KiwiShapelessRecipeBuilder unlockedBy(String string, class_184 criterionTriggerInstance) {
        this.advancement.method_709(string, criterionTriggerInstance);
        return this;
    }

    public KiwiShapelessRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public KiwiShapelessRecipeBuilder noContainers() {
        this.noContainers = true;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> consumer, class_2960 resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)resourceLocation)).method_703(class_170.class_171.method_753((class_2960)resourceLocation)).method_704(class_193.field_1257);
        consumer.accept((class_2444)new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, KiwiShapelessRecipeBuilder.method_46202((class_7800)this.category), this.ingredients, this.advancement, resourceLocation.method_45138("recipes/" + this.category.method_46203() + "/"), this.noContainers));
    }

    private void ensureValid(class_2960 resourceLocation) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    extends class_7798.class_7799 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<class_1856> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final boolean noContainers;

        public Result(class_2960 resourceLocation, class_1792 item, int i, String string, class_7710 craftingBookCategory, List<class_1856> list, class_161.class_162 builder, class_2960 resourceLocation2, boolean noContainers) {
            super(craftingBookCategory);
            this.id = resourceLocation;
            this.result = item;
            this.count = i;
            this.group = string;
            this.ingredients = list;
            this.advancement = builder;
            this.advancementId = resourceLocation2;
            this.noContainers = noContainers;
        }

        public void method_10416(JsonObject jsonObject) {
            super.method_10416(jsonObject);
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                jsonArray.add(ingredient.method_8089());
            }
            jsonObject.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject2.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject2);
            if (this.noContainers) {
                jsonObject.addProperty("no_containers", Boolean.valueOf(true));
            }
        }

        public class_1865<?> method_17800() {
            return DataModule.SHAPELESS.get();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

