/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    @Nullable
    private class_1799 stack;
    @Nullable
    private class_2487 tag;

    private NBTHelper(@Nullable class_2487 tag, @Nullable class_1799 stack) {
        this.stack = stack;
        this.tag = tag;
    }

    @Nullable
    public class_2487 getTag(String key) {
        return this.getTag(key, false);
    }

    public class_2487 getTag(String key, boolean createIfNull) {
        return this.getTagInternal(key, createIfNull, false);
    }

    private class_2487 getTagInternal(String key, boolean createIfNull, boolean ignoreLastNode) {
        if (this.tag == null) {
            if (createIfNull) {
                this.tag = new class_2487();
                if (this.stack != null) {
                    this.stack.method_7980(this.tag);
                }
            } else {
                return null;
            }
        }
        if (key.isEmpty()) {
            return this.tag;
        }
        class_2487 subTag = this.tag;
        String[] parts = key.split("\\.");
        int length = parts.length;
        if (ignoreLastNode) {
            --length;
        }
        for (int i = 0; i < length; ++i) {
            if (!subTag.method_10573(parts[i], 10)) {
                if (createIfNull) {
                    subTag.method_10566(parts[i], (class_2520)new class_2487());
                } else {
                    return null;
                }
            }
            subTag = (class_2487)subTag.method_10580(parts[i]);
        }
        return subTag;
    }

    private class_2487 getTagInternal(String key) {
        return this.getTagInternal(key, true, true);
    }

    private String getLastNode(String key) {
        int index = key.lastIndexOf(".");
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    public NBTHelper setTag(String key, class_2520 value) {
        this.getTagInternal(key).method_10566(this.getLastNode(key), value);
        return this;
    }

    public NBTHelper setInt(String key, int value) {
        this.getTagInternal(key).method_10569(this.getLastNode(key), value);
        return this;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 3)) {
            return subTag.method_10550(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setLong(String key, long value) {
        this.getTagInternal(key).method_10544(this.getLastNode(key), value);
        return this;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 4)) {
            return subTag.method_10537(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setShort(String key, short value) {
        this.getTagInternal(key).method_10575(this.getLastNode(key), value);
        return this;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 2)) {
            return subTag.method_10568(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setDouble(String key, double value) {
        this.getTagInternal(key).method_10549(this.getLastNode(key), value);
        return this;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 6)) {
            return subTag.method_10574(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setFloat(String key, float value) {
        this.getTagInternal(key).method_10548(this.getLastNode(key), value);
        return this;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 5)) {
            return subTag.method_10583(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setByte(String key, byte value) {
        this.getTagInternal(key).method_10548(this.getLastNode(key), (float)value);
        return this;
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 1)) {
            return subTag.method_10571(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setBoolean(String key, boolean value) {
        this.getTagInternal(key).method_10556(this.getLastNode(key), value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 1)) {
            return subTag.method_10577(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setPos(String key, class_2338 value) {
        this.getTagInternal(key).method_10566(this.getLastNode(key), (class_2520)class_2512.method_10692((class_2338)value));
        return this;
    }

    @Nullable
    public class_2338 getPos(String key) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 10)) {
            return class_2512.method_10691((class_2487)this.getTag(actualKey));
        }
        return null;
    }

    public NBTHelper setBlockState(String key, class_2680 value) {
        return this.setTag(key, (class_2520)class_2512.method_10686((class_2680)value));
    }

    public class_2680 getBlockState(String key) {
        class_2487 subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)subTag);
        }
        return class_2246.field_10124.method_9564();
    }

    public NBTHelper setGameProfile(String key, GameProfile value) {
        class_2512.method_10684((class_2487)this.getTag(key, true), (GameProfile)value);
        return this;
    }

    @Nullable
    public GameProfile getGameProfile(String key) {
        class_2487 subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return class_2512.method_10683((class_2487)subTag);
        }
        return null;
    }

    public NBTHelper setString(String key, String value) {
        this.getTagInternal(key).method_10582(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 8)) {
            return subTag.method_10558(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setIntArray(String key, int[] value) {
        this.getTagInternal(key).method_10539(this.getLastNode(key), value);
        return this;
    }

    public int[] getIntArray(String key) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 11)) {
            return subTag.method_10561(actualKey);
        }
        return new int[0];
    }

    public NBTHelper setByteArray(String key, byte[] value) {
        this.getTagInternal(key).method_10570(this.getLastNode(key), value);
        return this;
    }

    public byte[] getByteArray(String key) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 7)) {
            return subTag.method_10547(actualKey);
        }
        return new byte[0];
    }

    public NBTHelper setUUID(String key, UUID value) {
        this.getTagInternal(key).method_25927(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public UUID getUUID(String key) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (!(subTag == null || subTag.method_10573((actualKey = this.getLastNode(key)) + "Most", 4) && subTag.method_10573(actualKey + "Least", 4))) {
            return subTag.method_25926(actualKey);
        }
        return null;
    }

    public class_2499 getTagList(String key, int type) {
        String actualKey;
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.method_10573(actualKey = this.getLastNode(key), 9)) {
            return subTag.method_10554(actualKey, type);
        }
        return null;
    }

    public boolean hasTag(String key, int type) {
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            if (key.isEmpty()) {
                return true;
            }
            String actualKey = this.getLastNode(key);
            return subTag.method_10573(actualKey, type);
        }
        return false;
    }

    public Set<String> keySet(String key) {
        return this.hasTag(key, 10) ? this.getTag(key).method_10541() : Collections.EMPTY_SET;
    }

    public NBTHelper remove(String key) {
        class_2487 subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            subTag.method_10551(actualKey);
        }
        return this;
    }

    @Nullable
    public class_2487 get() {
        return this.tag;
    }

    public class_1799 getItem() {
        return this.stack == null ? class_1799.field_8037 : this.stack;
    }

    public static NBTHelper of(class_1799 stack) {
        return new NBTHelper(stack.method_7969(), stack);
    }

    public static NBTHelper of(class_2487 tag) {
        return new NBTHelper(tag, null);
    }

    public static NBTHelper create() {
        return NBTHelper.of(new class_2487());
    }
}

