/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.base.data.compat.emi.EmiRecipeDefaultsGen;
import com.railwayteam.railways.content.palettes.boiler.BoilerBlock;
import com.railwayteam.railways.content.palettes.boiler.BoilerCTBehaviour;
import com.railwayteam.railways.content.palettes.smokebox.PalettesSmokeboxBlock;
import com.railwayteam.railways.registry.CRSpriteShifts;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.ColorUtils;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2465;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRPalettes {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final Map<@Nullable class_1767, class_6862<class_1792>> CYCLE_GROUPS = new HashMap<class_1767, class_6862<class_1792>>(17, 2.0f);

    public static void register() {
        ModSetup.usePalettesTab();
        for (Styles style : Styles.values()) {
            style.register(null);
        }
        for (class_1767 dyeColor : ColorUtils.ORDERED_DYE_COLORS) {
            for (Styles style : Styles.values()) {
                style.register(dyeColor);
            }
        }
        ModSetup.useBaseTab();
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (class_1767 class_17672 : class_1767.values()) {
            consumer.accept("tag.item.railways.palettes.cycle_groups." + class_17672.method_7792(), TextUtils.joinSpace(ColorUtils.coloredName(class_17672.method_7792()), "Locometal"));
        }
        consumer.accept("tag.item.railways.palettes.cycle_groups.base", "Locometal");
        for (Styles styles : Styles.values()) {
            consumer.accept("tag.item.railways.palettes.dye_groups." + styles.name().toLowerCase(Locale.ROOT), styles.dyeGroupLang);
        }
    }

    @SafeVarargs
    private static BlockEntry<?> slashedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "slashed_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "slashed"))).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(CRSpriteShifts.SLASHED_LOCOMETAL.get(color))))).lang(TextUtils.joinSpace(colorName, "Slashed Locometal")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    private static BlockEntry<?> rivetedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "riveted_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "riveted"))).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(CRSpriteShifts.RIVETED_LOCOMETAL.get(color))))).lang(TextUtils.joinSpace(colorName, "Riveted Locometal")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    private static BlockEntry<?> locometalPillar(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "locometal_pillar"), class_2465::new).transform(BuilderTransformers.locoMetalPillar(color))).lang(TextUtils.joinSpace(colorName, "Locometal Pillar")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> locometalSmokebox(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "locometal_smokebox"), PalettesSmokeboxBlock::new).transform(BuilderTransformers.locoMetalSmokeBox(color))).lang(TextUtils.joinSpace(colorName, "Locometal Smokebox")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> platedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "plated_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "sheeting"))).lang(TextUtils.joinSpace("Plated", colorName, "Locometal")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> flatSlashedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "flat_slashed_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "annexed_slashed"))).lang(TextUtils.joinSpace("Flat", colorName, "Slashed Locometal")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> flatRivetedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "flat_riveted_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "annexed_riveted"))).lang(TextUtils.joinSpace("Flat", colorName, "Riveted Locometal")).item().tag(tags).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"block.railways.generic_radial"))).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> brassWrappedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "brass_wrapped_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "wrapped_slashed"))).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(CRSpriteShifts.BRASS_WRAPPED_LOCOMETAL.get(color))))).lang(TextUtils.joinSpace(colorName, "Brass Wrapped Locometal")).item().tag(tags).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> copperWrappedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "copper_wrapped_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "copper_wrapped_slashed"))).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(CRSpriteShifts.COPPER_WRAPPED_LOCOMETAL.get(color))))).lang(TextUtils.joinSpace(colorName, "Copper Wrapped Locometal")).item().tag(tags).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> ironWrappedLocometal(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "iron_wrapped_locometal"), class_2248::new).transform(BuilderTransformers.locoMetalBase(color, "iron_wrapped_slashed"))).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(CRSpriteShifts.IRON_WRAPPED_LOCOMETAL.get(color))))).lang(TextUtils.joinSpace(colorName, "Iron Wrapped Locometal")).item().tag(tags).build()).register();
    }

    @SafeVarargs
    public static BlockEntry<?> locometalBoiler(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "locometal_boiler"), BoilerBlock::new).transform(BuilderTransformers.locoMetalBoiler(color, null))).onRegister(CreateRegistrate.connectedTextures(() -> new BoilerCTBehaviour(CRSpriteShifts.BOILER_SIDE.get(color))))).lang(TextUtils.joinSpace(colorName, "Locometal Boiler")).item().tag(tags).transform(ModelGen.customItemModel((String[])new String[]{TextUtils.joinUnderscore(colorString, "locometal_boiler_gullet_x")}))).register();
    }

    @SafeVarargs
    public static BlockEntry<?> brassWrappedLocometalBoiler(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "brass_wrapped_locometal_boiler"), BoilerBlock::new).transform(BuilderTransformers.locoMetalBoiler(color, Wrapping.BRASS))).onRegister(CreateRegistrate.connectedTextures(() -> new BoilerCTBehaviour(CRSpriteShifts.BRASS_WRAPPED_BOILER_SIDE.get(color))))).lang(TextUtils.joinSpace(colorName, "Brass Wrapped Locometal Boiler")).item().tag(tags).transform(ModelGen.customItemModel((String[])new String[]{TextUtils.joinUnderscore(colorString, "brass_wrapped_locometal_boiler_gullet_x")}))).register();
    }

    @SafeVarargs
    public static BlockEntry<?> copperWrappedLocometalBoiler(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "copper_wrapped_locometal_boiler"), BoilerBlock::new).transform(BuilderTransformers.locoMetalBoiler(color, Wrapping.COPPER))).onRegister(CreateRegistrate.connectedTextures(() -> new BoilerCTBehaviour(CRSpriteShifts.COPPER_WRAPPED_BOILER_SIDE.get(color))))).lang(TextUtils.joinSpace(colorName, "Copper Wrapped Locometal Boiler")).item().tag(tags).transform(ModelGen.customItemModel((String[])new String[]{TextUtils.joinUnderscore(colorString, "copper_wrapped_locometal_boiler_gullet_x")}))).register();
    }

    @SafeVarargs
    public static BlockEntry<?> ironWrappedLocometalBoiler(@Nullable class_1767 color, String colorString, String colorName, class_6862<class_1792> ... tags) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(TextUtils.joinUnderscore(colorString, "iron_wrapped_locometal_boiler"), BoilerBlock::new).transform(BuilderTransformers.locoMetalBoiler(color, Wrapping.IRON))).onRegister(CreateRegistrate.connectedTextures(() -> new BoilerCTBehaviour(CRSpriteShifts.IRON_WRAPPED_BOILER_SIDE.get(color))))).lang(TextUtils.joinSpace(colorName, "Iron Wrapped Locometal Boiler")).item().tag(tags).transform(ModelGen.customItemModel((String[])new String[]{TextUtils.joinUnderscore(colorString, "iron_wrapped_locometal_boiler_gullet_x")}))).register();
    }

    static {
        CYCLE_GROUPS.put(null, CRTags.optionalTag(class_7923.field_41178, Railways.asResource("palettes/cycle_groups/base")));
        for (class_1767 dyeColor : ColorUtils.ORDERED_DYE_COLORS) {
            CYCLE_GROUPS.put(dyeColor, CRTags.optionalTag(class_7923.field_41178, Railways.asResource("palettes/cycle_groups/" + dyeColor.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static enum Styles {
        SLASHED(CRPalettes::slashedLocometal, true, "Slashed Locometal"),
        RIVETED(CRPalettes::rivetedLocometal, true, "Riveted Locometal"),
        PILLAR(CRPalettes::locometalPillar, true, "Locometal Pillars"),
        SMOKEBOX(CRPalettes::locometalSmokebox, true, "Locometal Smokeboxes"),
        PLATED(CRPalettes::platedLocometal, true, "Plated Locometal"),
        FLAT_SLASHED(CRPalettes::flatSlashedLocometal, true, "Flat Slashed Locometal"),
        FLAT_RIVETED(CRPalettes::flatRivetedLocometal, true, "Flat Riveted Locometal"),
        BRASS_WRAPPED_SLASHED(CRPalettes::brassWrappedLocometal, false, "Brass Wrapped Locometal"),
        COPPER_WRAPPED_SLASHED(CRPalettes::copperWrappedLocometal, false, "Copper Wrapped Locometal"),
        IRON_WRAPPED_SLASHED(CRPalettes::ironWrappedLocometal, false, "Iron Wrapped Locometal"),
        BOILER(CRPalettes::locometalBoiler, false, "Locometal Boilers"),
        BRASS_WRAPPED_BOILER(CRPalettes::brassWrappedLocometalBoiler, false, "Brass Wrapped Locometal Boilers"),
        COPPER_WRAPPED_BOILER(CRPalettes::copperWrappedLocometalBoiler, false, "Copper Wrapped Locometal Boilers"),
        IRON_WRAPPED_BOILER(CRPalettes::ironWrappedLocometalBoiler, false, "Iron Wrapped Locometal Boilers");

        private static Styles[] CYCLING;
        private final Map<@Nullable class_1767, BlockEntry<?>> blocks = new HashMap(17, 2.0f);
        private final PaletteBlockRegistrar registrar;
        public final class_6862<class_1792> dyeGroupTag;
        public final boolean includeInCycleGroup;
        public final String dyeGroupLang;

        public static Styles[] getCyclingValues() {
            if (CYCLING == null) {
                int cyclingCount = 0;
                for (Styles style : Styles.values()) {
                    if (!style.includeInCycleGroup) continue;
                    ++cyclingCount;
                }
                CYCLING = new Styles[cyclingCount];
                int index = 0;
                for (Styles style : Styles.values()) {
                    if (!style.includeInCycleGroup) continue;
                    Styles.CYCLING[index++] = style;
                }
            }
            return Arrays.copyOf(CYCLING, CYCLING.length);
        }

        private Styles(PaletteBlockRegistrar registrar, boolean includeInCycleGroup, String dyeGroupLang) {
            this.registrar = registrar;
            this.dyeGroupLang = dyeGroupLang;
            this.dyeGroupTag = CRTags.optionalTag(class_7923.field_41178, Railways.asResource("palettes/dye_groups/" + this.name().toLowerCase(Locale.ROOT)));
            this.includeInCycleGroup = includeInCycleGroup;
        }

        private void register(@Nullable class_1767 dyeColor) {
            if (this.includeInCycleGroup) {
                this.blocks.put(dyeColor, this.registrar.register(dyeColor, this.dyeGroupTag, CYCLE_GROUPS.get(dyeColor)));
            } else {
                this.blocks.put(dyeColor, this.registrar.register(dyeColor, this.dyeGroupTag));
            }
            if (dyeColor == null) {
                EmiRecipeDefaultsGen.TAG_DEFAULTS.put(this.dyeGroupTag, this.blocks.get(null).getId());
            }
        }

        public BlockEntry<?> get(@Nullable class_1767 color) {
            return this.blocks.get(color);
        }

        public boolean contains(class_2248 block) {
            return this.blocks.values().stream().anyMatch(e -> e.get() == block);
        }

        static {
            CYCLING = null;
        }
    }

    public static enum Wrapping {
        BRASS(false, Styles.BRASS_WRAPPED_BOILER),
        COPPER(true, Styles.COPPER_WRAPPED_BOILER),
        IRON(true, Styles.IRON_WRAPPED_BOILER);

        private final boolean doPrefix;
        public final Styles boilerStyle;

        private Wrapping(boolean doPrefix, Styles boilerStyle) {
            this.doPrefix = doPrefix;
            this.boilerStyle = boilerStyle;
        }

        public String prefix(String base) {
            return this.doPrefix ? this.name().toLowerCase(Locale.ROOT) + "_" + base : base;
        }
    }

    public static class CyclingStyleList<T>
    implements Iterable<T> {
        private final Map<Styles, T> values = new EnumMap<Styles, T>(Styles.class);

        public CyclingStyleList(Function<Styles, T> filler) {
            for (Styles style : Styles.getCyclingValues()) {
                this.values.put(style, filler.apply(style));
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < Styles.getCyclingValues().length;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return values.get((Object)Styles.getCyclingValues()[this.index++]);
                }
            };
        }
    }

    public static class StyledList<T>
    implements Iterable<T> {
        private final Map<Styles, T> values = new EnumMap<Styles, T>(Styles.class);

        public StyledList(Function<Styles, T> filler) {
            for (Styles style : Styles.values()) {
                this.values.put(style, filler.apply(style));
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < Styles.values().length;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return values.get((Object)Styles.values()[this.index++]);
                }
            };
        }
    }

    @FunctionalInterface
    private static interface PaletteBlockRegistrar {
        @ApiStatus.NonExtendable
        default public BlockEntry<?> register(@Nullable class_1767 color, class_6862<class_1792> ... tags) {
            String colorString = color == null ? "" : color.name().toLowerCase(Locale.ROOT);
            return this.register(color, colorString, color == null ? "" : ColorUtils.coloredName(colorString), tags);
        }

        @ApiStatus.OverrideOnly
        public BlockEntry<?> register(@Nullable class_1767 var1, String var2, String var3, class_6862<class_1792> ... var4);
    }
}

