/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.satisfy.bloomingnature.core.entity.ModBoatEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class ModBoatRenderer<T extends ModBoatEntity>
extends class_897<T> {
    private final Map<ModBoatEntity.Type, Pair<class_2960, class_4595<class_1690>>> boatResources;

    public ModBoatRenderer(class_5617.class_5618 context, boolean hasChest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)type.getTexture(hasChest), this.createBoatModel(context, (ModBoatEntity.Type)((Object)type), hasChest))));
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 context, ModBoatEntity.Type type, boolean hasChest) {
        class_5601 modelLayerLocation = hasChest ? new class_5601(new class_2960("bloomingnature", type.getChestModelLocation()), "main") : new class_5601(new class_2960("bloomingnature", type.getModelLocation()), "main");
        class_630 modelPart = context.method_32167(modelLayerLocation);
        return hasChest ? new class_7752(modelPart) : new class_554(modelPart);
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.375f, 0.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.method_7533() - partialTicks;
        float g = entity.method_7554() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * g / 10.0f * (float)entity.method_7543()));
        }
        if (!class_3532.method_15347((float)entity.method_7547(partialTicks), (float)0.0f)) {
            matrixStack.method_22907(new Quaternionf().setAngleAxis(entity.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.boatResources.get((Object)((ModBoatEntity)((Object)entity)).getWoodType());
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        class_4595 listModel = (class_4595)pair.getSecond();
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listModel.method_2819(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = buffer.getBuffer(listModel.method_23500(resourceLocation));
        listModel.method_2828(matrixStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.method_5869()) {
            class_4588 vertexConsumer2 = buffer.getBuffer(class_1921.method_23589());
            if (listModel instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)listModel;
                waterPatchModel.method_22954().method_22698(matrixStack, vertexConsumer2, packedLight, class_4608.field_21444);
            }
        }
        matrixStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @NotNull
    public class_2960 getTextureLocation(ModBoatEntity boat) {
        return (class_2960)this.boatResources.get((Object)boat.getWoodType()).getFirst();
    }
}

