/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.base.PartialBlockDamageSaveData;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class PartialBlockDamageManager {
    private Map<class_5321<class_1937>, Map<class_2338, Integer>> blockDamage;
    private Map<class_5321<class_1937>, Map<class_2338, class_2680>> blockStates;
    private PartialBlockDamageSaveData savedata;

    public PartialBlockDamageManager() {
        this.cleanUp();
    }

    public void playerLogin(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 splayer = (class_3222)player;
            this.loadDamageData(splayer.method_5682());
        }
    }

    public void playerLogout(class_1657 player) {
    }

    public void levelLoaded(class_1936 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return;
        }
        this.cleanUp();
        this.savedata = null;
        this.loadDamageData(server);
    }

    private void cleanUp() {
        this.blockDamage = new HashMap<class_5321<class_1937>, Map<class_2338, Integer>>();
    }

    private void loadDamageData(MinecraftServer server) {
        if (this.savedata != null) {
            return;
        }
        this.savedata = PartialBlockDamageSaveData.load(server);
        this.blockDamage = this.savedata.getBlockDamage();
        this.blockStates = new Object2ObjectLinkedOpenHashMap();
    }

    public void tick(class_1937 level) {
        class_5321 dimension = level.method_27983();
        if (!this.blockDamage.containsKey(dimension)) {
            return;
        }
        Map<class_2338, Integer> levelSet = this.blockDamage.get(dimension);
        Object2ObjectLinkedOpenHashMap blockStateSet = this.blockStates.get(dimension);
        if (levelSet.isEmpty()) {
            this.blockDamage.remove(dimension);
            this.blockStates.remove(dimension);
            return;
        }
        if (level.method_8510() % 20L != 0L) {
            return;
        }
        Object2ObjectLinkedOpenHashMap newSet = new Object2ObjectLinkedOpenHashMap();
        Iterator<Map.Entry<class_2338, Integer>> iter = levelSet.entrySet().iterator();
        while (iter.hasNext()) {
            int newPart;
            double toughnessRec;
            int oldPart;
            boolean blockChanged;
            Map.Entry<class_2338, Integer> entry = iter.next();
            class_2338 pos = entry.getKey();
            class_2680 state = level.method_8500(pos).method_8320(pos);
            int oldProgress = entry.getValue();
            boolean bl = blockChanged = blockStateSet != null && blockStateSet.containsKey(pos) && !blockStateSet.get(pos).equals(state);
            if (state.method_45474() || !state.method_51367() || state.method_26214((class_1922)level, pos) == -1.0f || blockChanged) {
                if (oldProgress > 0) {
                    level.method_8517(-1, pos, -1);
                }
                iter.remove();
                continue;
            }
            if (blockStateSet == null) {
                blockStateSet = new Object2ObjectLinkedOpenHashMap();
                this.blockStates.put((class_5321<class_1937>)dimension, (Map<class_2338, class_2680>)blockStateSet);
            }
            blockStateSet.put(pos, state);
            int newProgress = oldProgress - 3;
            if (newProgress <= 0) {
                CBCUtils.sendCustomBlockDamage(level, pos, -1);
                iter.remove();
            } else {
                newSet.put(entry.getKey(), newProgress);
            }
            if ((oldPart = (int)Math.floor((double)oldProgress * (toughnessRec = 1.0 / BlockArmorPropertiesHandler.getProperties(state).toughness(level, state, pos, true)))) - (newPart = (int)Math.floor((double)newProgress * toughnessRec)) <= 0) continue;
            CBCUtils.sendCustomBlockDamage(level, pos, newPart);
        }
        levelSet.putAll((Map<class_2338, Integer>)newSet);
        if (blockStateSet != null && blockStateSet.isEmpty()) {
            this.blockStates.remove(dimension);
        }
        this.markDirty();
    }

    public void markDirty() {
        if (this.savedata != null) {
            this.savedata.method_80();
        }
    }

    public boolean damageBlock(class_2338 pos, int added, class_2680 state, class_1937 level) {
        return this.damageBlock(pos, added, state, level, PartialBlockDamageManager::destroyBlockDefault);
    }

    public static void voidBlock(class_1937 level, class_2338 pos) {
        level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
    }

    public static void destroyBlockDefault(class_1937 level, class_2338 pos) {
        level.method_22352(pos, false);
    }

    public boolean damageBlock(class_2338 pos, int added, class_2680 state, class_1937 level, BiConsumer<class_1937, class_2338> onDestroy) {
        Map levelSet = this.blockDamage.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new Object2ObjectLinkedOpenHashMap());
        int oldProgress = levelSet.getOrDefault(pos, 0);
        levelSet.merge(pos, added, Integer::sum);
        double toughnessRec = 1.0 / BlockArmorPropertiesHandler.getProperties(state).toughness(level, state, pos, true);
        int oldPart = (int)Math.floor((double)oldProgress * toughnessRec);
        int newPart = (int)Math.floor((double)((Integer)levelSet.get(pos)).intValue() * toughnessRec);
        boolean destroyed = false;
        if (newPart >= 10) {
            if (!level.method_8608()) {
                onDestroy.accept(level, pos);
            }
            levelSet.remove(pos);
            Map<class_2338, class_2680> stateSet = this.blockStates.get(level.method_27983());
            if (stateSet != null) {
                stateSet.remove(pos);
            }
            CBCUtils.sendCustomBlockDamage(level, pos, -1);
            destroyed = true;
        } else if (newPart - oldPart > 0) {
            CBCUtils.sendCustomBlockDamage(level, pos, newPart);
        }
        this.markDirty();
        return destroyed;
    }
}

