/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileHitEffect;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileParticleEffectModifiers;
import rbasamoyai.createbigcannons.multiloader.EnvExecute;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public record BlockHitEffect(List<class_2394> impactParticles, List<class_2394> deflectParticles, HitSound impactSound, HitSound deflectSound) {
    public static BlockHitEffect fromJson(JsonObject obj) throws CommandSyntaxException, JsonParseException {
        ArrayList<class_2394> impactParticles = new ArrayList<class_2394>();
        if (class_3518.method_15289((JsonObject)obj, (String)"impact_particle")) {
            String particle = class_3518.method_15265((JsonObject)obj, (String)"impact_particle");
            Iterator options = class_2223.method_9418((StringReader)new StringReader(particle), (class_7225)class_7923.field_41180.method_46771());
            impactParticles.add((class_2394)options);
        } else if (class_3518.method_15264((JsonObject)obj, (String)"impact_particles")) {
            JsonArray arr = class_3518.method_15261((JsonObject)obj, (String)"impact_particles");
            for (JsonElement el : arr) {
                String particle = el.getAsString();
                class_2394 options = class_2223.method_9418((StringReader)new StringReader(particle), (class_7225)class_7923.field_41180.method_46771());
                impactParticles.add(options);
            }
        } else {
            throw new JsonSyntaxException("Impact particles should either be specified as string \"impact_particle\" or string array \"impact_particles\"");
        }
        ArrayList<class_2394> deflectParticles = new ArrayList<class_2394>();
        if (class_3518.method_15289((JsonObject)obj, (String)"deflect_particle")) {
            String particle = class_3518.method_15265((JsonObject)obj, (String)"deflect_particle");
            Iterator options = class_2223.method_9418((StringReader)new StringReader(particle), (class_7225)class_7923.field_41180.method_46771());
            deflectParticles.add((class_2394)options);
        } else if (class_3518.method_15264((JsonObject)obj, (String)"deflect_particles")) {
            JsonArray arr = class_3518.method_15261((JsonObject)obj, (String)"deflect_particles");
            for (JsonElement el : arr) {
                String particle = el.getAsString();
                class_2394 options = class_2223.method_9418((StringReader)new StringReader(particle), (class_7225)class_7923.field_41180.method_46771());
                deflectParticles.add(options);
            }
        } else {
            throw new JsonSyntaxException("Deflect particles should either be specified as string \"deflect_particle\" or string array \"deflect_particles\"");
        }
        HitSound impactSound = HitSound.fromJson(obj.getAsJsonObject("impact_sound"));
        HitSound deflectSound = HitSound.fromJson(obj.getAsJsonObject("deflect_sound"));
        return new BlockHitEffect(impactParticles, deflectParticles, impactSound, deflectSound);
    }

    public void playEffect(class_1937 level, boolean deflect, boolean forceDisplay, double x, double y, double z, double dx, double dy, double dz, class_1299<?> entityType, class_2680 blockState, ProjectileHitEffect projectileEffect) {
        List<class_2394> particles = deflect ? this.deflectParticles : this.impactParticles;
        for (class_2394 option : particles) {
            option = ProjectileParticleEffectModifiers.applyEffects(option, entityType, blockState, projectileEffect);
            level.method_8466(option, forceDisplay, x, y, z, dx, dy, dz);
        }
        HitSound sound = deflect ? this.deflectSound : this.impactSound;
        sound.playSound(level, x, y, z, dx, dy, dz, projectileEffect);
    }

    public record HitSound(class_2960 location, class_3419 source, float basePitch, float pitchVariation) {
        public static HitSound fromJson(JsonObject obj) throws JsonParseException {
            class_2960 id = CBCUtils.location(class_3518.method_15265((JsonObject)obj, (String)"sound"));
            String sourceName = class_3518.method_15253((JsonObject)obj, (String)"source", (String)class_3419.field_15245.method_14840());
            class_3419 source = CBCUtils.soundSourceFromName(sourceName);
            if (source == null) {
                String types = "'" + String.join((CharSequence)"', '", CBCUtils.getSoundSourceNames()) + "'";
                throw new JsonParseException("Invalid sound type '" + sourceName + "', should either be absent or one of " + types);
            }
            float pitch = class_3518.method_15277((JsonObject)obj, (String)"pitch", (float)1.0f);
            float pitchVariation = class_3518.method_15277((JsonObject)obj, (String)"pitch_variation", (float)0.0f);
            return new HitSound(id, source, pitch, pitchVariation);
        }

        public void playSound(class_1937 level, double x, double y, double z, double dx, double dy, double dz, ProjectileHitEffect projectileEffect) {
            EnvExecute.executeOnClient(() -> () -> CBCClientCommon.playCustomSound(this, level, x, y, z, dx, dy, dz, projectileEffect));
        }
    }
}

