/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.retrofit;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.resource.entity.luminance.CreeperLuminance;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={DynamicLightHandler.class}, remap=false)
public interface DynamicLightHandlerMixin {
    @Overwrite(remap=false)
    @NotNull
    public static <T extends class_1309> DynamicLightHandler<T> makeLivingEntityHandler(@NotNull DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = LambDynLights.getLivingEntityLuminanceFromItems(entity);
            return Math.max(luminance, handler.getLuminance(entity));
        };
    }

    @Overwrite(remap=false)
    @NotNull
    public static <T extends class_1548> DynamicLightHandler<T> makeCreeperEntityHandler(@Nullable DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = CreeperLuminance.INSTANCE.getLuminance(LambDynLights.get().itemLightSourceManager(), (class_1297)entity);
            if (handler != null) {
                luminance = Math.max(luminance, handler.getLuminance(entity));
            }
            return luminance;
        };
    }
}

