/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.entity;

import com.ordana.spelunkery.blocks.nephrite.CarvedNephriteBlock;
import com.ordana.spelunkery.reg.ModEntities;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class CarvedNephriteBlockEntity
extends class_2586 {
    private int charge = 0;
    private int tickCounter = 0;
    private int maxCharge = 100;

    public CarvedNephriteBlockEntity(class_2338 pos, class_2680 state) {
        super(ModEntities.NEPHRITE_TILE.get(), pos, state);
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public int getCharge() {
        return this.charge;
    }

    public int setCharge(int newCharge) {
        this.charge = newCharge;
        return this.charge;
    }

    public static void runFlow(class_1937 level, class_2338 pos, class_2680 state, CarvedNephriteBlockEntity selfTile) {
        CarvedNephriteBlockEntity block2;
        class_2586 class_25862;
        int selfCharge = selfTile.getCharge();
        boolean numOfNeighbors = true;
        int i = 0;
        class_2338 bottomBlock = null;
        while (bottomBlock == null) {
            CarvedNephriteBlockEntity nephrite;
            if (!(level.method_8321(pos.method_10087(i + 1)) instanceof CarvedNephriteBlockEntity) || (class_25862 = level.method_8321(pos.method_10087(i + 1))) instanceof CarvedNephriteBlockEntity && (nephrite = (CarvedNephriteBlockEntity)class_25862).getCharge() >= 100) {
                bottomBlock = pos.method_10087(i);
            }
            ++i;
        }
        if (!bottomBlock.equals((Object)pos) && (class_25862 = level.method_8321(bottomBlock)) instanceof CarvedNephriteBlockEntity) {
            CarvedNephriteBlockEntity belowTile = (CarvedNephriteBlockEntity)class_25862;
            int belowCharge = belowTile.getCharge();
            if (selfCharge + belowCharge <= 100) {
                belowTile.setCharge(belowCharge + selfCharge);
                selfTile.setCharge(0);
            } else {
                selfTile.setCharge(selfCharge - (100 - belowCharge));
                belowTile.setCharge(100);
            }
        }
        int sumOfCharge = selfCharge = selfTile.getCharge();
        ArrayList<CarvedNephriteBlockEntity> neighbors = new ArrayList<CarvedNephriteBlockEntity>();
        for (Object direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093((class_2350)direction);
            class_2586 class_25863 = level.method_8321(neighborPos);
            if (!(class_25863 instanceof CarvedNephriteBlockEntity)) continue;
            CarvedNephriteBlockEntity neighborTile = (CarvedNephriteBlockEntity)class_25863;
            neighbors.add(neighborTile);
            sumOfCharge += neighborTile.getCharge();
        }
        boolean remainderGiven = false;
        Collections.shuffle(neighbors);
        for (CarvedNephriteBlockEntity block2 : neighbors) {
            if (!remainderGiven && level.field_9229.method_43048(neighbors.size() + 1) == 0) {
                block2.setCharge(sumOfCharge / (neighbors.size() + 1) + sumOfCharge % (neighbors.size() + 1));
                remainderGiven = true;
                continue;
            }
            block2.setCharge(sumOfCharge / (neighbors.size() + 1));
        }
        if (remainderGiven) {
            selfTile.setCharge(sumOfCharge / (neighbors.size() + 1));
        } else {
            selfTile.setCharge(sumOfCharge / (neighbors.size() + 1) + sumOfCharge % (neighbors.size() + 1));
        }
        selfCharge = selfTile.getCharge();
        if (!bottomBlock.equals((Object)pos) && (block2 = level.method_8321(bottomBlock)) instanceof CarvedNephriteBlockEntity) {
            CarvedNephriteBlockEntity bottomTile = block2;
            int belowCharge = bottomTile.getCharge();
            if (selfCharge + belowCharge <= 100) {
                bottomTile.setCharge(belowCharge + selfCharge);
                selfTile.setCharge(0);
            } else {
                selfTile.setCharge(selfCharge - (100 - belowCharge));
                bottomTile.setCharge(100);
            }
        }
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10545("Charge")) {
            this.setCharge(tag.method_10550("Charge"));
        }
    }

    protected void method_11007(class_2487 tag) {
        tag.method_10569("Charge", this.getCharge());
        super.method_11007(tag);
    }

    public static void tickBlock(class_1937 level, class_2338 pos, class_2680 state, CarvedNephriteBlockEntity selfTile) {
        ++selfTile.tickCounter;
        if (!level.field_9236 && selfTile.tickCounter == 5) {
            CarvedNephriteBlockEntity.runFlow(level, pos, state, selfTile);
            selfTile.setTickCounter(0);
        }
        if (selfTile.getCharge() == 0) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.EMPTY)));
        } else if (selfTile.getCharge() > 0 && selfTile.getCharge() <= 20) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.ONE_TO_TWENTY)));
        } else if (selfTile.getCharge() > 20 && selfTile.getCharge() <= 40) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.TWENTYONE_TO_FOURTY)));
        } else if (selfTile.getCharge() > 40 && selfTile.getCharge() <= 60) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.FOURTYONE_TO_SIXTY)));
        } else if (selfTile.getCharge() > 60 && selfTile.getCharge() <= 80) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.SIXTYONE_TO_EIGHTY)));
        } else if (selfTile.getCharge() > 80 && selfTile.getCharge() <= 99) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.EIGHTYONE_TO_NINETYNINE)));
        } else if (selfTile.getCharge() == 100) {
            level.method_8501(pos, (class_2680)state.method_11657(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.FULL)));
        }
    }
}

