/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderShader;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.Fov;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class Viewfinder {
    public static final float ZOOM_STEP = 8.0f;
    public static final float ZOOM_PRECISE_MODIFIER = 0.25f;
    private static boolean isOpen;
    private static FocalRange focalRange;
    private static double targetFov;
    private static double currentFov;
    private static boolean shouldRestoreFov;

    public static boolean isOpen() {
        return isOpen;
    }

    public static boolean isLookingThrough() {
        return Viewfinder.isOpen() && (class_310.method_1551().field_1690.method_31044() == class_5498.field_26664 || class_310.method_1551().field_1690.method_31044() == class_5498.field_26666);
    }

    public static void open() {
        class_746 player = class_310.method_1551().field_1724;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player should not be null");
        Preconditions.checkState((boolean)player.method_37908().method_8608(), (Object)"This should be called only client-side.");
        if (Viewfinder.isOpen()) {
            return;
        }
        Camera<?> camera = Camera.getCamera((class_1657)player).orElseThrow();
        CameraItem cameraItem = (CameraItem)((Object)camera.get().getItem());
        class_1799 cameraStack = camera.get().getStack();
        focalRange = cameraItem.getFocalRange(cameraStack);
        targetFov = Fov.focalLengthToFov(class_3532.method_15363((float)cameraItem.getFocalLength(cameraStack), (float)focalRange.min(), (float)focalRange.max()));
        isOpen = true;
        ViewfinderShader.setPrevious(ViewfinderShader.getCurrent().orElse(null));
        ViewfinderShader.update();
        ViewfinderOverlay.setup();
    }

    public static void update() {
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Viewfinder.updateSelfieMode();
        ViewfinderShader.update();
    }

    public static void updateSelfieMode() {
        boolean inSelfieMode = class_310.method_1551().field_1690.method_31044() == class_5498.field_26666;
        CameraClient.setSelfieMode(inSelfieMode);
    }

    public static void close() {
        if (!Viewfinder.isOpen()) {
            return;
        }
        isOpen = false;
        targetFov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
        ViewfinderShader.removeShader();
        ViewfinderShader.restorePrevious();
    }

    public static FocalRange getFocalRange() {
        return focalRange;
    }

    public static double getCurrentFov() {
        return currentFov;
    }

    public static float getSelfieCameraDistance() {
        return 1.75f;
    }

    public static void zoom(ZoomDirection direction, boolean precise) {
        double fov;
        double prevFov;
        double step = 8.0 * (1.0 - class_3532.method_15350((double)(((double)focalRange.min() - currentFov) / (double)focalRange.min()), (double)0.3f, (double)1.0));
        double inertia = Math.abs(targetFov - currentFov) * (double)0.8f;
        double change = step + inertia;
        if (precise) {
            change *= 0.25;
        }
        if (Math.abs((prevFov = targetFov) - (fov = class_3532.method_15350((double)(targetFov + (direction == ZoomDirection.IN ? -change : change)), (double)Fov.focalLengthToFov(focalRange.max()), (double)Fov.focalLengthToFov(focalRange.min())))) > (double)0.01f) {
            Objects.requireNonNull(class_310.method_1551().field_1724).method_43077(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
        }
        targetFov = fov;
        CameraClient.setZoom(Fov.fovToFocalLength(fov));
    }

    public static double modifyMouseSensitivity(double sensitivity) {
        if (!Viewfinder.isLookingThrough()) {
            return sensitivity;
        }
        double modifier = class_3532.method_15350((double)(1.0 - (Double)Config.Client.VIEWFINDER_ZOOM_SENSITIVITY_MODIFIER.get() * (((double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() - currentFov) / 5.0)), (double)0.01, (double)2.0);
        return sensitivity * modifier;
    }

    public static boolean handleMouseScroll(ZoomDirection direction) {
        if (Viewfinder.isLookingThrough()) {
            Viewfinder.zoom(direction, false);
            return true;
        }
        return false;
    }

    public static double modifyFov(double fov) {
        if (Viewfinder.isLookingThrough()) {
            currentFov = class_3532.method_16436((double)Math.min(0.8f * class_310.method_1551().method_1534(), 0.8f), (double)currentFov, (double)targetFov);
            shouldRestoreFov = true;
            return currentFov;
        }
        if (shouldRestoreFov && Math.abs(currentFov - fov) > 1.0E-5) {
            currentFov = class_3532.method_16436((double)Math.min(0.95f * class_310.method_1551().method_1534(), 0.95f), (double)currentFov, (double)fov);
            return currentFov;
        }
        currentFov = fov;
        shouldRestoreFov = false;
        return fov;
    }

    static {
        focalRange = new FocalRange(18, 55);
        currentFov = targetFov = 90.0;
    }
}

