/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.mixin.accessor.DrawContextAccessor;
import dev.emi.emi.mixin.accessor.OrderedTextTooltipComponentAccessor;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.screen.EmiScreenManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class EmiRenderHelper {
    public static final DecimalFormat TEXT_FORMAT = new DecimalFormat("#,###.##");
    public static final class_2561 EMPTY_TEXT = EmiPort.literal("");
    public static final class_310 CLIENT = class_310.method_1551();
    public static final class_2960 WIDGETS = EmiPort.id("emi", "textures/gui/widgets.png");
    public static final class_2960 BUTTONS = EmiPort.id("emi", "textures/gui/buttons.png");
    public static final class_2960 BACKGROUND = EmiPort.id("emi", "textures/gui/background.png");
    public static final class_2960 GRID = EmiPort.id("emi", "textures/gui/grid.png");
    public static final class_2960 DASH = EmiPort.id("emi", "textures/gui/dash.png");
    public static final class_2960 CONFIG = EmiPort.id("emi", "textures/gui/config.png");
    public static final class_2960 PIECES = EmiPort.id("emi", "textures/gui/pieces.png");

    public static void drawNinePatch(EmiDrawContext context, class_2960 texture, int x, int y, int w, int h, int u, int v, int cornerLength, int centerLength) {
        int cor = cornerLength;
        int cen = centerLength;
        int corcen = cor + cen;
        int innerWidth = w - cornerLength * 2;
        int innerHeight = h - cornerLength * 2;
        int coriw = cor + innerWidth;
        int corih = cor + innerHeight;
        context.drawTexture(texture, x, y, cor, cor, u, v, cor, cor, 256, 256);
        context.drawTexture(texture, x + cor, y, innerWidth, cor, u + cor, v, cen, cor, 256, 256);
        context.drawTexture(texture, x + coriw, y, cor, cor, u + corcen, v, cor, cor, 256, 256);
        context.drawTexture(texture, x, y + cor, cor, innerHeight, u, v + cor, cor, cen, 256, 256);
        context.drawTexture(texture, x + cor, y + cor, innerWidth, innerHeight, u + cor, v + cor, cen, cen, 256, 256);
        context.drawTexture(texture, x + coriw, y + cor, cor, innerHeight, u + corcen, v + cor, cor, cen, 256, 256);
        context.drawTexture(texture, x, y + corih, cor, cor, u, v + corcen, cor, cor, 256, 256);
        context.drawTexture(texture, x + cor, y + corih, innerWidth, cor, u + cor, v + corcen, cen, cor, 256, 256);
        context.drawTexture(texture, x + coriw, y + corih, cor, cor, u + corcen, v + corcen, cor, cor, 256, 256);
    }

    public static void drawTintedSprite(class_4587 matrices, class_1058 sprite, int color, int x, int y, int xOff, int yOff, int width, int height) {
        if (sprite == null) {
            return;
        }
        EmiPort.setPositionColorTexShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        RenderSystem.enableBlend();
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        float xMin = x;
        float yMin = y;
        float xMax = xMin + (float)width;
        float yMax = yMin + (float)height;
        float uSpan = sprite.method_4577() - sprite.method_4594();
        float vSpan = sprite.method_4575() - sprite.method_4593();
        float uMin = sprite.method_4594() + uSpan / 16.0f * (float)xOff;
        float vMin = sprite.method_4593() + vSpan / 16.0f * (float)yOff;
        float uMax = sprite.method_4577() - uSpan / 16.0f * (float)(16 - (width + xOff));
        float vMax = sprite.method_4575() - vSpan / 16.0f * (float)(16 - (height + yOff));
        Matrix4f model = matrices.method_23760().method_23761();
        bufferBuilder.method_22918(model, xMin, yMax, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(model, xMax, yMax, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(model, xMax, yMin, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(model, xMin, yMin, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMin, vMin).method_1344();
        EmiPort.draw(bufferBuilder);
    }

    public static void drawScroll(EmiDrawContext context, int x, int y, int width, int height, int progress, int total, int color) {
        if (total <= 1) {
            return;
        }
        int start = x + width * progress / total;
        int end = start + Math.max(width / total, 1);
        if (progress == total - 1) {
            end = x + width;
            start = end - Math.max(width / total, 1);
        }
        context.fill(start, y, end - start, height, color);
    }

    public static class_2561 getEmiText() {
        return EmiPort.append(EmiPort.append(EmiPort.literal("E", class_2583.field_24360.method_36139(15432700)), (class_2561)EmiPort.literal("M", class_2583.field_24360.method_36139(8125602))), (class_2561)EmiPort.literal("I", class_2583.field_24360.method_36139(8121340)));
    }

    public static class_2561 getPageText(int page, int total, int maxWidth) {
        class_5250 text = EmiPort.translatable("emi.page", page, total);
        if (EmiRenderHelper.CLIENT.field_1772.method_27525((class_5348)text) > maxWidth && EmiRenderHelper.CLIENT.field_1772.method_27525((class_5348)(text = EmiPort.translatable("emi.page.short", page, total))) > maxWidth && EmiRenderHelper.CLIENT.field_1772.method_27525((class_5348)(text = EmiPort.literal("" + page))) > maxWidth) {
            text = EmiPort.literal("");
        }
        return text;
    }

    public static void drawLeftTooltip(class_437 screen, EmiDrawContext context, List<class_5684> components, int x, int y) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, screen.field_22789 / 2 - 16, (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> {
            Vector2i pos = new Vector2i(mouseX, mouseY).add(12, -12);
            pos.x = Math.max(pos.x - 24 - tooltipWidth, 4);
            if (pos.y + tooltipHeight + 3 > screenHeight) {
                pos.y = screenHeight - tooltipHeight - 3;
            }
            return pos;
        });
    }

    public static void drawTooltip(class_437 screen, EmiDrawContext context, List<class_5684> components, int x, int y) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, screen.field_22789 / 2 - 16);
    }

    public static void drawTooltip(class_437 screen, EmiDrawContext context, List<class_5684> components, int x, int y, int maxWidth) {
        EmiRenderHelper.drawTooltip(screen, context, components, x, y, maxWidth, class_8001.field_41687);
    }

    public static void drawTooltip(class_437 screen, EmiDrawContext context, List<class_5684> components, int x, int y, int maxWidth, class_8000 positioner) {
        if (components.isEmpty()) {
            return;
        }
        y = Math.max(16, y);
        ArrayList mutable = Lists.newArrayList();
        int wrapWidth = Math.max(components.stream().map(c -> c instanceof class_5683 ? 0 : c.method_32664(EmiRenderHelper.CLIENT.field_1772)).max(Integer::compare).orElse(0), maxWidth);
        for (class_5684 comp : components) {
            class_5683 ottc;
            if (comp instanceof class_5683 && (ottc = (class_5683)comp).method_32664(EmiRenderHelper.CLIENT.field_1772) > wrapWidth) {
                try {
                    class_5481 ordered = ((OrderedTextTooltipComponentAccessor)ottc).getText();
                    class_5250 text = class_2561.method_43473();
                    ordered.accept((var1, style, codepoint) -> {
                        text.method_10852((class_2561)EmiPort.literal(String.valueOf(Character.toChars(codepoint)), style));
                        return true;
                    });
                    for (class_5481 o : EmiRenderHelper.CLIENT.field_1772.method_1728((class_5348)text, wrapWidth)) {
                        mutable.add(class_5684.method_32662((class_5481)o));
                    }
                    continue;
                }
                catch (Exception e) {
                    EmiLog.error("Error converting text", e);
                    mutable.add(comp);
                    continue;
                }
            }
            mutable.add(comp);
        }
        RenderSystem.enableDepthTest();
        EmiPort.setPositionTexShader();
        context.resetColor();
        ((DrawContextAccessor)context.raw()).invokeDrawTooltip(EmiRenderHelper.CLIENT.field_1772, mutable, x, y, positioner);
    }

    public static void drawSlotHightlight(EmiDrawContext context, int x, int y, int w, int h, int z) {
        context.push();
        context.matrices().method_46416(0.0f, 0.0f, (float)z);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        context.fill(x, y, w, h, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        context.pop();
    }

    public static class_2561 getAmountText(EmiIngredient stack) {
        return EmiRenderHelper.getAmountText(stack, stack.getAmount());
    }

    public static class_2561 getAmountText(EmiIngredient stack, long amount) {
        if (stack.isEmpty() || amount == 0L) {
            return EMPTY_TEXT;
        }
        if (stack.getEmiStacks().get(0).getKey() instanceof class_3611) {
            return EmiRenderHelper.getFluidAmount(amount);
        }
        return EmiPort.literal(TEXT_FORMAT.format(amount));
    }

    public static class_2561 getAmountText(EmiIngredient stack, double amount) {
        if (stack.isEmpty() || amount == 0.0) {
            return EMPTY_TEXT;
        }
        if (stack.getEmiStacks().get(0).getKey() instanceof class_3611) {
            return EmiConfig.fluidUnit.translate(amount);
        }
        return EmiPort.literal(TEXT_FORMAT.format(amount));
    }

    public static class_2561 getFluidAmount(long amount) {
        return EmiConfig.fluidUnit.translate(amount);
    }

    public static int getAmountOverflow(class_2561 amount) {
        int width = EmiRenderHelper.CLIENT.field_1772.method_27525((class_5348)amount);
        if (width > 14) {
            return width - 14;
        }
        return 0;
    }

    public static void renderAmount(EmiDrawContext context, int x, int y, class_2561 amount) {
        context.push();
        context.matrices().method_46416(0.0f, 0.0f, 200.0f);
        int tx = x + 17 - Math.min(14, EmiRenderHelper.CLIENT.field_1772.method_27525((class_5348)amount));
        context.drawTextWithShadow(amount, tx, y + 9, -1);
        context.pop();
    }

    public static void renderIngredient(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        RenderSystem.enableDepthTest();
        context.push();
        context.matrices().method_46416(0.0f, 0.0f, 200.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS);
        context.drawTexture(WIDGETS, x, y, 8, 252, 4, 4);
        context.pop();
    }

    public static void renderTag(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        if (ingredient.getEmiStacks().size() > 1) {
            RenderSystem.enableDepthTest();
            context.push();
            context.matrices().method_46416(0.0f, 0.0f, 200.0f);
            context.drawTexture(WIDGETS, x, y + 12, 0, 252, 4, 4);
            context.pop();
        }
    }

    public static void renderRemainder(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        for (EmiStack stack : ingredient.getEmiStacks()) {
            EmiStack remainder = stack.getRemainder();
            if (remainder.isEmpty()) continue;
            if (remainder.equals(ingredient)) {
                EmiRenderHelper.renderCatalyst(ingredient, context, x, y);
            } else {
                context.push();
                context.matrices().method_46416(0.0f, 0.0f, 200.0f);
                RenderSystem.enableDepthTest();
                context.drawTexture(WIDGETS, x + 12, y, 4, 252, 4, 4);
                context.pop();
            }
            return;
        }
    }

    public static void renderCatalyst(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        RenderSystem.enableDepthTest();
        context.push();
        context.matrices().method_46416(0.0f, 0.0f, 200.0f);
        context.drawTexture(WIDGETS, x + 12, y, 12, 252, 4, 4);
        context.pop();
    }

    public static void renderRecipeFavorite(EmiIngredient ingredient, EmiDrawContext context, int x, int y) {
        context.push();
        context.matrices().method_46416(0.0f, 0.0f, 200.0f);
        RenderSystem.enableDepthTest();
        context.drawTexture(WIDGETS, x + 12, y, 16, 252, 4, 4);
        context.pop();
    }

    public static void renderRecipeBackground(EmiRecipe recipe, EmiDrawContext context, int x, int y) {
        context.resetColor();
        EmiRenderHelper.drawNinePatch(context, BACKGROUND, x, y, recipe.getDisplayWidth() + 8, recipe.getDisplayHeight() + 8, 27, 0, 4, 1);
    }

    public static void renderRecipe(final EmiRecipe recipe, EmiDrawContext context, int x, int y, boolean showMissing, int overlayColor) {
        try {
            EmiRenderHelper.renderRecipeBackground(recipe, context, x, y);
            final ArrayList widgets = Lists.newArrayList();
            WidgetHolder holder = new WidgetHolder(){

                @Override
                public int getWidth() {
                    return recipe.getDisplayWidth();
                }

                @Override
                public int getHeight() {
                    return recipe.getDisplayHeight();
                }

                @Override
                public <T extends Widget> T add(T widget) {
                    widgets.add(widget);
                    return widget;
                }
            };
            context.push();
            context.matrices().method_46416((float)(x + 4), (float)(y + 4), 0.0f);
            recipe.addWidgets(holder);
            float delta = class_310.method_1551().method_1488();
            for (Widget widget : widgets) {
                widget.method_25394(context.raw(), -1000, -1000, delta);
            }
            if (overlayColor != -1) {
                context.fill(-1, -1, recipe.getDisplayWidth() + 2, recipe.getDisplayHeight() + 2, overlayColor);
            }
            if (showMissing) {
                class_465<?> hs = EmiApi.getHandledScreen();
                EmiRecipeHandler<?> handler = EmiRecipeFiller.getFirstValidHandler(recipe, hs);
                if (handler != null) {
                    handler.render(recipe, new EmiCraftContext(hs, handler.getInventory(hs), EmiCraftContext.Type.FILL_BUTTON), widgets, context.raw());
                } else if (EmiScreenManager.lastPlayerInventory != null) {
                    StandardRecipeHandler.renderMissing(recipe, EmiScreenManager.lastPlayerInventory, widgets, context.raw());
                }
            }
            context.pop();
            RenderSystem.disableBlend();
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            RenderSystem.disableDepthTest();
            EmiRenderHelper.renderRecipeBackground(recipe, context, x, y);
            RenderSystem.enableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (Throwable e) {
            EmiLog.error("Error rendering recipe", e);
        }
    }
}

