/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.bom.ChanceMaterialCost;
import dev.emi.emi.bom.FlatMaterialCost;
import dev.emi.emi.bom.MaterialTree;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;

public class RecipeCostTooltipComponent
implements EmiTooltipComponent {
    private static final class_2561 COST = EmiPort.translatable("emi.cost_per");
    private final List<Node> nodes = Lists.newArrayList();
    public final MaterialTree tree;
    private int maxWidth = 0;

    public RecipeCostTooltipComponent(EmiRecipe recipe) {
        this.tree = new MaterialTree(recipe);
        this.tree.batches = this.tree.cost.getIdealBatch(this.tree.goal, 1L, 1L);
        this.tree.calculateCost();
        this.addNodes();
    }

    public boolean shouldDisplay() {
        return !this.nodes.isEmpty();
    }

    public void addNodes() {
        double batches = this.tree.batches;
        List<ChanceMaterialCost> costs = Stream.concat(this.tree.cost.costs.values().stream(), this.tree.cost.chanceCosts.values().stream()).sorted((a, b) -> Integer.compare(EmiStackList.getIndex(a.ingredient.getEmiStacks().get(0)), EmiStackList.getIndex(b.ingredient.getEmiStacks().get(0)))).toList();
        for (FlatMaterialCost flatMaterialCost : costs) {
            if (flatMaterialCost instanceof ChanceMaterialCost) {
                ChanceMaterialCost cmc = (ChanceMaterialCost)flatMaterialCost;
                this.nodes.add(new Node(flatMaterialCost.ingredient, (double)flatMaterialCost.amount / batches * (double)cmc.chance, true));
                continue;
            }
            this.nodes.add(new Node(flatMaterialCost.ingredient, (double)flatMaterialCost.amount / batches, false));
        }
        this.positionNodes();
    }

    public void positionNodes() {
        int wrapWidth = this.getWrapWidth();
        int padding = 8;
        int x = 0;
        int y = 10;
        this.maxWidth = 0;
        for (Node node : this.nodes) {
            int width = 16 + EmiRenderHelper.getAmountOverflow(node.text);
            if (x + width > wrapWidth) {
                x = 0;
                y += 18;
            }
            this.maxWidth = Math.max(this.maxWidth, x + width);
            node.x = x;
            node.y = y;
            x += width + padding;
        }
    }

    public int getWrapWidth() {
        return 160;
    }

    public int method_32661() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get((int)(this.nodes.size() - 1)).y + 18;
        }
        return 10;
    }

    public int method_32664(class_327 textRenderer) {
        return Math.max(textRenderer.method_27525((class_5348)COST), this.maxWidth);
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData render) {
        for (Node node : this.nodes) {
            context.drawStack(node.stack, node.x, node.y);
            EmiRenderHelper.renderAmount(context, node.x, node.y, node.text);
        }
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        text.draw(COST, 0, 0, (int)class_124.field_1080.method_532(), true);
    }

    private static class Node {
        public final EmiIngredient stack;
        public final class_2561 text;
        public int x;
        public int y;

        public Node(EmiIngredient stack, double amount, boolean chanced) {
            this.stack = stack;
            this.text = chanced ? EmiPort.append(EmiPort.literal("\u2248"), EmiRenderHelper.getAmountText(stack, amount)).method_27692(class_124.field_1065) : EmiRenderHelper.getAmountText(stack, amount);
        }
    }
}

