/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.orientation;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.RelativeSide;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4590;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public enum BlockOrientation {
    DOWN_NORTH(90, 0, 0, 0),
    DOWN_WEST(90, 0, 270, 1),
    DOWN_SOUTH(90, 0, 180, 2),
    DOWN_EAST(90, 0, 90, 3),
    UP_NORTH(270, 0, 180, 0),
    UP_EAST(270, 0, 90, 1),
    UP_SOUTH(270, 0, 0, 2),
    UP_WEST(270, 0, 270, 3),
    NORTH_UP(0, 0, 0, 0),
    NORTH_WEST(0, 0, 270, 1),
    NORTH_DOWN(0, 0, 180, 2),
    NORTH_EAST(0, 0, 90, 3),
    SOUTH_UP(0, 180, 0, 0),
    SOUTH_EAST(0, 180, 90, 1),
    SOUTH_DOWN(0, 180, 180, 2),
    SOUTH_WEST(0, 180, 270, 3),
    WEST_UP(0, 270, 0, 0),
    WEST_SOUTH(0, 270, 270, 1),
    WEST_DOWN(0, 270, 180, 2),
    WEST_NORTH(0, 270, 90, 3),
    EAST_UP(0, 90, 0, 0),
    EAST_NORTH(0, 90, 270, 1),
    EAST_DOWN(0, 90, 180, 2),
    EAST_SOUTH(0, 90, 90, 3);

    private final int angleX;
    private final int angleY;
    private final int angleZ;
    private final Quaternionf quaternion;
    private final class_4590 transformation;
    private final int spin;
    private final class_2350[] rotatedSideTo;
    private final class_2350[] rotatedSideFrom;

    private BlockOrientation(int angleX, int angleY, int angleZ, int spin) {
        this.angleX = angleX;
        this.angleY = angleY;
        this.angleZ = angleZ;
        this.quaternion = new Quaternionf().rotateYXZ((float)(-angleY) * ((float)Math.PI / 180), (float)(-angleX) * ((float)Math.PI / 180), (float)(-angleZ) * ((float)Math.PI / 180));
        if (angleX == 0 && angleY == 0 && angleZ == 0) {
            this.transformation = class_4590.method_22931();
        } else {
            Matrix4f rotationMatrix = new Matrix4f().identity().rotate((Quaternionfc)this.quaternion);
            this.transformation = new class_4590(rotationMatrix);
        }
        this.spin = spin;
        this.rotatedSideTo = new class_2350[class_2350.values().length];
        this.rotatedSideFrom = new class_2350[class_2350.values().length];
        for (class_2350 direction : class_2350.values()) {
            class_2350 rotatedTo;
            Vector3f normal = direction.method_23955();
            normal.rotate((Quaternionfc)this.quaternion);
            this.rotatedSideTo[direction.ordinal()] = rotatedTo = class_2350.method_10147((float)normal.x(), (float)normal.y(), (float)normal.z());
            this.rotatedSideFrom[rotatedTo.ordinal()] = direction;
        }
    }

    public void setOn(class_2586 be) {
        this.setOn(be.method_10997(), be.method_11016());
    }

    public void setOn(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        IOrientationStrategy strategy = IOrientationStrategy.get(state);
        class_2680 newState = strategy.setOrientation(state, this.getSide(RelativeSide.FRONT), this.getSpin());
        if (newState != state) {
            level.method_8501(pos, newState);
        }
    }

    public boolean isRedundant() {
        return this.angleX == 0 && this.angleY == 0 && this.angleZ == 0;
    }

    public Quaternionf getQuaternion() {
        return this.quaternion;
    }

    public class_4590 getTransformation() {
        return this.transformation;
    }

    public class_2350 rotate(class_2350 facing) {
        return this.rotatedSideTo[facing.ordinal()];
    }

    public class_2350 resultingRotate(class_2350 facing) {
        return this.rotatedSideFrom[facing.ordinal()];
    }

    public int getAngleX() {
        return this.angleX;
    }

    public int getAngleY() {
        return this.angleY;
    }

    public int getAngleZ() {
        return this.angleZ;
    }

    public int getSpin() {
        return this.spin;
    }

    public static BlockOrientation get(class_2350 facing) {
        return BlockOrientation.get(facing, 0);
    }

    public static BlockOrientation get(class_2350 front, class_2350 top) {
        int offset;
        for (int i = offset = front.ordinal() * 4; i < offset + 4; ++i) {
            BlockOrientation orientation = BlockOrientation.values()[i];
            if (orientation.getSide(RelativeSide.TOP) != top) continue;
            return orientation;
        }
        return BlockOrientation.values()[offset];
    }

    public static BlockOrientation get(class_2350 facing, int spin) {
        return BlockOrientation.values()[facing.ordinal() * 4 + spin];
    }

    public static BlockOrientation get(class_2586 blockEntity) {
        class_2680 blockState = blockEntity.method_11010();
        return BlockOrientation.get(blockState);
    }

    public static BlockOrientation get(class_2680 state) {
        IOrientationStrategy strategy = IOrientationStrategy.get(state);
        return BlockOrientation.get(strategy, state);
    }

    public static BlockOrientation get(IOrientationStrategy strategy, class_2680 state) {
        class_2350 facing = strategy.getFacing(state);
        int spin = strategy.getSpin(state);
        return BlockOrientation.get(facing, spin);
    }

    public class_2350 getSide(RelativeSide side) {
        return this.rotate(side.getUnrotatedSide());
    }

    public RelativeSide getRelativeSide(class_2350 side) {
        return RelativeSide.fromUnrotatedSide(this.resultingRotate(side));
    }

    public Set<class_2350> getSides(Set<RelativeSide> relativeSides) {
        EnumSet<class_2350> result = EnumSet.noneOf(class_2350.class);
        for (RelativeSide relativeSide : relativeSides) {
            result.add(this.getSide(relativeSide));
        }
        return result;
    }

    public Set<RelativeSide> getRelativeSides(Set<class_2350> sides) {
        EnumSet<RelativeSide> result = EnumSet.noneOf(RelativeSide.class);
        for (class_2350 side : sides) {
            result.add(this.getRelativeSide(side));
        }
        return result;
    }

    public BlockOrientation rotateClockwiseAround(class_2350 side) {
        return this.rotateClockwiseAround(side.method_10166(), side.method_10171());
    }

    public BlockOrientation rotateClockwiseAround(class_2350.class_2351 axis, class_2350.class_2352 direction) {
        class_2350 newUp;
        class_2350 newFacing;
        class_2350 facing = this.getSide(RelativeSide.FRONT);
        class_2350 up = this.getSide(RelativeSide.TOP);
        if (direction == class_2350.class_2352.field_11056) {
            newFacing = facing.method_35833(axis);
            newUp = up.method_35833(axis);
        } else {
            newFacing = facing.method_35834(axis);
            newUp = up.method_35834(axis);
        }
        return BlockOrientation.get(newFacing, newUp);
    }
}

