/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumCompat {
    private static final Logger LOGGER;
    @Nullable
    private static final MethodHandle METHOD_HANDLE;

    public static void markSpriteActive(class_1058 sprite) {
        if (sprite != null && METHOD_HANDLE != null) {
            try {
                METHOD_HANDLE.invokeExact(sprite);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to invoke SpriteUtil#markSpriteActive", e);
            }
        }
    }

    static {
        MethodHandle handle;
        block2: {
            LOGGER = LoggerFactory.getLogger(SodiumCompat.class);
            handle = null;
            try {
                handle = MethodHandles.lookup().findStatic(Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil"), "markSpriteActive", MethodType.methodType(Void.TYPE, class_1058.class));
                LOGGER.info("Loaded Sodium active sprite compat.");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                if (!FabricLoader.getInstance().isModLoaded("sodium")) break block2;
                LOGGER.error("Failed to load Sodium active sprite compat.", (Throwable)e);
            }
        }
        METHOD_HANDLE = handle;
    }
}

