/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.export;

import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookLevelRenderer;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.export.InterpolatedSpriteBuilder;
import appeng.client.guidebook.scene.export.Mesh;
import appeng.client.guidebook.scene.export.MeshBuildingBufferSource;
import appeng.client.guidebook.scene.export.RenderTypeIntrospection;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import appeng.flatbuffers.scene.ExpAnimatedTexturePart;
import appeng.flatbuffers.scene.ExpAnimatedTexturePartFrame;
import appeng.flatbuffers.scene.ExpCameraSettings;
import appeng.flatbuffers.scene.ExpMaterial;
import appeng.flatbuffers.scene.ExpMesh;
import appeng.flatbuffers.scene.ExpSampler;
import appeng.flatbuffers.scene.ExpScene;
import appeng.flatbuffers.scene.ExpVertexFormat;
import appeng.flatbuffers.scene.ExpVertexFormatElement;
import appeng.shaded.flatbuffers.FlatBufferBuilder;
import appeng.siteexport.CacheBusting;
import appeng.siteexport.ResourceExporter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_7764;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneExporter {
    private static final Logger LOG = LoggerFactory.getLogger(SceneExporter.class);
    private final ResourceExporter resourceExporter;

    public SceneExporter(ResourceExporter resourceExporter) {
        this.resourceExporter = resourceExporter;
    }

    public static boolean isAnimated(GuidebookScene scene) {
        return SceneExporter.getSprites(scene).stream().anyMatch(sprite -> sprite.method_45851().field_40541 != null);
    }

    private static Set<class_1058> getSprites(GuidebookScene scene) {
        GuidebookLevel level = scene.getLevel();
        MeshBuildingBufferSource bufferSource = new MeshBuildingBufferSource();
        GuidebookLevelRenderer.getInstance().renderContent(level, bufferSource);
        return bufferSource.getMeshes().stream().flatMap(Mesh::getSprites).collect(Collectors.toSet());
    }

    public byte[] export(GuidebookScene scene) {
        GuidebookLevel level = scene.getLevel();
        MeshBuildingBufferSource bufferSource = new MeshBuildingBufferSource();
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f(), (class_8251)class_8251.field_43361);
        GuidebookLevelRenderer.getInstance().renderContent(level, bufferSource);
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        List<Mesh> meshes = bufferSource.getMeshes();
        int animatedTexturesOffset = this.writeAnimations(builder, meshes);
        Map<class_293, Integer> vertexFormats = this.writeVertexFormats(meshes, builder);
        Map<class_1921, Integer> materials = this.writeMaterials(meshes, builder);
        int meshesOffset = this.writeMeshes(meshes, builder, vertexFormats, materials);
        ExpScene.startExpScene(builder);
        ExpScene.addMeshes(builder, meshesOffset);
        int cameraOffset = this.createCameraModel(scene.getCameraSettings(), builder);
        ExpScene.addCamera(builder, cameraOffset);
        ExpScene.addAnimatedTextures(builder, animatedTexturesOffset);
        builder.finish(ExpScene.endExpScene(builder));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(bout);){
            out.write(builder.sizedByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bout.toByteArray();
    }

    private int writeAnimations(FlatBufferBuilder builder, List<Mesh> meshes) {
        int[] animSprites = meshes.stream().flatMap(Mesh::getSprites).filter(s -> s.method_45851().field_40541 != null).distinct().mapToInt(sprite -> this.writeAnimatedTextureSprite(builder, (class_1058)sprite)).toArray();
        return ExpScene.createAnimatedTexturesVector(builder, animSprites);
    }

    private int writeAnimatedTextureSprite(FlatBufferBuilder builder, class_1058 sprite) {
        int framesOffset;
        long frameCount;
        int frameRowSize;
        byte[] image;
        class_7764 contents = sprite.method_45851();
        class_7764.class_5790 animatedTexture = contents.field_40541;
        class_2960 name = contents.method_45816();
        if (animatedTexture.field_40542) {
            InterpolatedSpriteBuilder.InterpolatedResult interpResult = InterpolatedSpriteBuilder.interpolate(contents.field_40539, contents.method_45807(), contents.method_45815(), animatedTexture.field_28473, animatedTexture.field_28472);
            try (class_1011 interpFrames = interpResult.frames();){
                image = interpFrames.method_24036();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            frameRowSize = interpResult.frameRowSize();
            frameCount = interpResult.frameCount();
            ExpAnimatedTexturePart.startFramesVector(builder, interpResult.indices().length);
            for (int frameIndex : interpResult.indices()) {
                ExpAnimatedTexturePartFrame.createExpAnimatedTexturePartFrame(builder, frameIndex, 1);
            }
            framesOffset = builder.endVector();
        } else {
            try {
                image = contents.field_40539.method_24036();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            frameCount = animatedTexture.method_33450().count();
            frameRowSize = animatedTexture.field_28473;
            ExpAnimatedTexturePart.startFramesVector(builder, animatedTexture.field_28472.size());
            for (class_7764.class_5791 frame : animatedTexture.field_28472) {
                ExpAnimatedTexturePartFrame.createExpAnimatedTexturePartFrame(builder, frame.field_28475, frame.field_28476);
            }
            framesOffset = builder.endVector();
        }
        Path path = this.resourceExporter.getOutputFolder().resolve("!anims").resolve(name.method_12836()).resolve(name.method_12832() + ".png");
        try {
            path = CacheBusting.writeAsset(path, image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String relativePath = this.resourceExporter.getPathRelativeFromOutputFolder(path);
        int textureIdOffset = builder.createSharedString(sprite.method_45852().toString());
        int spritePath = builder.createString(relativePath);
        return ExpAnimatedTexturePart.createExpAnimatedTexturePart(builder, textureIdOffset, sprite.method_35806(), sprite.method_35807(), contents.method_45807(), contents.method_45815(), spritePath, frameCount, frameRowSize, framesOffset);
    }

    private Map<class_293, Integer> writeVertexFormats(List<Mesh> meshes, FlatBufferBuilder builder) {
        IdentityHashMap<class_293, Integer> result = new IdentityHashMap<class_293, Integer>();
        for (Mesh mesh : meshes) {
            result.computeIfAbsent(mesh.drawState().comp_749(), format -> this.writeVertexFormat((class_293)format, builder));
        }
        return result;
    }

    private int writeVertexFormat(class_293 format, FlatBufferBuilder builder) {
        int count = (int)format.method_1357().stream().filter(SceneExporter::isRelevant).count();
        ExpVertexFormat.startElementsVector(builder, count);
        ImmutableList elements = format.method_1357();
        for (int i = elements.size() - 1; i >= 0; --i) {
            int offset = 0;
            for (int j = 0; j < i; ++j) {
                offset += ((class_296)elements.get(j)).method_1387();
            }
            class_296 element = (class_296)elements.get(i);
            if (!SceneExporter.isRelevant(element)) continue;
            boolean normalized = element.method_1382() == class_296.class_298.field_1635 || element.method_1382() == class_296.class_298.field_1632;
            ExpVertexFormatElement.createExpVertexFormatElement(builder, element.method_1385(), SceneExporter.mapType(element.method_1386()), SceneExporter.mapUsage(element.method_1382()), element.method_34451(), offset, element.method_1387(), normalized);
        }
        int elementsOffset = builder.endVector();
        ExpVertexFormat.startExpVertexFormat(builder);
        ExpVertexFormat.addElements(builder, elementsOffset);
        ExpVertexFormat.addVertexSize(builder, format.method_1362());
        return ExpVertexFormat.endExpVertexFormat(builder);
    }

    private static boolean isRelevant(class_296 element) {
        return element.method_1382() != class_296.class_298.field_1629 && element.method_1382() != class_296.class_298.field_20782;
    }

    private Map<class_1921, Integer> writeMaterials(List<Mesh> meshes, FlatBufferBuilder builder) {
        IdentityHashMap<class_1921, Integer> result = new IdentityHashMap<class_1921, Integer>();
        for (Mesh mesh : meshes) {
            result.computeIfAbsent(mesh.renderType(), type -> this.writeMaterial((class_1921)type, builder));
        }
        return result;
    }

    private int writeMaterial(class_1921 type, FlatBufferBuilder builder) {
        int depthTest;
        int transparency;
        class_1921.class_4688 state = ((class_1921.class_4687)type).method_35784();
        int shaderNameOffset = 0;
        if (state.field_29461.field_29455.isPresent()) {
            shaderNameOffset = builder.createSharedString(((class_5944)((Supplier)state.field_29461.field_29455.get()).get()).method_35787());
        }
        int nameOffset = builder.createSharedString(type.field_21363);
        boolean disableCulling = state.field_21412 == class_4668.field_21345;
        class_4668.class_4685 transparencyState = state.field_21407;
        if (transparencyState == class_4668.field_21364) {
            transparency = 0;
        } else if (transparencyState == class_4668.field_21366) {
            transparency = 1;
        } else if (transparencyState == class_4668.field_21367) {
            transparency = 2;
        } else if (transparencyState == class_4668.field_21368) {
            transparency = 3;
        } else if (transparencyState == class_4668.field_21369) {
            transparency = 4;
        } else if (transparencyState == class_4668.field_21370) {
            transparency = 5;
        } else {
            LOG.warn("Cannot handle transparency state {} of render type {}", (Object)transparencyState, (Object)type);
            transparency = 0;
        }
        class_4668.class_4672 depthTestShard = state.field_21411;
        if (depthTestShard == class_4668.field_21346) {
            depthTest = 0;
        } else if (depthTestShard == class_4668.field_21347) {
            depthTest = 1;
        } else if (depthTestShard == class_4668.field_21348) {
            depthTest = 2;
        } else if (depthTestShard == class_4668.field_44814) {
            depthTest = 3;
        } else {
            LOG.warn("Cannot handle depth-test state {} of render type {}", (Object)depthTestShard, (Object)type);
            depthTest = 0;
        }
        int samplersOffset = 0;
        List<RenderTypeIntrospection.Sampler> samplers = RenderTypeIntrospection.getSamplers(type);
        if (samplers.size() > 0) {
            RenderTypeIntrospection.Sampler sampler = samplers.get(0);
            String texturePath = this.resourceExporter.exportTexture(sampler.texture());
            int textureOffset = builder.createSharedString(texturePath);
            int textureIdOffset = builder.createSharedString(sampler.texture().toString());
            int samplerOffset = ExpSampler.createExpSampler(builder, textureIdOffset, textureOffset, sampler.blur(), sampler.blur());
            samplersOffset = ExpMaterial.createSamplersVector(builder, new int[]{samplerOffset});
        }
        return ExpMaterial.createExpMaterial(builder, nameOffset, shaderNameOffset, disableCulling, transparency, depthTest, samplersOffset);
    }

    private static int mapMode(class_293.class_5596 mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case class_293.class_5596.field_27377 -> 0;
            case class_293.class_5596.field_27378 -> 1;
            case class_293.class_5596.field_29344 -> 2;
            case class_293.class_5596.field_29345 -> 3;
            case class_293.class_5596.field_27382, class_293.class_5596.field_27379 -> 4;
            case class_293.class_5596.field_27380 -> 5;
            case class_293.class_5596.field_27381 -> 6;
        };
    }

    private static int mapUsage(class_296.class_298 usage) {
        return switch (usage) {
            default -> throw new IncompatibleClassChangeError();
            case class_296.class_298.field_1633 -> 0;
            case class_296.class_298.field_1635 -> 1;
            case class_296.class_298.field_1632 -> 2;
            case class_296.class_298.field_1636 -> 3;
            case class_296.class_298.field_1629, class_296.class_298.field_20782 -> throw new IllegalStateException("Should have been skipped");
        };
    }

    private static int mapType(class_296.class_297 type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case class_296.class_297.field_1623 -> 0;
            case class_296.class_297.field_1624 -> 1;
            case class_296.class_297.field_1621 -> 2;
            case class_296.class_297.field_1622 -> 3;
            case class_296.class_297.field_1625 -> 4;
            case class_296.class_297.field_1619 -> 5;
            case class_296.class_297.field_1617 -> 6;
        };
    }

    private int writeMeshes(List<Mesh> meshes, FlatBufferBuilder builder, Map<class_293, Integer> vertexFormats, Map<class_1921, Integer> materials) {
        IntArrayList writtenMeshes = new IntArrayList(meshes.size());
        for (Mesh mesh : meshes) {
            int vb = ExpMesh.createVertexBufferVector(builder, mesh.vertexBuffer());
            IndexBufferAttributes ibData = this.createIndexBuffer(mesh.drawState(), mesh.indexBuffer());
            int ib = ExpMesh.createIndexBufferVector(builder, ibData.data);
            ExpMesh.startExpMesh(builder);
            ExpMesh.addVertexBuffer(builder, vb);
            ExpMesh.addIndexBuffer(builder, ib);
            ExpMesh.addIndexType(builder, this.mapIndexType(ibData.indexType));
            ExpMesh.addIndexCount(builder, ibData.indexCount);
            ExpMesh.addMaterial(builder, materials.get(mesh.renderType()));
            ExpMesh.addVertexFormat(builder, vertexFormats.get(mesh.drawState().comp_749()));
            ExpMesh.addPrimitiveType(builder, SceneExporter.mapMode(mesh.drawState().comp_752()));
            writtenMeshes.add(ExpMesh.endExpMesh(builder));
        }
        return ExpScene.createMeshesVector(builder, writtenMeshes.elements());
    }

    private int mapIndexType(class_293.class_5595 indexType) {
        return switch (indexType) {
            default -> throw new IncompatibleClassChangeError();
            case class_293.class_5595.field_27373 -> 0;
            case class_293.class_5595.field_27372 -> 1;
        };
    }

    private IndexBufferAttributes createIndexBuffer(class_287.class_4574 drawState, ByteBuffer idxBuffer) {
        ByteBuffer effectiveIndices;
        class_293.class_5595 indexType = drawState.comp_753();
        int indexCount = drawState.comp_751();
        class_293.class_5596 mode = drawState.comp_752();
        if (drawState.comp_755()) {
            GeneratedIndexBuffer generated = this.generateSequentialIndices(mode, drawState.comp_750(), drawState.comp_751());
            effectiveIndices = generated.data;
            indexType = generated.type;
            indexCount = generated.indexCount();
        } else if (indexType == class_293.class_5595.field_27372) {
            if (mode == class_293.class_5596.field_27382) {
                ShortBuffer idxShortBuffer = idxBuffer.asShortBuffer();
                ShortBuffer triIndices = ShortBuffer.allocate(idxShortBuffer.remaining() * 2);
                while (idxShortBuffer.hasRemaining()) {
                    short one = idxShortBuffer.get();
                    short two = idxShortBuffer.get();
                    short three = idxShortBuffer.get();
                    short four = idxShortBuffer.get();
                    triIndices.put(one);
                    triIndices.put(two);
                    triIndices.put(three);
                    triIndices.put(three);
                    triIndices.put(four);
                    triIndices.put(one);
                }
                triIndices.flip();
                effectiveIndices = ByteBuffer.allocate(triIndices.remaining() * 2).order(ByteOrder.nativeOrder());
                while (triIndices.hasRemaining()) {
                    effectiveIndices.putShort(triIndices.get());
                }
            } else {
                effectiveIndices = idxBuffer;
            }
        } else if (indexType == class_293.class_5595.field_27373) {
            if (mode == class_293.class_5596.field_27382) {
                IntBuffer idxIntBuffer = idxBuffer.asIntBuffer();
                IntBuffer triIndices = IntBuffer.allocate(idxIntBuffer.remaining() * 2);
                while (idxIntBuffer.hasRemaining()) {
                    int one = idxIntBuffer.get();
                    int two = idxIntBuffer.get();
                    int three = idxIntBuffer.get();
                    int four = idxIntBuffer.get();
                    triIndices.put(one);
                    triIndices.put(two);
                    triIndices.put(three);
                    triIndices.put(three);
                    triIndices.put(four);
                    triIndices.put(one);
                }
                triIndices.flip();
                effectiveIndices = ByteBuffer.allocate(triIndices.remaining() * 4).order(ByteOrder.nativeOrder());
                while (triIndices.hasRemaining()) {
                    effectiveIndices.putInt(triIndices.get());
                }
            } else {
                effectiveIndices = idxBuffer;
            }
        } else {
            throw new RuntimeException("Unknown index type: " + indexType);
        }
        return new IndexBufferAttributes(effectiveIndices, indexType, indexCount);
    }

    private GeneratedIndexBuffer generateSequentialIndices(class_293.class_5596 mode, int vertexCount, int expectedIndexCount) {
        int indicesPerPrimitive = switch (mode) {
            case class_293.class_5596.field_27377 -> 2;
            case class_293.class_5596.field_29344 -> 2;
            case class_293.class_5596.field_27379 -> 3;
            case class_293.class_5596.field_27382 -> 6;
            default -> throw new UnsupportedOperationException();
        };
        int verticesPerPrimitive = switch (mode) {
            case class_293.class_5596.field_27377 -> 2;
            case class_293.class_5596.field_29344 -> 2;
            case class_293.class_5596.field_27379 -> 3;
            case class_293.class_5596.field_27382 -> 4;
            default -> throw new UnsupportedOperationException();
        };
        int primitives = vertexCount / verticesPerPrimitive;
        int indexCount = primitives * indicesPerPrimitive;
        if (indexCount != expectedIndexCount) {
            throw new RuntimeException("Would generate " + indexCount + " but MC expected " + expectedIndexCount);
        }
        class_293.class_5595 indexType = class_293.class_5595.method_31972((int)indexCount);
        ByteBuffer buffer = ByteBuffer.allocate(indexType.field_27375 * indexCount).order(ByteOrder.nativeOrder());
        IntConsumer indexConsumer = indexType == class_293.class_5595.field_27372 ? value -> buffer.putShort((short)value) : buffer::putInt;
        block15: for (int i = 0; i < vertexCount; i += verticesPerPrimitive) {
            switch (mode) {
                case field_27382: {
                    indexConsumer.accept(i + 0);
                    indexConsumer.accept(i + 1);
                    indexConsumer.accept(i + 2);
                    indexConsumer.accept(i + 2);
                    indexConsumer.accept(i + 3);
                    indexConsumer.accept(i + 0);
                    continue block15;
                }
                default: {
                    IntStream.range(0, indexCount).forEach(indexConsumer);
                }
            }
        }
        buffer.flip();
        return new GeneratedIndexBuffer(indexType, buffer, indexCount);
    }

    private int createCameraModel(CameraSettings cameraSettings, FlatBufferBuilder builder) {
        return ExpCameraSettings.createExpCameraSettings(builder, cameraSettings.getRotationY(), cameraSettings.getRotationX(), cameraSettings.getRotationZ(), cameraSettings.getZoom());
    }

    record IndexBufferAttributes(ByteBuffer data, class_293.class_5595 indexType, int indexCount) {
    }

    record GeneratedIndexBuffer(class_293.class_5595 type, ByteBuffer data, int indexCount) {
    }
}

