/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.blockentity.powersink.IExternalPowerSink;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class ForgeEnergyAdapter
extends SnapshotParticipant<Double>
implements EnergyStorage {
    private final IExternalPowerSink sink;
    private double buffer = 0.0;

    public ForgeEnergyAdapter(IExternalPowerSink sink) {
        this.sink = sink;
    }

    protected Double createSnapshot() {
        return this.buffer;
    }

    protected void readSnapshot(Double snapshot) {
        this.buffer = snapshot;
    }

    protected void onFinalCommit() {
        this.buffer = this.sink.injectExternalPower(PowerUnits.TR, this.buffer, Actionable.MODULATE);
        if (this.buffer < 1.0E-6) {
            this.buffer = 0.0;
        }
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        this.updateSnapshots(transaction);
        if (this.buffer == 0.0) {
            maxAmount = (long)Math.floor(Math.min((double)maxAmount, this.sink.getExternalPowerDemand(PowerUnits.TR, maxAmount)));
            this.buffer = maxAmount;
            return maxAmount;
        }
        return 0L;
    }

    public final long getAmount() {
        return (long)Math.floor(PowerUnits.AE.convertTo(PowerUnits.TR, this.sink.getAECurrentPower()));
    }

    public final long getCapacity() {
        return (long)Math.floor(PowerUnits.AE.convertTo(PowerUnits.TR, this.sink.getAEMaxPower()));
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    public boolean supportsExtraction() {
        return false;
    }
}

