/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.AEColor;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public final class BlockRecolorer {
    private static final BiMap<AEColor, class_2248> STAINED_GLASS_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10087).put((Object)AEColor.ORANGE, (Object)class_2246.field_10227).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10574).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10271).put((Object)AEColor.YELLOW, (Object)class_2246.field_10049).put((Object)AEColor.LIME, (Object)class_2246.field_10157).put((Object)AEColor.PINK, (Object)class_2246.field_10317).put((Object)AEColor.GRAY, (Object)class_2246.field_10555).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_9996).put((Object)AEColor.CYAN, (Object)class_2246.field_10248).put((Object)AEColor.PURPLE, (Object)class_2246.field_10399).put((Object)AEColor.BLUE, (Object)class_2246.field_10060).put((Object)AEColor.BROWN, (Object)class_2246.field_10073).put((Object)AEColor.GREEN, (Object)class_2246.field_10357).put((Object)AEColor.RED, (Object)class_2246.field_10272).put((Object)AEColor.BLACK, (Object)class_2246.field_9997).build());
    private static final BiMap<AEColor, class_2248> STAINED_GLASS_PANE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_9991).put((Object)AEColor.ORANGE, (Object)class_2246.field_10496).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10469).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10193).put((Object)AEColor.YELLOW, (Object)class_2246.field_10578).put((Object)AEColor.LIME, (Object)class_2246.field_10305).put((Object)AEColor.PINK, (Object)class_2246.field_10565).put((Object)AEColor.GRAY, (Object)class_2246.field_10077).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10129).put((Object)AEColor.CYAN, (Object)class_2246.field_10355).put((Object)AEColor.PURPLE, (Object)class_2246.field_10152).put((Object)AEColor.BLUE, (Object)class_2246.field_9982).put((Object)AEColor.BROWN, (Object)class_2246.field_10163).put((Object)AEColor.GREEN, (Object)class_2246.field_10419).put((Object)AEColor.RED, (Object)class_2246.field_10118).put((Object)AEColor.BLACK, (Object)class_2246.field_10070).build());
    private static final BiMap<AEColor, class_2248> WOOL_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10446).put((Object)AEColor.ORANGE, (Object)class_2246.field_10095).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10215).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10294).put((Object)AEColor.YELLOW, (Object)class_2246.field_10490).put((Object)AEColor.LIME, (Object)class_2246.field_10028).put((Object)AEColor.PINK, (Object)class_2246.field_10459).put((Object)AEColor.GRAY, (Object)class_2246.field_10423).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10222).put((Object)AEColor.CYAN, (Object)class_2246.field_10619).put((Object)AEColor.PURPLE, (Object)class_2246.field_10259).put((Object)AEColor.BLUE, (Object)class_2246.field_10514).put((Object)AEColor.BROWN, (Object)class_2246.field_10113).put((Object)AEColor.GREEN, (Object)class_2246.field_10170).put((Object)AEColor.RED, (Object)class_2246.field_10314).put((Object)AEColor.BLACK, (Object)class_2246.field_10146).build());
    private static final BiMap<AEColor, class_2248> BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10154).put((Object)AEColor.ORANGE, (Object)class_2246.field_10045).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10438).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10452).put((Object)AEColor.YELLOW, (Object)class_2246.field_10547).put((Object)AEColor.LIME, (Object)class_2246.field_10229).put((Object)AEColor.PINK, (Object)class_2246.field_10612).put((Object)AEColor.GRAY, (Object)class_2246.field_10185).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_9985).put((Object)AEColor.CYAN, (Object)class_2246.field_10165).put((Object)AEColor.PURPLE, (Object)class_2246.field_10368).put((Object)AEColor.BLUE, (Object)class_2246.field_10281).put((Object)AEColor.BROWN, (Object)class_2246.field_10602).put((Object)AEColor.GREEN, (Object)class_2246.field_10198).put((Object)AEColor.RED, (Object)class_2246.field_10406).put((Object)AEColor.BLACK, (Object)class_2246.field_10062).build());
    private static final BiMap<AEColor, class_2248> WALL_BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10202).put((Object)AEColor.ORANGE, (Object)class_2246.field_10599).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10274).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10050).put((Object)AEColor.YELLOW, (Object)class_2246.field_10139).put((Object)AEColor.LIME, (Object)class_2246.field_10318).put((Object)AEColor.PINK, (Object)class_2246.field_10531).put((Object)AEColor.GRAY, (Object)class_2246.field_10267).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10604).put((Object)AEColor.CYAN, (Object)class_2246.field_10372).put((Object)AEColor.PURPLE, (Object)class_2246.field_10054).put((Object)AEColor.BLUE, (Object)class_2246.field_10067).put((Object)AEColor.BROWN, (Object)class_2246.field_10370).put((Object)AEColor.GREEN, (Object)class_2246.field_10594).put((Object)AEColor.RED, (Object)class_2246.field_10279).put((Object)AEColor.BLACK, (Object)class_2246.field_10537).build());
    private static final BiMap<AEColor, class_2248> CARPET_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10466).put((Object)AEColor.ORANGE, (Object)class_2246.field_9977).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10482).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10290).put((Object)AEColor.YELLOW, (Object)class_2246.field_10512).put((Object)AEColor.LIME, (Object)class_2246.field_10040).put((Object)AEColor.PINK, (Object)class_2246.field_10393).put((Object)AEColor.GRAY, (Object)class_2246.field_10591).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10209).put((Object)AEColor.CYAN, (Object)class_2246.field_10433).put((Object)AEColor.PURPLE, (Object)class_2246.field_10510).put((Object)AEColor.BLUE, (Object)class_2246.field_10043).put((Object)AEColor.BROWN, (Object)class_2246.field_10473).put((Object)AEColor.GREEN, (Object)class_2246.field_10338).put((Object)AEColor.RED, (Object)class_2246.field_10536).put((Object)AEColor.BLACK, (Object)class_2246.field_10106).build());
    private static final BiMap<AEColor, class_2248> TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10611).put((Object)AEColor.ORANGE, (Object)class_2246.field_10184).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10015).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10325).put((Object)AEColor.YELLOW, (Object)class_2246.field_10143).put((Object)AEColor.LIME, (Object)class_2246.field_10014).put((Object)AEColor.PINK, (Object)class_2246.field_10444).put((Object)AEColor.GRAY, (Object)class_2246.field_10349).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10590).put((Object)AEColor.CYAN, (Object)class_2246.field_10235).put((Object)AEColor.PURPLE, (Object)class_2246.field_10570).put((Object)AEColor.BLUE, (Object)class_2246.field_10409).put((Object)AEColor.BROWN, (Object)class_2246.field_10123).put((Object)AEColor.GREEN, (Object)class_2246.field_10526).put((Object)AEColor.RED, (Object)class_2246.field_10328).put((Object)AEColor.BLACK, (Object)class_2246.field_10626).build());
    private static final BiMap<AEColor, class_2248> GLAZED_TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10595).put((Object)AEColor.ORANGE, (Object)class_2246.field_10280).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10538).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10345).put((Object)AEColor.YELLOW, (Object)class_2246.field_10096).put((Object)AEColor.LIME, (Object)class_2246.field_10046).put((Object)AEColor.PINK, (Object)class_2246.field_10567).put((Object)AEColor.GRAY, (Object)class_2246.field_10220).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10052).put((Object)AEColor.CYAN, (Object)class_2246.field_10078).put((Object)AEColor.PURPLE, (Object)class_2246.field_10426).put((Object)AEColor.BLUE, (Object)class_2246.field_10550).put((Object)AEColor.BROWN, (Object)class_2246.field_10004).put((Object)AEColor.GREEN, (Object)class_2246.field_10475).put((Object)AEColor.RED, (Object)class_2246.field_10383).put((Object)AEColor.BLACK, (Object)class_2246.field_10501).build());
    private static final BiMap<AEColor, class_2248> CONCRETE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)class_2246.field_10107).put((Object)AEColor.ORANGE, (Object)class_2246.field_10210).put((Object)AEColor.MAGENTA, (Object)class_2246.field_10585).put((Object)AEColor.LIGHT_BLUE, (Object)class_2246.field_10242).put((Object)AEColor.YELLOW, (Object)class_2246.field_10542).put((Object)AEColor.LIME, (Object)class_2246.field_10421).put((Object)AEColor.PINK, (Object)class_2246.field_10434).put((Object)AEColor.GRAY, (Object)class_2246.field_10038).put((Object)AEColor.LIGHT_GRAY, (Object)class_2246.field_10172).put((Object)AEColor.CYAN, (Object)class_2246.field_10308).put((Object)AEColor.PURPLE, (Object)class_2246.field_10206).put((Object)AEColor.BLUE, (Object)class_2246.field_10011).put((Object)AEColor.BROWN, (Object)class_2246.field_10439).put((Object)AEColor.GREEN, (Object)class_2246.field_10367).put((Object)AEColor.RED, (Object)class_2246.field_10058).put((Object)AEColor.BLACK, (Object)class_2246.field_10458).build());
    private static final List<RecolorableBlockGroup> BLOCK_GROUPS = ImmutableList.of((Object)new RecolorableBlockGroup(class_2246.field_10033, STAINED_GLASS_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10285, STAINED_GLASS_PANE_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10446, WOOL_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10154, BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10202, WALL_BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10466, CARPET_BY_COLOR), (Object)new RecolorableBlockGroup(class_2246.field_10415, TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, GLAZED_TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, CONCRETE_BY_COLOR));

    private BlockRecolorer() {
    }

    public static class_2248 recolor(class_2248 block, AEColor newColor) {
        Objects.requireNonNull(block);
        for (RecolorableBlockGroup group : BLOCK_GROUPS) {
            if (group.uncoloredVariant != block && !group.coloredVariants.containsValue((Object)block)) continue;
            class_2248 newBlock = (class_2248)group.coloredVariants.get((Object)newColor);
            if (newBlock == null) {
                newBlock = group.uncoloredVariant != null ? group.uncoloredVariant : block;
            }
            return newBlock;
        }
        return block;
    }

    private static class RecolorableBlockGroup {
        final class_2248 uncoloredVariant;
        final BiMap<AEColor, class_2248> coloredVariants;

        public RecolorableBlockGroup(class_2248 uncoloredVariant, BiMap<AEColor, class_2248> coloredVariants) {
            this.uncoloredVariant = uncoloredVariant;
            this.coloredVariants = coloredVariants;
        }
    }
}

