/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark;

import appeng.libs.micromark.ConstructPrecedence;
import appeng.libs.micromark.State;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import java.util.HashSet;
import java.util.List;

public class Construct {
    public Previous previous;
    public Construct continuation;
    public Exiter exit;
    public String name;
    public boolean partial;
    public Resolver resolve;
    public Resolver resolveTo;
    public Resolver resolveAll;
    public boolean concrete;
    public ConstructPrecedence add = ConstructPrecedence.BEFORE;
    public TokenizerFunction tokenize;

    public static List<Tokenizer.Event> resolveAll(List<Construct> constructs, List<Tokenizer.Event> events, TokenizeContext context) {
        HashSet<Resolver> called = new HashSet<Resolver>();
        for (Construct construct : constructs) {
            Resolver resolver = construct.resolveAll;
            if (resolver == null || !called.add(resolver)) continue;
            events = resolver.resolve(events, context);
        }
        return events;
    }

    public static List<Tokenizer.Event> resolveAll(Iterable<Resolver> resolvers, List<Tokenizer.Event> events, TokenizeContext context) {
        HashSet<Resolver> called = new HashSet<Resolver>();
        for (Resolver resolver : resolvers) {
            if (resolver == null || !called.add(resolver)) continue;
            events = resolver.resolve(events, context);
        }
        return events;
    }

    @FunctionalInterface
    public static interface Resolver {
        public List<Tokenizer.Event> resolve(List<Tokenizer.Event> var1, TokenizeContext var2);
    }

    @FunctionalInterface
    public static interface TokenizerFunction {
        public State tokenize(TokenizeContext var1, Tokenizer.Effects var2, State var3, State var4);
    }

    @FunctionalInterface
    public static interface Previous {
        public boolean previous(TokenizeContext var1, int var2);
    }

    @FunctionalInterface
    public static interface Exiter {
        public void exit(TokenizeContext var1, Tokenizer.Effects var2);
    }
}

