/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.ids.AETags;
import appeng.api.movable.BlockEntityMoveStrategies;
import appeng.api.movable.IBlockEntityMoveStrategy;
import appeng.block.spatial.MatrixFrameBlock;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.server.services.compass.CompassService;
import appeng.util.Platform;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_6755;
import net.minecraft.class_6760;
import net.minecraft.class_6880;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final class_2818[][] myChunks;
    private final Column[][] myColumns;
    private final List<BlockEntityMoveRecord> blockEntities = new ArrayList<BlockEntityMoveRecord>();
    private final List<class_6760<class_2248>> ticks = new ArrayList<class_6760<class_2248>>();
    private final class_3218 level;
    private final List<class_2338> updates = new ArrayList<class_2338>();
    private final class_2680 matrixBlockState;
    private final List<PoiMoveRecord> poiMoveRecords = new ArrayList<PoiMoveRecord>();

    public CachedPlane(class_3218 level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        MatrixFrameBlock matrixFrameBlock = AEBlocks.MATRIX_FRAME.block();
        this.matrixBlockState = matrixFrameBlock != null ? matrixFrameBlock.method_9564() : null;
        this.level = level;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new class_2818[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(level.method_8497(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF);
            }
        }
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                class_2818 c;
                this.myChunks[cx][cz] = c = level.method_8497(minCX + cx, minCZ + cz);
                ArrayList rawBlockEntities = new ArrayList(c.method_12214().entrySet());
                for (Map.Entry entry2 : rawBlockEntities) {
                    class_2586 blockEntity = (class_2586)entry2.getValue();
                    class_2338 pos = blockEntity.method_11016();
                    if (pos.method_10263() < minX || pos.method_10263() > maxX || pos.method_10264() < minY || pos.method_10264() > maxY || pos.method_10260() < minZ || pos.method_10260() > maxZ || blockEntity.method_11010().method_26164(AETags.SPATIAL_BLACKLIST)) continue;
                    IBlockEntityMoveStrategy strategy = BlockEntityMoveStrategies.get(blockEntity);
                    class_2487 savedData = strategy.beginMove(blockEntity);
                    class_2826 section = c.method_38259(c.method_31602(((class_2338)entry2.getKey()).method_10264()));
                    int sx = ((class_2338)entry2.getKey()).method_10263() & 0xF;
                    int sy = ((class_2338)entry2.getKey()).method_10264() & 0xF;
                    int sz = ((class_2338)entry2.getKey()).method_10260() & 0xF;
                    class_2680 state = section.method_12254(sx, sy, sz);
                    if (savedData != null) {
                        this.blockEntities.add(new BlockEntityMoveRecord(strategy, blockEntity, savedData, (class_2338)entry2.getKey(), state));
                        section.method_16675(sx, sy, sz, class_2246.field_10124.method_9564());
                        c.method_12041((class_2338)entry2.getKey());
                        continue;
                    }
                    if (state.method_26215()) {
                        level.method_8650(pos, false);
                        continue;
                    }
                    this.myColumns[pos.method_10263() - minX][pos.method_10260() - minZ].setSkip(pos.method_10264());
                }
                class_6755 pending = (class_6755)c.method_12013();
                pending.method_39372().forEach(entry -> {
                    class_2338 pos = entry.comp_253();
                    if (pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10264() >= minY && pos.method_10264() <= maxY && pos.method_10260() >= minZ && pos.method_10260() <= maxZ) {
                        this.ticks.add((class_6760<class_2248>)entry);
                    }
                });
                for (int cy = 0; cy < cy_size; ++cy) {
                    class_4157 poiSection = level.method_19494().method_19294(class_4076.method_18681((class_1923)c.method_12004(), (int)(minCY + cy)).method_18694()).orElse(null);
                    if (poiSection == null) continue;
                    Iterator poiRecords = poiSection.method_19150(poiType -> true, class_4153.class_4155.field_18489).iterator();
                    while (poiRecords.hasNext()) {
                        class_4156 poiRecord = (class_4156)poiRecords.next();
                        class_2338 pos = poiRecord.method_19141();
                        if (pos.method_10263() < minX || pos.method_10263() > maxX || pos.method_10264() < minY || pos.method_10264() > maxY || pos.method_10260() < minZ || pos.method_10260() > maxZ) continue;
                        this.poiMoveRecords.add(new PoiMoveRecord(poiRecord.method_19141().method_10069(-this.x_offset, -this.y_offset, -this.z_offset), (class_6880<class_4158>)poiRecord.method_19142()));
                        poiSection.method_19145(poiRecord.method_19141());
                    }
                }
            }
        }
    }

    void swap(CachedPlane dst) {
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column srcCol = this.myColumns[x][z];
                    Column dstCol = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int n = this.y_offset + y;
                        int dst_y = dst.y_offset + y;
                        if (srcCol.doNotSkip(n) && dstCol.doNotSkip(dst_y)) {
                            class_2680 dstState;
                            class_2826 srcSection = srcCol.getSection(n);
                            class_2826 dstSection = dstCol.getSection(dst_y);
                            class_2680 srcState = srcSection.method_12254(srcCol.x, class_4076.method_18684((int)n), srcCol.z);
                            if (srcState == this.matrixBlockState) {
                                srcState = class_2246.field_10124.method_9564();
                            }
                            if ((dstState = dstSection.method_12254(dstCol.x, class_4076.method_18684((int)dst_y), dstCol.z)) == this.matrixBlockState) {
                                dstState = class_2246.field_10124.method_9564();
                            }
                            srcSection.method_16675(srcCol.x, class_4076.method_18684((int)n), srcCol.z, dstState);
                            dstSection.method_16675(dstCol.x, class_4076.method_18684((int)dst_y), dstCol.z, srcState);
                            continue;
                        }
                        this.markForUpdate(this.x_offset + x, n, this.z_offset + z);
                        dst.markForUpdate(dst.x_offset + x, dst_y, dst.z_offset + z);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (BlockEntityMoveRecord blockEntityMoveRecord : this.blockEntities) {
                class_2338 pos = blockEntityMoveRecord.blockEntity().method_11016();
                dst.addBlockEntity(pos.method_10263() - this.x_offset, pos.method_10264() - this.y_offset, pos.method_10260() - this.z_offset, blockEntityMoveRecord);
            }
            for (BlockEntityMoveRecord blockEntityMoveRecord : dst.blockEntities) {
                class_2338 pos = blockEntityMoveRecord.blockEntity().method_11016();
                this.addBlockEntity(pos.method_10263() - dst.x_offset, pos.method_10264() - dst.y_offset, pos.method_10260() - dst.z_offset, blockEntityMoveRecord);
            }
            for (class_6760 class_67602 : this.ticks) {
                class_2338 movedPos = class_67602.comp_253().method_10069(-this.x_offset, -this.y_offset, -this.z_offset);
                dst.addTick(movedPos, (class_6760<class_2248>)class_67602);
            }
            for (class_6760 class_67603 : dst.ticks) {
                class_2338 movedPos = class_67603.comp_253().method_10069(-dst.x_offset, -dst.y_offset, -dst.z_offset);
                this.addTick(movedPos, (class_6760<class_2248>)class_67603);
            }
            for (PoiMoveRecord poiMoveRecord : this.poiMoveRecords) {
                dst.addPoi(poiMoveRecord);
            }
            for (PoiMoveRecord poiMoveRecord : dst.poiMoveRecords) {
                this.addPoi(poiMoveRecord);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.updates.add(new class_2338(x, y, z));
        for (class_2350 d : class_2350.values()) {
            this.updates.add(new class_2338(x + d.method_10148(), y + d.method_10164(), z + d.method_10165()));
        }
    }

    private void addTick(class_2338 pos, class_6760<class_2248> tick) {
        this.level.method_14196().method_39363(new class_6760((Object)((class_2248)tick.comp_252()), pos, tick.comp_254(), tick.comp_255(), tick.comp_256()));
    }

    private void addBlockEntity(int x, int y, int z, BlockEntityMoveRecord moveRecord) {
        try {
            boolean success;
            class_2338 originalPos = moveRecord.pos();
            Column c = this.myColumns[x][z];
            if (!c.doNotSkip(y + this.y_offset)) {
                AELog.warn("Block entity %s was queued to be moved from %s, but it's position then skipped during the move.", moveRecord.blockEntity(), originalPos);
                return;
            }
            class_2338 newPosition = new class_2338(x + this.x_offset, y + this.y_offset, z + this.z_offset);
            class_2791 chunk = this.level.method_22350(newPosition);
            class_2826 section = chunk.method_38259(chunk.method_31602(newPosition.method_10264()));
            section.method_16675(newPosition.method_10263() & 0xF, newPosition.method_10264() & 0xF, newPosition.method_10260() & 0xF, moveRecord.state);
            IBlockEntityMoveStrategy strategy = moveRecord.strategy();
            try {
                success = strategy.completeMove(moveRecord.blockEntity(), moveRecord.state(), moveRecord.savedData(), (class_1937)this.level, newPosition);
            }
            catch (Throwable e) {
                AELog.warn(e);
                success = false;
            }
            if (!success) {
                this.attemptRecovery(x, y, z, moveRecord, c);
            }
        }
        catch (Throwable e) {
            AELog.warn(e);
        }
    }

    private void addPoi(PoiMoveRecord record) {
        this.level.method_19494().method_19115(record.relativePos.method_10069(this.x_offset, this.y_offset, this.z_offset), record.poiType);
    }

    private void attemptRecovery(int x, int y, int z, BlockEntityMoveRecord moveRecord, Column c) {
        class_2338 pos = new class_2338(x, y, z);
        class_2591 type = moveRecord.blockEntity().method_11017();
        AELog.debug("Trying to recover BE %s @ %s", class_2591.method_11033((class_2591)type), pos);
        class_2680 blockState = moveRecord.blockEntity().method_11010();
        class_2586 recoveredEntity = class_2586.method_11005((class_2338)pos, (class_2680)blockState, (class_2487)moveRecord.savedData());
        if (recoveredEntity != null) {
            this.level.method_8652(pos, blockState, 3);
            c.c.method_12216(recoveredEntity);
            this.level.method_8413(pos, this.level.method_8320(pos), this.level.method_8320(pos), z);
        } else {
            AELog.warn("Failed to recover BE %s @ %s", class_2591.method_11033((class_2591)type), pos);
        }
    }

    private void updateChunks() {
        class_3568 lightManager = this.level.method_22336();
        if (lightManager instanceof class_3227) {
            class_3227 serverLightManager = (class_3227)lightManager;
            for (int x = 0; x < this.cx_size; ++x) {
                for (int z = 0; z < this.cz_size; ++z) {
                    class_2818 c = this.myChunks[x][z];
                    serverLightManager.method_17310((class_2791)c, false);
                    c.method_12008(true);
                }
            }
        }
        for (int x = 0; x < this.cx_size; ++x) {
            for (int z = 0; z < this.cz_size; ++z) {
                class_2818 c = this.myChunks[x][z];
                CompassService.updateArea(this.getLevel(), (class_2791)c);
                class_2596<?> cdp = Platform.getFullChunkPacket(c);
                this.level.method_14178().field_17254.method_17210(c.method_12004(), false).forEach(spe -> spe.field_13987.method_14364(cdp));
            }
        }
        this.level.method_14178().method_12127(() -> false, false);
    }

    List<class_2338> getUpdates() {
        return this.updates;
    }

    class_3218 getLevel() {
        return this.level;
    }

    private static class Column {
        private final int x;
        private final int z;
        private final class_2818 c;
        private List<Integer> skipThese = null;
        private Int2ObjectMap<class_2680> savedBlockStates = null;

        public Column(class_2818 chunk, int x, int z) {
            this.x = x;
            this.z = z;
            this.c = chunk;
        }

        private boolean doNotSkip(int y) {
            class_2680 blockState = this.getSection(y).method_12254(this.x, class_4076.method_18684((int)y), this.z);
            if (blockState.method_26164(AETags.SPATIAL_BLACKLIST)) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int y) {
            if (this.skipThese == null) {
                this.skipThese = new ArrayList<Integer>();
            }
            this.skipThese.add(y);
        }

        public class_2826 getSection(int y) {
            return this.c.method_38259(this.c.method_31603(class_4076.method_18675((int)y)));
        }
    }

    private record BlockEntityMoveRecord(IBlockEntityMoveStrategy strategy, class_2586 blockEntity, class_2487 savedData, class_2338 pos, class_2680 state) {
    }

    private record PoiMoveRecord(class_2338 relativePos, class_6880<class_4158> poiType) {
    }

    private static class BlockStorageData {
        public class_2680 state;

        private BlockStorageData() {
        }
    }
}

