/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.compat;

import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class WrappedTrinket
implements Accessory {
    private final Trinket trinket;

    public WrappedTrinket(Trinket trinket) {
        this.trinket = trinket;
    }

    public void tick(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.tick(stack, reference);
            return;
        }
        this.trinket.tick(stack, ref.get(), reference.entity());
    }

    public void onEquip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onEquip(stack, reference);
            return;
        }
        this.trinket.onEquip(stack, ref.get(), reference.entity());
    }

    public void onUnequip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onUnequip(stack, reference);
            return;
        }
        this.trinket.onUnequip(stack, ref.get(), reference.entity());
    }

    public boolean canEquip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canEquip(stack, reference);
        }
        return this.trinket.canEquip(stack, ref.get(), reference.entity());
    }

    public boolean canUnequip(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canUnequip(stack, reference);
        }
        return this.trinket.canUnequip(stack, ref.get(), reference.entity());
    }

    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.getDynamicModifiers(stack, reference, builder);
        } else {
            Pair data = AttributeUtils.getModifierData((class_2960)Accessories.of((String)reference.createSlotPath()));
            this.trinket.getModifiers(stack, ref.get(), reference.entity(), (UUID)data.right()).asMap().forEach((attribute, modifiers) -> modifiers.forEach(modifier -> builder.addModifier(attribute, modifier, reference, s -> new class_2960("trinkets", s))));
        }
    }

    public DropRule getDropRule(class_1799 stack, SlotReference reference, class_1282 source) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getDropRule(stack, reference, source);
        }
        return TrinketEnums.convert(this.trinket.getDropRule(stack, ref.get(), reference.entity()));
    }

    public void onBreak(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onBreak(stack, reference);
        } else {
            this.trinket.onBreak(stack, ref.get(), reference.entity());
        }
    }

    public boolean canEquipFromUse(class_1799 stack) {
        try {
            return this.trinket.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = WrappingTrinketsUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getEquipSound(stack, reference);
        }
        class_3414 holder = this.trinket.getEquipSound(stack, ref.get(), reference.entity());
        if (holder == null) {
            return null;
        }
        return new SoundEventData(holder, 1.0f, 1.0f);
    }
}

