/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnFishingTimeGet;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class FishingLureBonus
extends BonusComponent<AccessoryItem> {
    RangedFloat multiplier = new RangedFloat().id("multiplier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new FishingLureBonus(handler, bonus);
    }

    protected FishingLureBonus(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.multiplier.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnFishingTimeGet.listen(this::decreaseFishingTime);
        this.addTooltip("majruszsaccessories.bonuses.fishing_lure", TooltipHelper.asPercent(this.multiplier));
        handler.getConfig().define("fishing_time", this.multiplier::define);
    }

    private void decreaseFishingTime(OnFishingTimeGet data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        data.time = Math.round((float)data.time * (1.0f - holder.apply(this.multiplier)));
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnFishingTimeGet data, AccessoryHolder holder) {
        class_2338 position = LevelHelper.getPositionOverFluid((class_1937)data.getLevel(), (class_2338)data.hook.method_24515());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.method_23317(), (Number)((double)position.method_10264() + 0.25), (Number)data.hook.method_23321()).vec3()).emit((class_1937)data.getServerLevel());
    }
}

