/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnItemBrewed;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2520;

public class StrongerPotions
extends BonusComponent<AccessoryItem> {
    RangedFloat durationPenalty = new RangedFloat().id("duration_penalty").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
    RangedFloat amplifier = new RangedFloat().id("amplifier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(20.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float durationPenalty, float amplifier) {
        return handler -> new StrongerPotions(handler, durationPenalty, amplifier);
    }

    protected StrongerPotions(BonusHandler<AccessoryItem> handler, float durationPenalty, float amplifier) {
        super(handler);
        this.durationPenalty.set(durationPenalty, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        this.amplifier.set(amplifier, (Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)));
        OnItemBrewed.listen(this::boostPotions).addCondition(data -> data.items.subList(0, 3).stream().anyMatch(itemStack -> !class_1844.method_8067((class_1799)itemStack).isEmpty()));
        this.addTooltip("majruszsaccessories.bonuses.potion_amplifier", TooltipHelper.asValue(this.amplifier).scaleOnlyOnDetailed());
        this.addTooltip("majruszsaccessories.bonuses.potion_duration", TooltipHelper.asPercent(this.durationPenalty).bonusMultiplier(-1.0f));
        handler.getConfig().define("stronger_potion", subconfig -> {
            this.durationPenalty.define((SerializableObject<?>)subconfig);
            this.amplifier.define((SerializableObject<?>)subconfig);
        });
    }

    private void boostPotions(OnItemBrewed data) {
        class_1657 player = LevelHelper.getNearestPlayer((class_1937)data.level, (class_2338)data.blockPos, (float)10.0f);
        AccessoryHolder holder = AccessoryHolders.get((class_1309)player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        data.mapPotions(potions -> {
            float durationMultiplier = 1.0f - holder.apply(this.durationPenalty, -1.0f);
            int extraAmplifier = Math.round(holder.apply(this.amplifier));
            return potions.stream().map(itemStack -> {
                List effects = class_1844.method_8067((class_1799)itemStack);
                if (effects.isEmpty()) {
                    return itemStack;
                }
                class_1799 potion = new class_1799((class_1935)itemStack.method_7909());
                Serializables.write((Object)new Data(), (class_2520)potion.method_7948());
                return class_1844.method_8056((class_1799)potion, class_1844.method_8067((class_1799)itemStack).stream().map(effect -> new class_1293(effect.method_5579(), Math.max(40, (int)((float)effect.method_5584() * durationMultiplier)), effect.method_5578() + extraAmplifier)).toList());
            }).toList();
        });
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnItemBrewed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(6).position(AnyPos.from((class_2338)data.blockPos).center().vec3()).emit((class_1937)data.getServerLevel());
    }

    private static class Data {
        private String name = "{\"translate\":\"majruszsaccessories.bonuses.potion_name\",\"italic\":false}";

        private Data() {
        }

        static {
            Serializables.get(Data.class).define("display", config -> config.define("Name", Reader.string(), s -> s.name, (s, v) -> {
                s.name = v;
            }));
        }
    }
}

