/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnTradesUpdated;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1914;
import net.minecraft.class_1937;

public class TradingDiscount
extends BonusComponent<AccessoryItem> {
    RangedFloat multiplier = new RangedFloat().id("multiplier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float multiplier) {
        return handler -> new TradingDiscount(handler, multiplier);
    }

    protected TradingDiscount(BonusHandler<AccessoryItem> handler, float multiplier) {
        super(handler);
        this.multiplier.set(multiplier, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnTradesUpdated.listen(this::decreasePrices);
        this.addTooltip("majruszsaccessories.bonuses.trading_discount", TooltipHelper.asPercent(this.multiplier));
        handler.getConfig().define("trading_discount", this.multiplier::define);
    }

    private void decreasePrices(OnTradesUpdated data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        float discount = holder.apply(this.multiplier);
        for (class_1914 offer : data.offers) {
            int price = offer.method_8246().method_7947();
            float currentDiscount = (float)offer.method_19277() / (float)price;
            offer.method_8245(Math.round(-(1.0f + currentDiscount) * discount * (float)price));
        }
        if (Side.isLogicalServer()) {
            this.spawnEffects(data, holder);
        }
    }

    private void spawnEffects(OnTradesUpdated data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(6).sizeBased((class_1297)data.villager).emit((class_1937)data.getServerLevel());
    }
}

