/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;

public class ModConfigurations {
    protected final String modID;
    protected List<AbstractConfiguration<?>> configurations = new ArrayList();

    protected ModConfigurations(String modID, AbstractConfiguration<?> firstConfig) {
        this.modID = modID;
        this.configurations.add(firstConfig);
    }

    public void reload() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modID + ".json");
        boolean savedConfigs = false;
        if (!configFile.exists()) {
            this.writeConfigs(this.configurations, true);
            savedConfigs = true;
        }
        JsonObject jsonObject = null;
        try {
            BufferedReader reader = Files.newBufferedReader(configFile.toPath());
            jsonObject = (JsonObject)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
        }
        catch (IOException reader) {
            // empty catch block
        }
        ArrayList loadedConfigs = new ArrayList();
        for (AbstractConfiguration<?> abstractConfiguration : this.configurations) {
            if (jsonObject != null && jsonObject.get(abstractConfiguration.getName()) != null) {
                JsonElement element = jsonObject.get(abstractConfiguration.getName());
                loadedConfigs.add(abstractConfiguration.fromElement(element));
                continue;
            }
            loadedConfigs.add(abstractConfiguration);
        }
        if (!savedConfigs) {
            this.writeConfigs(loadedConfigs, false);
        }
        block3: for (AbstractConfiguration<Object> abstractConfiguration : loadedConfigs) {
            for (AbstractConfiguration<?> checkedConfig : this.configurations) {
                if (!Objects.equals(checkedConfig.getName(), abstractConfiguration.getName())) continue;
                this.configurations.remove(checkedConfig);
                this.configurations.add(abstractConfiguration);
                continue block3;
            }
        }
    }

    protected void writeConfigs(List<AbstractConfiguration<?>> configs, boolean useDefaultValues) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modID + ".json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(configFile.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ModConfigurations.getConfigsAsJSON(configs, useDefaultValues), (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            Configs.LOGGER.error("Could not write " + this.modID + " configuration file.", (Throwable)e);
        }
    }

    private static JsonObject getConfigsAsJSON(List<AbstractConfiguration<?>> configs, boolean useDefaultValues) {
        JsonObject jsonObject = new JsonObject();
        for (AbstractConfiguration<?> config : configs) {
            jsonObject.addProperty(config.getName(), config.valueToJson(useDefaultValues));
        }
        return jsonObject;
    }
}

