/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.ModConfigurations;

public class ServerConfigCommandRegistry {
    public static void registerServerConfigCommand() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"serverconfig").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ModIDSuggestionProvider()).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigSuggestionProvider()).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)ServerConfigCommandRegistry.getConfigValueString(StringArgumentType.getString((CommandContext)context, (String)"modid"), StringArgumentType.getString((CommandContext)context, (String)"config"))).method_27692(class_124.field_1075));
            return 1;
        }))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Configs:"));
            List<String> configs = ServerConfigCommandRegistry.getAllConfigValueStrings(StringArgumentType.getString((CommandContext)context, (String)"modid"));
            if (configs.isEmpty()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"   None!"));
            } else {
                for (String config : configs) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("   " + config)));
                }
            }
            return 1;
        })))));
    }

    public static List<String> getAllConfigValueStrings(String modID) {
        ArrayList<String> returnConfigs = new ArrayList<String>();
        ModConfigurations modConfigs = Configs.CONFIGS.get(modID);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                returnConfigs.add(config.getModID() + ":" + config.getName() + " is set to " + config.getReloadableLoadedValue(false).toString());
            }
        }
        return returnConfigs;
    }

    public static String getConfigValueString(String modID, String name) {
        ModConfigurations modConfigs = Configs.CONFIGS.get(modID);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (!Objects.equals(config.getName(), name)) continue;
                return config.getModID() + ":" + config.getName() + " is set to " + config.getReloadableLoadedValue(false).toString();
            }
        }
        return modID + ":" + name + " does not exist!";
    }

    public static class ModIDSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            for (ModConfigurations modConfigs : Configs.CONFIGS.values()) {
                if (!modConfigs.modID.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(modConfigs.modID);
            }
            return builder.buildFuture();
        }
    }

    public static class ConfigSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            ModConfigurations modConfigs = Configs.CONFIGS.get(StringArgumentType.getString(context, (String)"modid"));
            if (modConfigs != null) {
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (!config.getName().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(config.getName());
                }
            }
            return builder.buildFuture();
        }
    }
}

