/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.items_displayed.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.freedinner.items_displayed.config.ModConfigs;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockItemMapper {
    private static BiMap<class_2248, class_1792> blockItemMap = HashBiMap.create();

    public static void addEntry(class_2248 block, class_1792 item) {
        blockItemMap.put((Object)block, (Object)item);
    }

    public static void writeDataToPacket(class_2540 packet) {
        MapWriter.writeMapToPacket(blockItemMap, packet);
    }

    public static void loadDataFromPacket(class_2540 packet) {
        blockItemMap = MapWriter.readMapFromPacket(packet);
    }

    public static class_1792 getItemOrNull(class_2248 block) {
        return BlockItemMapper.getItemOrNull(block, false);
    }

    public static class_1792 getItemOrNull(class_2248 block, boolean includeBlacklisted) {
        class_1792 foundItem = (class_1792)blockItemMap.getOrDefault((Object)block, null);
        if (BlockItemMapper.isItemBlacklisted(foundItem) && !includeBlacklisted) {
            return null;
        }
        return foundItem;
    }

    public static class_2248 getBlockOrNull(class_1792 item) {
        return BlockItemMapper.getBlockOrNull(item, false);
    }

    public static class_2248 getBlockOrNull(class_1792 item, boolean includeBlacklisted) {
        if (BlockItemMapper.isItemBlacklisted(item) && !includeBlacklisted) {
            return null;
        }
        return (class_2248)blockItemMap.inverse().getOrDefault((Object)item, null);
    }

    public static boolean isItemBlacklisted(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return ModConfigs.BLACKLISTED_ITEMS.contains(itemId);
    }

    private static class MapWriter {
        private MapWriter() {
        }

        public static void writeMapToPacket(BiMap<class_2248, class_1792> map, class_2540 packet) {
            packet.writeInt(map.size());
            map.forEach((key, value) -> {
                class_2960 blockId = class_7923.field_41175.method_10221(key);
                packet.method_10812(blockId);
                class_2960 itemId = class_7923.field_41178.method_10221(value);
                packet.method_10812(itemId);
            });
        }

        public static BiMap<class_2248, class_1792> readMapFromPacket(class_2540 packet) {
            HashBiMap map = HashBiMap.create();
            int size = packet.readInt();
            for (int i = 0; i < size; ++i) {
                class_2960 blockId = packet.method_10810();
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
                class_2960 itemId = packet.method_10810();
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                map.put((Object)block, (Object)item);
            }
            return map;
        }
    }
}

